package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeVehicleParts invokes the objectdet.RecognizeVehicleParts API synchronously
func (client *Client) RecognizeVehicleParts(request *RecognizeVehiclePartsRequest) (response *RecognizeVehiclePartsResponse, err error) {
	response = CreateRecognizeVehiclePartsResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeVehiclePartsWithChan invokes the objectdet.RecognizeVehicleParts API asynchronously
func (client *Client) RecognizeVehiclePartsWithChan(request *RecognizeVehiclePartsRequest) (<-chan *RecognizeVehiclePartsResponse, <-chan error) {
	responseChan := make(chan *RecognizeVehiclePartsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeVehicleParts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeVehiclePartsWithCallback invokes the objectdet.RecognizeVehicleParts API asynchronously
func (client *Client) RecognizeVehiclePartsWithCallback(request *RecognizeVehiclePartsRequest, callback func(response *RecognizeVehiclePartsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeVehiclePartsResponse
		var err error
		defer close(result)
		response, err = client.RecognizeVehicleParts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeVehiclePartsRequest is the request struct for api RecognizeVehicleParts
type RecognizeVehiclePartsRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// RecognizeVehiclePartsResponse is the response struct for api RecognizeVehicleParts
type RecognizeVehiclePartsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeVehiclePartsRequest creates a request to invoke RecognizeVehicleParts API
func CreateRecognizeVehiclePartsRequest() (request *RecognizeVehiclePartsRequest) {
	request = &RecognizeVehiclePartsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "RecognizeVehicleParts", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeVehiclePartsResponse creates a response to parse from RecognizeVehicleParts response
func CreateRecognizeVehiclePartsResponse() (response *RecognizeVehiclePartsResponse) {
	response = &RecognizeVehiclePartsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
