package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProjectProgress invokes the oceanbasepro.DescribeProjectProgress API synchronously
func (client *Client) DescribeProjectProgress(request *DescribeProjectProgressRequest) (response *DescribeProjectProgressResponse, err error) {
	response = CreateDescribeProjectProgressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProjectProgressWithChan invokes the oceanbasepro.DescribeProjectProgress API asynchronously
func (client *Client) DescribeProjectProgressWithChan(request *DescribeProjectProgressRequest) (<-chan *DescribeProjectProgressResponse, <-chan error) {
	responseChan := make(chan *DescribeProjectProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProjectProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProjectProgressWithCallback invokes the oceanbasepro.DescribeProjectProgress API asynchronously
func (client *Client) DescribeProjectProgressWithCallback(request *DescribeProjectProgressRequest, callback func(response *DescribeProjectProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProjectProgressResponse
		var err error
		defer close(result)
		response, err = client.DescribeProjectProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProjectProgressRequest is the request struct for api DescribeProjectProgress
type DescribeProjectProgressRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// DescribeProjectProgressResponse is the response struct for api DescribeProjectProgress
type DescribeProjectProgressResponse struct {
	*responses.BaseResponse
}

// CreateDescribeProjectProgressRequest creates a request to invoke DescribeProjectProgress API
func CreateDescribeProjectProgressRequest() (request *DescribeProjectProgressRequest) {
	request = &DescribeProjectProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeProjectProgress", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProjectProgressResponse creates a response to parse from DescribeProjectProgress response
func CreateDescribeProjectProgressResponse() (response *DescribeProjectProgressResponse) {
	response = &DescribeProjectProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
