package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEngineConfig invokes the pairecservice.GetEngineConfig API synchronously
func (client *Client) GetEngineConfig(request *GetEngineConfigRequest) (response *GetEngineConfigResponse, err error) {
	response = CreateGetEngineConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetEngineConfigWithChan invokes the pairecservice.GetEngineConfig API asynchronously
func (client *Client) GetEngineConfigWithChan(request *GetEngineConfigRequest) (<-chan *GetEngineConfigResponse, <-chan error) {
	responseChan := make(chan *GetEngineConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEngineConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEngineConfigWithCallback invokes the pairecservice.GetEngineConfig API asynchronously
func (client *Client) GetEngineConfigWithCallback(request *GetEngineConfigRequest, callback func(response *GetEngineConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEngineConfigResponse
		var err error
		defer close(result)
		response, err = client.GetEngineConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEngineConfigRequest is the request struct for api GetEngineConfig
type GetEngineConfigRequest struct {
	*requests.RoaRequest
	EngineConfigId string `position:"Path" name:"EngineConfigId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// GetEngineConfigResponse is the response struct for api GetEngineConfig
type GetEngineConfigResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Name            string `json:"Name" xml:"Name"`
	ConfigValue     string `json:"ConfigValue" xml:"ConfigValue"`
	Environment     string `json:"Environment" xml:"Environment"`
	Status          string `json:"Status" xml:"Status"`
	GmtCreateTime   string `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	GmtReleasedTime string `json:"GmtReleasedTime" xml:"GmtReleasedTime"`
	Description     string `json:"Description" xml:"Description"`
}

// CreateGetEngineConfigRequest creates a request to invoke GetEngineConfig API
func CreateGetEngineConfigRequest() (request *GetEngineConfigRequest) {
	request = &GetEngineConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetEngineConfig", "/api/v1/engineconfigs/[EngineConfigId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetEngineConfigResponse creates a response to parse from GetEngineConfig response
func CreateGetEngineConfigResponse() (response *GetEngineConfigResponse) {
	response = &GetEngineConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
