package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceResourceTable invokes the pairecservice.GetInstanceResourceTable API synchronously
func (client *Client) GetInstanceResourceTable(request *GetInstanceResourceTableRequest) (response *GetInstanceResourceTableResponse, err error) {
	response = CreateGetInstanceResourceTableResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceResourceTableWithChan invokes the pairecservice.GetInstanceResourceTable API asynchronously
func (client *Client) GetInstanceResourceTableWithChan(request *GetInstanceResourceTableRequest) (<-chan *GetInstanceResourceTableResponse, <-chan error) {
	responseChan := make(chan *GetInstanceResourceTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceResourceTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceResourceTableWithCallback invokes the pairecservice.GetInstanceResourceTable API asynchronously
func (client *Client) GetInstanceResourceTableWithCallback(request *GetInstanceResourceTableRequest, callback func(response *GetInstanceResourceTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceResourceTableResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceResourceTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceResourceTableRequest is the request struct for api GetInstanceResourceTable
type GetInstanceResourceTableRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	InstanceId string `position:"Path" name:"InstanceId"`
	TableName  string `position:"Path" name:"TableName"`
}

// GetInstanceResourceTableResponse is the response struct for api GetInstanceResourceTable
type GetInstanceResourceTableResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	TableName string       `json:"TableName" xml:"TableName"`
	Fields    []FieldsItem `json:"Fields" xml:"Fields"`
}

// CreateGetInstanceResourceTableRequest creates a request to invoke GetInstanceResourceTable API
func CreateGetInstanceResourceTableRequest() (request *GetInstanceResourceTableRequest) {
	request = &GetInstanceResourceTableRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetInstanceResourceTable", "/api/v1/instances/[InstanceId]/resources/[ResourceId]/tables/[TableName]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetInstanceResourceTableResponse creates a response to parse from GetInstanceResourceTable response
func CreateGetInstanceResourceTableResponse() (response *GetInstanceResourceTableResponse) {
	response = &GetInstanceResourceTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
