package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTrafficControlTaskTraffic invokes the pairecservice.GetTrafficControlTaskTraffic API synchronously
func (client *Client) GetTrafficControlTaskTraffic(request *GetTrafficControlTaskTrafficRequest) (response *GetTrafficControlTaskTrafficResponse, err error) {
	response = CreateGetTrafficControlTaskTrafficResponse()
	err = client.DoAction(request, response)
	return
}

// GetTrafficControlTaskTrafficWithChan invokes the pairecservice.GetTrafficControlTaskTraffic API asynchronously
func (client *Client) GetTrafficControlTaskTrafficWithChan(request *GetTrafficControlTaskTrafficRequest) (<-chan *GetTrafficControlTaskTrafficResponse, <-chan error) {
	responseChan := make(chan *GetTrafficControlTaskTrafficResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTrafficControlTaskTraffic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTrafficControlTaskTrafficWithCallback invokes the pairecservice.GetTrafficControlTaskTraffic API asynchronously
func (client *Client) GetTrafficControlTaskTrafficWithCallback(request *GetTrafficControlTaskTrafficRequest, callback func(response *GetTrafficControlTaskTrafficResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTrafficControlTaskTrafficResponse
		var err error
		defer close(result)
		response, err = client.GetTrafficControlTaskTraffic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTrafficControlTaskTrafficRequest is the request struct for api GetTrafficControlTaskTraffic
type GetTrafficControlTaskTrafficRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Environment          string `position:"Query" name:"Environment"`
	InstanceId           string `position:"Query" name:"InstanceId"`
}

// GetTrafficControlTaskTrafficResponse is the response struct for api GetTrafficControlTaskTraffic
type GetTrafficControlTaskTrafficResponse struct {
	*responses.BaseResponse
	RequestId                     string                        `json:"RequestId" xml:"RequestId"`
	TrafficControlTaskTrafficInfo TrafficControlTaskTrafficInfo `json:"TrafficControlTaskTrafficInfo" xml:"TrafficControlTaskTrafficInfo"`
}

// CreateGetTrafficControlTaskTrafficRequest creates a request to invoke GetTrafficControlTaskTraffic API
func CreateGetTrafficControlTaskTrafficRequest() (request *GetTrafficControlTaskTrafficRequest) {
	request = &GetTrafficControlTaskTrafficRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetTrafficControlTaskTraffic", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]/trafficinfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTrafficControlTaskTrafficResponse creates a response to parse from GetTrafficControlTaskTraffic response
func CreateGetTrafficControlTaskTrafficResponse() (response *GetTrafficControlTaskTrafficResponse) {
	response = &GetTrafficControlTaskTrafficResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
