package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterDeprecatedAPI invokes the qianzhou.ListClusterDeprecatedAPI API synchronously
func (client *Client) ListClusterDeprecatedAPI(request *ListClusterDeprecatedAPIRequest) (response *ListClusterDeprecatedAPIResponse, err error) {
	response = CreateListClusterDeprecatedAPIResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterDeprecatedAPIWithChan invokes the qianzhou.ListClusterDeprecatedAPI API asynchronously
func (client *Client) ListClusterDeprecatedAPIWithChan(request *ListClusterDeprecatedAPIRequest) (<-chan *ListClusterDeprecatedAPIResponse, <-chan error) {
	responseChan := make(chan *ListClusterDeprecatedAPIResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterDeprecatedAPI(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterDeprecatedAPIWithCallback invokes the qianzhou.ListClusterDeprecatedAPI API asynchronously
func (client *Client) ListClusterDeprecatedAPIWithCallback(request *ListClusterDeprecatedAPIRequest, callback func(response *ListClusterDeprecatedAPIResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterDeprecatedAPIResponse
		var err error
		defer close(result)
		response, err = client.ListClusterDeprecatedAPI(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterDeprecatedAPIRequest is the request struct for api ListClusterDeprecatedAPI
type ListClusterDeprecatedAPIRequest struct {
	*requests.RoaRequest
	ClusterId     string           `position:"Query" name:"cluster_id"`
	PageNo        requests.Integer `position:"Query" name:"page_no"`
	TargetVersion string           `position:"Query" name:"target_version"`
	PageSize      requests.Integer `position:"Query" name:"page_size"`
}

// ListClusterDeprecatedAPIResponse is the response struct for api ListClusterDeprecatedAPI
type ListClusterDeprecatedAPIResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      int    `json:"code" xml:"code"`
	Msg       string `json:"msg" xml:"msg"`
	Datas     Datas  `json:"datas" xml:"datas"`
}

// CreateListClusterDeprecatedAPIRequest creates a request to invoke ListClusterDeprecatedAPI API
func CreateListClusterDeprecatedAPIRequest() (request *ListClusterDeprecatedAPIRequest) {
	request = &ListClusterDeprecatedAPIRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "ListClusterDeprecatedAPI", "/popapi/listDeprecatedK8sAPI", "", "")
	request.Method = requests.POST
	return
}

// CreateListClusterDeprecatedAPIResponse creates a response to parse from ListClusterDeprecatedAPI response
func CreateListClusterDeprecatedAPIResponse() (response *ListClusterDeprecatedAPIResponse) {
	response = &ListClusterDeprecatedAPIResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
