package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MasterNodeShutDownFailOver invokes the r_kvstore.MasterNodeShutDownFailOver API synchronously
func (client *Client) MasterNodeShutDownFailOver(request *MasterNodeShutDownFailOverRequest) (response *MasterNodeShutDownFailOverResponse, err error) {
	response = CreateMasterNodeShutDownFailOverResponse()
	err = client.DoAction(request, response)
	return
}

// MasterNodeShutDownFailOverWithChan invokes the r_kvstore.MasterNodeShutDownFailOver API asynchronously
func (client *Client) MasterNodeShutDownFailOverWithChan(request *MasterNodeShutDownFailOverRequest) (<-chan *MasterNodeShutDownFailOverResponse, <-chan error) {
	responseChan := make(chan *MasterNodeShutDownFailOverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MasterNodeShutDownFailOver(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MasterNodeShutDownFailOverWithCallback invokes the r_kvstore.MasterNodeShutDownFailOver API asynchronously
func (client *Client) MasterNodeShutDownFailOverWithCallback(request *MasterNodeShutDownFailOverRequest, callback func(response *MasterNodeShutDownFailOverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MasterNodeShutDownFailOverResponse
		var err error
		defer close(result)
		response, err = client.MasterNodeShutDownFailOver(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MasterNodeShutDownFailOverRequest is the request struct for api MasterNodeShutDownFailOver
type MasterNodeShutDownFailOverRequest struct {
	*requests.RpcRequest
	FailMode         string `position:"Query" name:"FailMode"`
	ProxyFaultMode   string `position:"Query" name:"ProxyFaultMode"`
	ProxyInstanceIds string `position:"Query" name:"ProxyInstanceIds"`
	DBNodes          string `position:"Query" name:"DBNodes"`
	DBFaultMode      string `position:"Query" name:"DBFaultMode"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	Category         string `position:"Query" name:"Category"`
}

// MasterNodeShutDownFailOverResponse is the response struct for api MasterNodeShutDownFailOver
type MasterNodeShutDownFailOverResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
	TaskID       string `json:"TaskID" xml:"TaskID"`
}

// CreateMasterNodeShutDownFailOverRequest creates a request to invoke MasterNodeShutDownFailOver API
func CreateMasterNodeShutDownFailOverRequest() (request *MasterNodeShutDownFailOverRequest) {
	request = &MasterNodeShutDownFailOverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "MasterNodeShutDownFailOver", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMasterNodeShutDownFailOverResponse creates a response to parse from MasterNodeShutDownFailOver response
func CreateMasterNodeShutDownFailOverResponse() (response *MasterNodeShutDownFailOverResponse) {
	response = &MasterNodeShutDownFailOverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
