package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableMultiAccountResourceCenter invokes the resourcecenter.DisableMultiAccountResourceCenter API synchronously
func (client *Client) DisableMultiAccountResourceCenter(request *DisableMultiAccountResourceCenterRequest) (response *DisableMultiAccountResourceCenterResponse, err error) {
	response = CreateDisableMultiAccountResourceCenterResponse()
	err = client.DoAction(request, response)
	return
}

// DisableMultiAccountResourceCenterWithChan invokes the resourcecenter.DisableMultiAccountResourceCenter API asynchronously
func (client *Client) DisableMultiAccountResourceCenterWithChan(request *DisableMultiAccountResourceCenterRequest) (<-chan *DisableMultiAccountResourceCenterResponse, <-chan error) {
	responseChan := make(chan *DisableMultiAccountResourceCenterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableMultiAccountResourceCenter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableMultiAccountResourceCenterWithCallback invokes the resourcecenter.DisableMultiAccountResourceCenter API asynchronously
func (client *Client) DisableMultiAccountResourceCenterWithCallback(request *DisableMultiAccountResourceCenterRequest, callback func(response *DisableMultiAccountResourceCenterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableMultiAccountResourceCenterResponse
		var err error
		defer close(result)
		response, err = client.DisableMultiAccountResourceCenter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableMultiAccountResourceCenterRequest is the request struct for api DisableMultiAccountResourceCenter
type DisableMultiAccountResourceCenterRequest struct {
	*requests.RpcRequest
}

// DisableMultiAccountResourceCenterResponse is the response struct for api DisableMultiAccountResourceCenter
type DisableMultiAccountResourceCenterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableMultiAccountResourceCenterRequest creates a request to invoke DisableMultiAccountResourceCenter API
func CreateDisableMultiAccountResourceCenterRequest() (request *DisableMultiAccountResourceCenterRequest) {
	request = &DisableMultiAccountResourceCenterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "DisableMultiAccountResourceCenter", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableMultiAccountResourceCenterResponse creates a response to parse from DisableMultiAccountResourceCenter response
func CreateDisableMultiAccountResourceCenterResponse() (response *DisableMultiAccountResourceCenterResponse) {
	response = &DisableMultiAccountResourceCenterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
