package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableAutoGrouping invokes the resourcemanager.EnableAutoGrouping API synchronously
func (client *Client) EnableAutoGrouping(request *EnableAutoGroupingRequest) (response *EnableAutoGroupingResponse, err error) {
	response = CreateEnableAutoGroupingResponse()
	err = client.DoAction(request, response)
	return
}

// EnableAutoGroupingWithChan invokes the resourcemanager.EnableAutoGrouping API asynchronously
func (client *Client) EnableAutoGroupingWithChan(request *EnableAutoGroupingRequest) (<-chan *EnableAutoGroupingResponse, <-chan error) {
	responseChan := make(chan *EnableAutoGroupingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableAutoGrouping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableAutoGroupingWithCallback invokes the resourcemanager.EnableAutoGrouping API asynchronously
func (client *Client) EnableAutoGroupingWithCallback(request *EnableAutoGroupingRequest, callback func(response *EnableAutoGroupingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableAutoGroupingResponse
		var err error
		defer close(result)
		response, err = client.EnableAutoGrouping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableAutoGroupingRequest is the request struct for api EnableAutoGrouping
type EnableAutoGroupingRequest struct {
	*requests.RpcRequest
}

// EnableAutoGroupingResponse is the response struct for api EnableAutoGrouping
type EnableAutoGroupingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableAutoGroupingRequest creates a request to invoke EnableAutoGrouping API
func CreateEnableAutoGroupingRequest() (request *EnableAutoGroupingRequest) {
	request = &EnableAutoGroupingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "EnableAutoGrouping", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableAutoGroupingResponse creates a response to parse from EnableAutoGrouping response
func CreateEnableAutoGroupingResponse() (response *EnableAutoGroupingResponse) {
	response = &EnableAutoGroupingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
