package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetControlPolicyEnablementStatus invokes the resourcemanager.GetControlPolicyEnablementStatus API synchronously
func (client *Client) GetControlPolicyEnablementStatus(request *GetControlPolicyEnablementStatusRequest) (response *GetControlPolicyEnablementStatusResponse, err error) {
	response = CreateGetControlPolicyEnablementStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetControlPolicyEnablementStatusWithChan invokes the resourcemanager.GetControlPolicyEnablementStatus API asynchronously
func (client *Client) GetControlPolicyEnablementStatusWithChan(request *GetControlPolicyEnablementStatusRequest) (<-chan *GetControlPolicyEnablementStatusResponse, <-chan error) {
	responseChan := make(chan *GetControlPolicyEnablementStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetControlPolicyEnablementStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetControlPolicyEnablementStatusWithCallback invokes the resourcemanager.GetControlPolicyEnablementStatus API asynchronously
func (client *Client) GetControlPolicyEnablementStatusWithCallback(request *GetControlPolicyEnablementStatusRequest, callback func(response *GetControlPolicyEnablementStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetControlPolicyEnablementStatusResponse
		var err error
		defer close(result)
		response, err = client.GetControlPolicyEnablementStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetControlPolicyEnablementStatusRequest is the request struct for api GetControlPolicyEnablementStatus
type GetControlPolicyEnablementStatusRequest struct {
	*requests.RpcRequest
}

// GetControlPolicyEnablementStatusResponse is the response struct for api GetControlPolicyEnablementStatus
type GetControlPolicyEnablementStatusResponse struct {
	*responses.BaseResponse
	EnablementStatus string `json:"EnablementStatus" xml:"EnablementStatus"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
}

// CreateGetControlPolicyEnablementStatusRequest creates a request to invoke GetControlPolicyEnablementStatus API
func CreateGetControlPolicyEnablementStatusRequest() (request *GetControlPolicyEnablementStatusRequest) {
	request = &GetControlPolicyEnablementStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetControlPolicyEnablementStatus", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetControlPolicyEnablementStatusResponse creates a response to parse from GetControlPolicyEnablementStatus response
func CreateGetControlPolicyEnablementStatusResponse() (response *GetControlPolicyEnablementStatusResponse) {
	response = &GetControlPolicyEnablementStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
