package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageBaselineCheckSummary invokes the sas.DescribeImageBaselineCheckSummary API synchronously
func (client *Client) DescribeImageBaselineCheckSummary(request *DescribeImageBaselineCheckSummaryRequest) (response *DescribeImageBaselineCheckSummaryResponse, err error) {
	response = CreateDescribeImageBaselineCheckSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageBaselineCheckSummaryWithChan invokes the sas.DescribeImageBaselineCheckSummary API asynchronously
func (client *Client) DescribeImageBaselineCheckSummaryWithChan(request *DescribeImageBaselineCheckSummaryRequest) (<-chan *DescribeImageBaselineCheckSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeImageBaselineCheckSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageBaselineCheckSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageBaselineCheckSummaryWithCallback invokes the sas.DescribeImageBaselineCheckSummary API asynchronously
func (client *Client) DescribeImageBaselineCheckSummaryWithCallback(request *DescribeImageBaselineCheckSummaryRequest, callback func(response *DescribeImageBaselineCheckSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageBaselineCheckSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageBaselineCheckSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageBaselineCheckSummaryRequest is the request struct for api DescribeImageBaselineCheckSummary
type DescribeImageBaselineCheckSummaryRequest struct {
	*requests.RpcRequest
	Criteria     string           `position:"Query" name:"Criteria"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	CriteriaType string           `position:"Query" name:"CriteriaType"`
	Lang         string           `position:"Query" name:"Lang"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	RiskLevel    string           `position:"Query" name:"RiskLevel"`
}

// DescribeImageBaselineCheckSummaryResponse is the response struct for api DescribeImageBaselineCheckSummary
type DescribeImageBaselineCheckSummaryResponse struct {
	*responses.BaseResponse
	RequestId             string                      `json:"RequestId" xml:"RequestId"`
	PageInfo              PageInfo                    `json:"PageInfo" xml:"PageInfo"`
	BaselineResultSummary []BaselineResultSummaryItem `json:"BaselineResultSummary" xml:"BaselineResultSummary"`
}

// CreateDescribeImageBaselineCheckSummaryRequest creates a request to invoke DescribeImageBaselineCheckSummary API
func CreateDescribeImageBaselineCheckSummaryRequest() (request *DescribeImageBaselineCheckSummaryRequest) {
	request = &DescribeImageBaselineCheckSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeImageBaselineCheckSummary", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImageBaselineCheckSummaryResponse creates a response to parse from DescribeImageBaselineCheckSummary response
func CreateDescribeImageBaselineCheckSummaryResponse() (response *DescribeImageBaselineCheckSummaryResponse) {
	response = &DescribeImageBaselineCheckSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
