package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSummaryInfo invokes the sas.DescribeSummaryInfo API synchronously
func (client *Client) DescribeSummaryInfo(request *DescribeSummaryInfoRequest) (response *DescribeSummaryInfoResponse, err error) {
	response = CreateDescribeSummaryInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSummaryInfoWithChan invokes the sas.DescribeSummaryInfo API asynchronously
func (client *Client) DescribeSummaryInfoWithChan(request *DescribeSummaryInfoRequest) (<-chan *DescribeSummaryInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeSummaryInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSummaryInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSummaryInfoWithCallback invokes the sas.DescribeSummaryInfo API asynchronously
func (client *Client) DescribeSummaryInfoWithCallback(request *DescribeSummaryInfoRequest, callback func(response *DescribeSummaryInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSummaryInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeSummaryInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSummaryInfoRequest is the request struct for api DescribeSummaryInfo
type DescribeSummaryInfoRequest struct {
	*requests.RpcRequest
	SourceIp                   string `position:"Query" name:"SourceIp"`
	Lang                       string `position:"Query" name:"Lang"`
	ResourceDirectoryAccountId string `position:"Query" name:"ResourceDirectoryAccountId"`
}

// DescribeSummaryInfoResponse is the response struct for api DescribeSummaryInfo
type DescribeSummaryInfoResponse struct {
	*responses.BaseResponse
	RequestId               string `json:"RequestId" xml:"RequestId"`
	Success                 bool   `json:"Success" xml:"Success"`
	AegisClientOfflineCount int    `json:"AegisClientOfflineCount" xml:"AegisClientOfflineCount"`
	AegisClientOnlineCount  int    `json:"AegisClientOnlineCount" xml:"AegisClientOnlineCount"`
	SecurityScore           int    `json:"SecurityScore" xml:"SecurityScore"`
}

// CreateDescribeSummaryInfoRequest creates a request to invoke DescribeSummaryInfo API
func CreateDescribeSummaryInfoRequest() (request *DescribeSummaryInfoRequest) {
	request = &DescribeSummaryInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeSummaryInfo", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSummaryInfoResponse creates a response to parse from DescribeSummaryInfo response
func CreateDescribeSummaryInfoResponse() (response *DescribeSummaryInfoResponse) {
	response = &DescribeSummaryInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
