package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuspendHotlineService invokes the scsp.SuspendHotlineService API synchronously
func (client *Client) SuspendHotlineService(request *SuspendHotlineServiceRequest) (response *SuspendHotlineServiceResponse, err error) {
	response = CreateSuspendHotlineServiceResponse()
	err = client.DoAction(request, response)
	return
}

// SuspendHotlineServiceWithChan invokes the scsp.SuspendHotlineService API asynchronously
func (client *Client) SuspendHotlineServiceWithChan(request *SuspendHotlineServiceRequest) (<-chan *SuspendHotlineServiceResponse, <-chan error) {
	responseChan := make(chan *SuspendHotlineServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuspendHotlineService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuspendHotlineServiceWithCallback invokes the scsp.SuspendHotlineService API asynchronously
func (client *Client) SuspendHotlineServiceWithCallback(request *SuspendHotlineServiceRequest, callback func(response *SuspendHotlineServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuspendHotlineServiceResponse
		var err error
		defer close(result)
		response, err = client.SuspendHotlineService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuspendHotlineServiceRequest is the request struct for api SuspendHotlineService
type SuspendHotlineServiceRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Body"`
	InstanceId  string           `position:"Body"`
	AccountName string           `position:"Body"`
	Type        requests.Integer `position:"Body"`
}

// SuspendHotlineServiceResponse is the response struct for api SuspendHotlineService
type SuspendHotlineServiceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSuspendHotlineServiceRequest creates a request to invoke SuspendHotlineService API
func CreateSuspendHotlineServiceRequest() (request *SuspendHotlineServiceRequest) {
	request = &SuspendHotlineServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "SuspendHotlineService", "", "")
	request.Method = requests.POST
	return
}

// CreateSuspendHotlineServiceResponse creates a response to parse from SuspendHotlineService response
func CreateSuspendHotlineServiceResponse() (response *SuspendHotlineServiceResponse) {
	response = &SuspendHotlineServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
