package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDataLimit invokes the sddp.ModifyDataLimit API synchronously
func (client *Client) ModifyDataLimit(request *ModifyDataLimitRequest) (response *ModifyDataLimitResponse, err error) {
	response = CreateModifyDataLimitResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDataLimitWithChan invokes the sddp.ModifyDataLimit API asynchronously
func (client *Client) ModifyDataLimitWithChan(request *ModifyDataLimitRequest) (<-chan *ModifyDataLimitResponse, <-chan error) {
	responseChan := make(chan *ModifyDataLimitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDataLimit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDataLimitWithCallback invokes the sddp.ModifyDataLimit API asynchronously
func (client *Client) ModifyDataLimitWithCallback(request *ModifyDataLimitRequest, callback func(response *ModifyDataLimitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDataLimitResponse
		var err error
		defer close(result)
		response, err = client.ModifyDataLimit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDataLimitRequest is the request struct for api ModifyDataLimit
type ModifyDataLimitRequest struct {
	*requests.RpcRequest
	ModifyPassword      requests.Boolean `position:"Query" name:"ModifyPassword"`
	VSwitchIdList       *[]string        `position:"Query" name:"VSwitchIdList"  type:"Repeated"`
	SamplingSize        requests.Integer `position:"Query" name:"SamplingSize"`
	Password            string           `position:"Query" name:"Password"`
	SourceIp            string           `position:"Query" name:"SourceIp"`
	Id                  requests.Integer `position:"Query" name:"Id"`
	Lang                string           `position:"Query" name:"Lang"`
	ServiceRegionId     string           `position:"Query" name:"ServiceRegionId"`
	EngineType          string           `position:"Query" name:"EngineType"`
	AuditStatus         requests.Integer `position:"Query" name:"AuditStatus"`
	AutoScan            requests.Integer `position:"Query" name:"AutoScan"`
	FeatureType         requests.Integer `position:"Query" name:"FeatureType"`
	SecurityGroupIdList *[]string        `position:"Query" name:"SecurityGroupIdList"  type:"Repeated"`
	LogStoreDay         requests.Integer `position:"Query" name:"LogStoreDay"`
	ResourceType        requests.Integer `position:"Query" name:"ResourceType"`
	Connector           string           `position:"Query" name:"Connector"`
	Port                requests.Integer `position:"Query" name:"Port"`
	VpcId               string           `position:"Query" name:"VpcId"`
	UserName            string           `position:"Query" name:"UserName"`
}

// ModifyDataLimitResponse is the response struct for api ModifyDataLimit
type ModifyDataLimitResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDataLimitRequest creates a request to invoke ModifyDataLimit API
func CreateModifyDataLimitRequest() (request *ModifyDataLimitRequest) {
	request = &ModifyDataLimitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "ModifyDataLimit", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDataLimitResponse creates a response to parse from ModifyDataLimit response
func CreateModifyDataLimitResponse() (response *ModifyDataLimitResponse) {
	response = &ModifyDataLimitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
