package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegisteredServices invokes the servicemesh.GetRegisteredServices API synchronously
func (client *Client) GetRegisteredServices(request *GetRegisteredServicesRequest) (response *GetRegisteredServicesResponse, err error) {
	response = CreateGetRegisteredServicesResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegisteredServicesWithChan invokes the servicemesh.GetRegisteredServices API asynchronously
func (client *Client) GetRegisteredServicesWithChan(request *GetRegisteredServicesRequest) (<-chan *GetRegisteredServicesResponse, <-chan error) {
	responseChan := make(chan *GetRegisteredServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegisteredServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegisteredServicesWithCallback invokes the servicemesh.GetRegisteredServices API asynchronously
func (client *Client) GetRegisteredServicesWithCallback(request *GetRegisteredServicesRequest, callback func(response *GetRegisteredServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegisteredServicesResponse
		var err error
		defer close(result)
		response, err = client.GetRegisteredServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegisteredServicesRequest is the request struct for api GetRegisteredServices
type GetRegisteredServicesRequest struct {
	*requests.RpcRequest
	Namespace     string `position:"Query" name:"Namespace"`
	ServiceMeshId string `position:"Query" name:"ServiceMeshId"`
}

// GetRegisteredServicesResponse is the response struct for api GetRegisteredServices
type GetRegisteredServicesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Services  []string `json:"Services" xml:"Services"`
}

// CreateGetRegisteredServicesRequest creates a request to invoke GetRegisteredServices API
func CreateGetRegisteredServicesRequest() (request *GetRegisteredServicesRequest) {
	request = &GetRegisteredServicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "GetRegisteredServices", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRegisteredServicesResponse creates a response to parse from GetRegisteredServices response
func CreateGetRegisteredServicesResponse() (response *GetRegisteredServicesResponse) {
	response = &GetRegisteredServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
