package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayLogs invokes the sgw.DescribeGatewayLogs API synchronously
func (client *Client) DescribeGatewayLogs(request *DescribeGatewayLogsRequest) (response *DescribeGatewayLogsResponse, err error) {
	response = CreateDescribeGatewayLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayLogsWithChan invokes the sgw.DescribeGatewayLogs API asynchronously
func (client *Client) DescribeGatewayLogsWithChan(request *DescribeGatewayLogsRequest) (<-chan *DescribeGatewayLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayLogsWithCallback invokes the sgw.DescribeGatewayLogs API asynchronously
func (client *Client) DescribeGatewayLogsWithCallback(request *DescribeGatewayLogsRequest, callback func(response *DescribeGatewayLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayLogsRequest is the request struct for api DescribeGatewayLogs
type DescribeGatewayLogsRequest struct {
	*requests.RpcRequest
	LogFilePath   string `position:"Query" name:"LogFilePath"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayLogsResponse is the response struct for api DescribeGatewayLogs
type DescribeGatewayLogsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	Message      string `json:"Message" xml:"Message"`
	LogFilePaths string `json:"LogFilePaths" xml:"LogFilePaths"`
}

// CreateDescribeGatewayLogsRequest creates a request to invoke DescribeGatewayLogs API
func CreateDescribeGatewayLogsRequest() (request *DescribeGatewayLogsRequest) {
	request = &DescribeGatewayLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayLogs", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayLogsResponse creates a response to parse from DescribeGatewayLogs response
func CreateDescribeGatewayLogsResponse() (response *DescribeGatewayLogsResponse) {
	response = &DescribeGatewayLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
