package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportFileShares invokes the sgw.ReportFileShares API synchronously
func (client *Client) ReportFileShares(request *ReportFileSharesRequest) (response *ReportFileSharesResponse, err error) {
	response = CreateReportFileSharesResponse()
	err = client.DoAction(request, response)
	return
}

// ReportFileSharesWithChan invokes the sgw.ReportFileShares API asynchronously
func (client *Client) ReportFileSharesWithChan(request *ReportFileSharesRequest) (<-chan *ReportFileSharesResponse, <-chan error) {
	responseChan := make(chan *ReportFileSharesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportFileShares(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportFileSharesWithCallback invokes the sgw.ReportFileShares API asynchronously
func (client *Client) ReportFileSharesWithCallback(request *ReportFileSharesRequest, callback func(response *ReportFileSharesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportFileSharesResponse
		var err error
		defer close(result)
		response, err = client.ReportFileShares(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportFileSharesRequest is the request struct for api ReportFileShares
type ReportFileSharesRequest struct {
	*requests.RpcRequest
	ClientUUID    string `position:"Query" name:"ClientUUID"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
	Info          string `position:"Query" name:"Info"`
}

// ReportFileSharesResponse is the response struct for api ReportFileShares
type ReportFileSharesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateReportFileSharesRequest creates a request to invoke ReportFileShares API
func CreateReportFileSharesRequest() (request *ReportFileSharesRequest) {
	request = &ReportFileSharesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ReportFileShares", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReportFileSharesResponse creates a response to parse from ReportFileShares response
func CreateReportFileSharesResponse() (response *ReportFileSharesResponse) {
	response = &ReportFileSharesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
