package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateExpressSyncConfig invokes the sgw.ValidateExpressSyncConfig API synchronously
func (client *Client) ValidateExpressSyncConfig(request *ValidateExpressSyncConfigRequest) (response *ValidateExpressSyncConfigResponse, err error) {
	response = CreateValidateExpressSyncConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateExpressSyncConfigWithChan invokes the sgw.ValidateExpressSyncConfig API asynchronously
func (client *Client) ValidateExpressSyncConfigWithChan(request *ValidateExpressSyncConfigRequest) (<-chan *ValidateExpressSyncConfigResponse, <-chan error) {
	responseChan := make(chan *ValidateExpressSyncConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateExpressSyncConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateExpressSyncConfigWithCallback invokes the sgw.ValidateExpressSyncConfig API asynchronously
func (client *Client) ValidateExpressSyncConfigWithCallback(request *ValidateExpressSyncConfigRequest, callback func(response *ValidateExpressSyncConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateExpressSyncConfigResponse
		var err error
		defer close(result)
		response, err = client.ValidateExpressSyncConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateExpressSyncConfigRequest is the request struct for api ValidateExpressSyncConfig
type ValidateExpressSyncConfigRequest struct {
	*requests.RpcRequest
	BucketRegion  string `position:"Query" name:"BucketRegion"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	BucketName    string `position:"Query" name:"BucketName"`
	Name          string `position:"Query" name:"Name"`
	BucketPrefix  string `position:"Query" name:"BucketPrefix"`
}

// ValidateExpressSyncConfigResponse is the response struct for api ValidateExpressSyncConfig
type ValidateExpressSyncConfigResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Success         bool   `json:"Success" xml:"Success"`
	Code            string `json:"Code" xml:"Code"`
	Message         string `json:"Message" xml:"Message"`
	IsValid         bool   `json:"IsValid" xml:"IsValid"`
	ValidateMessage string `json:"ValidateMessage" xml:"ValidateMessage"`
}

// CreateValidateExpressSyncConfigRequest creates a request to invoke ValidateExpressSyncConfig API
func CreateValidateExpressSyncConfigRequest() (request *ValidateExpressSyncConfigRequest) {
	request = &ValidateExpressSyncConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ValidateExpressSyncConfig", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateValidateExpressSyncConfigResponse creates a response to parse from ValidateExpressSyncConfig response
func CreateValidateExpressSyncConfigResponse() (response *ValidateExpressSyncConfigResponse) {
	response = &ValidateExpressSyncConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
