package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccessLogsDownloadAttribute invokes the slb.DeleteAccessLogsDownloadAttribute API synchronously
func (client *Client) DeleteAccessLogsDownloadAttribute(request *DeleteAccessLogsDownloadAttributeRequest) (response *DeleteAccessLogsDownloadAttributeResponse, err error) {
	response = CreateDeleteAccessLogsDownloadAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAccessLogsDownloadAttributeWithChan invokes the slb.DeleteAccessLogsDownloadAttribute API asynchronously
func (client *Client) DeleteAccessLogsDownloadAttributeWithChan(request *DeleteAccessLogsDownloadAttributeRequest) (<-chan *DeleteAccessLogsDownloadAttributeResponse, <-chan error) {
	responseChan := make(chan *DeleteAccessLogsDownloadAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccessLogsDownloadAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAccessLogsDownloadAttributeWithCallback invokes the slb.DeleteAccessLogsDownloadAttribute API asynchronously
func (client *Client) DeleteAccessLogsDownloadAttributeWithCallback(request *DeleteAccessLogsDownloadAttributeRequest, callback func(response *DeleteAccessLogsDownloadAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAccessLogsDownloadAttributeResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccessLogsDownloadAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAccessLogsDownloadAttributeRequest is the request struct for api DeleteAccessLogsDownloadAttribute
type DeleteAccessLogsDownloadAttributeRequest struct {
	*requests.RpcRequest
	AccessKeyId            string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LogsDownloadAttributes string           `position:"Query" name:"LogsDownloadAttributes"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	Tags                   string           `position:"Query" name:"Tags"`
	LoadBalancerId         string           `position:"Query" name:"LoadBalancerId"`
}

// DeleteAccessLogsDownloadAttributeResponse is the response struct for api DeleteAccessLogsDownloadAttribute
type DeleteAccessLogsDownloadAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAccessLogsDownloadAttributeRequest creates a request to invoke DeleteAccessLogsDownloadAttribute API
func CreateDeleteAccessLogsDownloadAttributeRequest() (request *DeleteAccessLogsDownloadAttributeRequest) {
	request = &DeleteAccessLogsDownloadAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DeleteAccessLogsDownloadAttribute", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAccessLogsDownloadAttributeResponse creates a response to parse from DeleteAccessLogsDownloadAttribute response
func CreateDeleteAccessLogsDownloadAttributeResponse() (response *DeleteAccessLogsDownloadAttributeResponse) {
	response = &DeleteAccessLogsDownloadAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
