package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchModifyInstanceStatus invokes the sophonsoar.BatchModifyInstanceStatus API synchronously
func (client *Client) BatchModifyInstanceStatus(request *BatchModifyInstanceStatusRequest) (response *BatchModifyInstanceStatusResponse, err error) {
	response = CreateBatchModifyInstanceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// BatchModifyInstanceStatusWithChan invokes the sophonsoar.BatchModifyInstanceStatus API asynchronously
func (client *Client) BatchModifyInstanceStatusWithChan(request *BatchModifyInstanceStatusRequest) (<-chan *BatchModifyInstanceStatusResponse, <-chan error) {
	responseChan := make(chan *BatchModifyInstanceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchModifyInstanceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchModifyInstanceStatusWithCallback invokes the sophonsoar.BatchModifyInstanceStatus API asynchronously
func (client *Client) BatchModifyInstanceStatusWithCallback(request *BatchModifyInstanceStatusRequest, callback func(response *BatchModifyInstanceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchModifyInstanceStatusResponse
		var err error
		defer close(result)
		response, err = client.BatchModifyInstanceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchModifyInstanceStatusRequest is the request struct for api BatchModifyInstanceStatus
type BatchModifyInstanceStatusRequest struct {
	*requests.RpcRequest
	RoleFor      string           `position:"Query" name:"RoleFor"`
	Active       requests.Integer `position:"Body" name:"Active"`
	PlaybookUuid string           `position:"Body" name:"PlaybookUuid"`
	RoleType     string           `position:"Query" name:"RoleType"`
	Lang         string           `position:"Query" name:"Lang"`
}

// BatchModifyInstanceStatusResponse is the response struct for api BatchModifyInstanceStatus
type BatchModifyInstanceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchModifyInstanceStatusRequest creates a request to invoke BatchModifyInstanceStatus API
func CreateBatchModifyInstanceStatusRequest() (request *BatchModifyInstanceStatusRequest) {
	request = &BatchModifyInstanceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "BatchModifyInstanceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchModifyInstanceStatusResponse creates a response to parse from BatchModifyInstanceStatus response
func CreateBatchModifyInstanceStatusResponse() (response *BatchModifyInstanceStatusResponse) {
	response = &BatchModifyInstanceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
