package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DebugPlaybook invokes the sophonsoar.DebugPlaybook API synchronously
func (client *Client) DebugPlaybook(request *DebugPlaybookRequest) (response *DebugPlaybookResponse, err error) {
	response = CreateDebugPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// DebugPlaybookWithChan invokes the sophonsoar.DebugPlaybook API asynchronously
func (client *Client) DebugPlaybookWithChan(request *DebugPlaybookRequest) (<-chan *DebugPlaybookResponse, <-chan error) {
	responseChan := make(chan *DebugPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DebugPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DebugPlaybookWithCallback invokes the sophonsoar.DebugPlaybook API asynchronously
func (client *Client) DebugPlaybookWithCallback(request *DebugPlaybookRequest, callback func(response *DebugPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DebugPlaybookResponse
		var err error
		defer close(result)
		response, err = client.DebugPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DebugPlaybookRequest is the request struct for api DebugPlaybook
type DebugPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	Taskflow     string `position:"Body" name:"Taskflow"`
	PlaybookUuid string `position:"Body" name:"PlaybookUuid"`
	Record       string `position:"Body" name:"Record"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Body" name:"Lang"`
}

// DebugPlaybookResponse is the response struct for api DebugPlaybook
type DebugPlaybookResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	RequestUuid string `json:"RequestUuid" xml:"RequestUuid"`
}

// CreateDebugPlaybookRequest creates a request to invoke DebugPlaybook API
func CreateDebugPlaybookRequest() (request *DebugPlaybookRequest) {
	request = &DebugPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DebugPlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreateDebugPlaybookResponse creates a response to parse from DebugPlaybook response
func CreateDebugPlaybookResponse() (response *DebugPlaybookResponse) {
	response = &DebugPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
