package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteComponentAsset invokes the sophonsoar.DeleteComponentAsset API synchronously
func (client *Client) DeleteComponentAsset(request *DeleteComponentAssetRequest) (response *DeleteComponentAssetResponse, err error) {
	response = CreateDeleteComponentAssetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteComponentAssetWithChan invokes the sophonsoar.DeleteComponentAsset API asynchronously
func (client *Client) DeleteComponentAssetWithChan(request *DeleteComponentAssetRequest) (<-chan *DeleteComponentAssetResponse, <-chan error) {
	responseChan := make(chan *DeleteComponentAssetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteComponentAsset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteComponentAssetWithCallback invokes the sophonsoar.DeleteComponentAsset API asynchronously
func (client *Client) DeleteComponentAssetWithCallback(request *DeleteComponentAssetRequest, callback func(response *DeleteComponentAssetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteComponentAssetResponse
		var err error
		defer close(result)
		response, err = client.DeleteComponentAsset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteComponentAssetRequest is the request struct for api DeleteComponentAsset
type DeleteComponentAssetRequest struct {
	*requests.RpcRequest
	RoleFor  string           `position:"Query" name:"RoleFor"`
	AssetId  requests.Integer `position:"Query" name:"AssetId"`
	RoleType string           `position:"Query" name:"RoleType"`
	Lang     string           `position:"Query" name:"Lang"`
}

// DeleteComponentAssetResponse is the response struct for api DeleteComponentAsset
type DeleteComponentAssetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteComponentAssetRequest creates a request to invoke DeleteComponentAsset API
func CreateDeleteComponentAssetRequest() (request *DeleteComponentAssetRequest) {
	request = &DeleteComponentAssetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DeleteComponentAsset", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteComponentAssetResponse creates a response to parse from DeleteComponentAsset response
func CreateDeleteComponentAssetResponse() (response *DeleteComponentAssetResponse) {
	response = &DeleteComponentAssetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
