package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSoarTaskAndActions invokes the sophonsoar.DescribeSoarTaskAndActions API synchronously
func (client *Client) DescribeSoarTaskAndActions(request *DescribeSoarTaskAndActionsRequest) (response *DescribeSoarTaskAndActionsResponse, err error) {
	response = CreateDescribeSoarTaskAndActionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSoarTaskAndActionsWithChan invokes the sophonsoar.DescribeSoarTaskAndActions API asynchronously
func (client *Client) DescribeSoarTaskAndActionsWithChan(request *DescribeSoarTaskAndActionsRequest) (<-chan *DescribeSoarTaskAndActionsResponse, <-chan error) {
	responseChan := make(chan *DescribeSoarTaskAndActionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSoarTaskAndActions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSoarTaskAndActionsWithCallback invokes the sophonsoar.DescribeSoarTaskAndActions API asynchronously
func (client *Client) DescribeSoarTaskAndActionsWithCallback(request *DescribeSoarTaskAndActionsRequest, callback func(response *DescribeSoarTaskAndActionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSoarTaskAndActionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSoarTaskAndActions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSoarTaskAndActionsRequest is the request struct for api DescribeSoarTaskAndActions
type DescribeSoarTaskAndActionsRequest struct {
	*requests.RpcRequest
	RoleFor     string `position:"Query" name:"RoleFor"`
	RequestUuid string `position:"Query" name:"RequestUuid"`
	RoleType    string `position:"Query" name:"RoleType"`
	Lang        string `position:"Query" name:"Lang"`
}

// DescribeSoarTaskAndActionsResponse is the response struct for api DescribeSoarTaskAndActions
type DescribeSoarTaskAndActionsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Details   Details `json:"Details" xml:"Details"`
}

// CreateDescribeSoarTaskAndActionsRequest creates a request to invoke DescribeSoarTaskAndActions API
func CreateDescribeSoarTaskAndActionsRequest() (request *DescribeSoarTaskAndActionsRequest) {
	request = &DescribeSoarTaskAndActionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeSoarTaskAndActions", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeSoarTaskAndActionsResponse creates a response to parse from DescribeSoarTaskAndActions response
func CreateDescribeSoarTaskAndActionsResponse() (response *DescribeSoarTaskAndActionsResponse) {
	response = &DescribeSoarTaskAndActionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
