package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomImages invokes the swas_open.DeleteCustomImages API synchronously
func (client *Client) DeleteCustomImages(request *DeleteCustomImagesRequest) (response *DeleteCustomImagesResponse, err error) {
	response = CreateDeleteCustomImagesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomImagesWithChan invokes the swas_open.DeleteCustomImages API asynchronously
func (client *Client) DeleteCustomImagesWithChan(request *DeleteCustomImagesRequest) (<-chan *DeleteCustomImagesResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomImagesWithCallback invokes the swas_open.DeleteCustomImages API asynchronously
func (client *Client) DeleteCustomImagesWithCallback(request *DeleteCustomImagesRequest, callback func(response *DeleteCustomImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomImagesResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomImagesRequest is the request struct for api DeleteCustomImages
type DeleteCustomImagesRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	ImageIds    string `position:"Query" name:"ImageIds"`
}

// DeleteCustomImagesResponse is the response struct for api DeleteCustomImages
type DeleteCustomImagesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomImagesRequest creates a request to invoke DeleteCustomImages API
func CreateDeleteCustomImagesRequest() (request *DeleteCustomImagesRequest) {
	request = &DeleteCustomImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DeleteCustomImages", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomImagesResponse creates a response to parse from DeleteCustomImages response
func CreateDeleteCustomImagesResponse() (response *DeleteCustomImagesResponse) {
	response = &DeleteCustomImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
