package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPolicy invokes the tag.ModifyPolicy API synchronously
func (client *Client) ModifyPolicy(request *ModifyPolicyRequest) (response *ModifyPolicyResponse, err error) {
	response = CreateModifyPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPolicyWithChan invokes the tag.ModifyPolicy API asynchronously
func (client *Client) ModifyPolicyWithChan(request *ModifyPolicyRequest) (<-chan *ModifyPolicyResponse, <-chan error) {
	responseChan := make(chan *ModifyPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPolicyWithCallback invokes the tag.ModifyPolicy API asynchronously
func (client *Client) ModifyPolicyWithCallback(request *ModifyPolicyRequest, callback func(response *ModifyPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPolicyResponse
		var err error
		defer close(result)
		response, err = client.ModifyPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPolicyRequest is the request struct for api ModifyPolicy
type ModifyPolicyRequest struct {
	*requests.RpcRequest
	PolicyDesc           string           `position:"Query" name:"PolicyDesc"`
	PolicyId             string           `position:"Query" name:"PolicyId"`
	PolicyContent        string           `position:"Query" name:"PolicyContent"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PolicyName           string           `position:"Query" name:"PolicyName"`
}

// ModifyPolicyResponse is the response struct for api ModifyPolicy
type ModifyPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPolicyRequest creates a request to invoke ModifyPolicy API
func CreateModifyPolicyRequest() (request *ModifyPolicyRequest) {
	request = &ModifyPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "ModifyPolicy", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyPolicyResponse creates a response to parse from ModifyPolicy response
func CreateModifyPolicyResponse() (response *ModifyPolicyResponse) {
	response = &ModifyPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
