package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTenantInfo invokes the unimkt.QueryTenantInfo API synchronously
func (client *Client) QueryTenantInfo(request *QueryTenantInfoRequest) (response *QueryTenantInfoResponse, err error) {
	response = CreateQueryTenantInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTenantInfoWithChan invokes the unimkt.QueryTenantInfo API asynchronously
func (client *Client) QueryTenantInfoWithChan(request *QueryTenantInfoRequest) (<-chan *QueryTenantInfoResponse, <-chan error) {
	responseChan := make(chan *QueryTenantInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTenantInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTenantInfoWithCallback invokes the unimkt.QueryTenantInfo API asynchronously
func (client *Client) QueryTenantInfoWithCallback(request *QueryTenantInfoRequest, callback func(response *QueryTenantInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTenantInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryTenantInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTenantInfoRequest is the request struct for api QueryTenantInfo
type QueryTenantInfoRequest struct {
	*requests.RpcRequest
	Business         string `position:"Query" name:"Business"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	UserSite         string `position:"Query" name:"UserSite"`
}

// QueryTenantInfoResponse is the response struct for api QueryTenantInfo
type QueryTenantInfoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateQueryTenantInfoRequest creates a request to invoke QueryTenantInfo API
func CreateQueryTenantInfoRequest() (request *QueryTenantInfoRequest) {
	request = &QueryTenantInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryTenantInfo", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTenantInfoResponse creates a response to parse from QueryTenantInfo response
func CreateQueryTenantInfoResponse() (response *QueryTenantInfoResponse) {
	response = &QueryTenantInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
