package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUnionPromotion invokes the unimkt.QueryUnionPromotion API synchronously
func (client *Client) QueryUnionPromotion(request *QueryUnionPromotionRequest) (response *QueryUnionPromotionResponse, err error) {
	response = CreateQueryUnionPromotionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUnionPromotionWithChan invokes the unimkt.QueryUnionPromotion API asynchronously
func (client *Client) QueryUnionPromotionWithChan(request *QueryUnionPromotionRequest) (<-chan *QueryUnionPromotionResponse, <-chan error) {
	responseChan := make(chan *QueryUnionPromotionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUnionPromotion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUnionPromotionWithCallback invokes the unimkt.QueryUnionPromotion API asynchronously
func (client *Client) QueryUnionPromotionWithCallback(request *QueryUnionPromotionRequest, callback func(response *QueryUnionPromotionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUnionPromotionResponse
		var err error
		defer close(result)
		response, err = client.QueryUnionPromotion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUnionPromotionRequest is the request struct for api QueryUnionPromotion
type QueryUnionPromotionRequest struct {
	*requests.RpcRequest
	UnionBizType string           `position:"Query" name:"UnionBizType"`
	UserNick     string           `position:"Query" name:"UserNick"`
	Sign         string           `position:"Query" name:"Sign"`
	AlipayOpenId requests.Integer `position:"Query" name:"AlipayOpenId"`
	UserId       requests.Integer `position:"Query" name:"UserId"`
	ChannelId    string           `position:"Query" name:"ChannelId"`
}

// QueryUnionPromotionResponse is the response struct for api QueryUnionPromotion
type QueryUnionPromotionResponse struct {
	*responses.BaseResponse
	ErrorCode int                      `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Result    []map[string]interface{} `json:"Result" xml:"Result"`
}

// CreateQueryUnionPromotionRequest creates a request to invoke QueryUnionPromotion API
func CreateQueryUnionPromotionRequest() (request *QueryUnionPromotionRequest) {
	request = &QueryUnionPromotionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryUnionPromotion", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUnionPromotionResponse creates a response to parse from QueryUnionPromotion response
func CreateQueryUnionPromotionResponse() (response *QueryUnionPromotionResponse) {
	response = &QueryUnionPromotionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
