package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveVideoSummaryTaskVideo invokes the vcs.SaveVideoSummaryTaskVideo API synchronously
func (client *Client) SaveVideoSummaryTaskVideo(request *SaveVideoSummaryTaskVideoRequest) (response *SaveVideoSummaryTaskVideoResponse, err error) {
	response = CreateSaveVideoSummaryTaskVideoResponse()
	err = client.DoAction(request, response)
	return
}

// SaveVideoSummaryTaskVideoWithChan invokes the vcs.SaveVideoSummaryTaskVideo API asynchronously
func (client *Client) SaveVideoSummaryTaskVideoWithChan(request *SaveVideoSummaryTaskVideoRequest) (<-chan *SaveVideoSummaryTaskVideoResponse, <-chan error) {
	responseChan := make(chan *SaveVideoSummaryTaskVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveVideoSummaryTaskVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveVideoSummaryTaskVideoWithCallback invokes the vcs.SaveVideoSummaryTaskVideo API asynchronously
func (client *Client) SaveVideoSummaryTaskVideoWithCallback(request *SaveVideoSummaryTaskVideoRequest, callback func(response *SaveVideoSummaryTaskVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveVideoSummaryTaskVideoResponse
		var err error
		defer close(result)
		response, err = client.SaveVideoSummaryTaskVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveVideoSummaryTaskVideoRequest is the request struct for api SaveVideoSummaryTaskVideo
type SaveVideoSummaryTaskVideoRequest struct {
	*requests.RpcRequest
	CorpId    string           `position:"Body" name:"CorpId"`
	SaveVideo requests.Boolean `position:"Body" name:"SaveVideo"`
	TaskId    requests.Integer `position:"Body" name:"TaskId"`
}

// SaveVideoSummaryTaskVideoResponse is the response struct for api SaveVideoSummaryTaskVideo
type SaveVideoSummaryTaskVideoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSaveVideoSummaryTaskVideoRequest creates a request to invoke SaveVideoSummaryTaskVideo API
func CreateSaveVideoSummaryTaskVideoRequest() (request *SaveVideoSummaryTaskVideoRequest) {
	request = &SaveVideoSummaryTaskVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "SaveVideoSummaryTaskVideo", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveVideoSummaryTaskVideoResponse creates a response to parse from SaveVideoSummaryTaskVideo response
func CreateSaveVideoSummaryTaskVideoResponse() (response *SaveVideoSummaryTaskVideoResponse) {
	response = &SaveVideoSummaryTaskVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
