package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLabelsetDatas invokes the viapi_regen.ListLabelsetDatas API synchronously
func (client *Client) ListLabelsetDatas(request *ListLabelsetDatasRequest) (response *ListLabelsetDatasResponse, err error) {
	response = CreateListLabelsetDatasResponse()
	err = client.DoAction(request, response)
	return
}

// ListLabelsetDatasWithChan invokes the viapi_regen.ListLabelsetDatas API asynchronously
func (client *Client) ListLabelsetDatasWithChan(request *ListLabelsetDatasRequest) (<-chan *ListLabelsetDatasResponse, <-chan error) {
	responseChan := make(chan *ListLabelsetDatasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLabelsetDatas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLabelsetDatasWithCallback invokes the viapi_regen.ListLabelsetDatas API asynchronously
func (client *Client) ListLabelsetDatasWithCallback(request *ListLabelsetDatasRequest, callback func(response *ListLabelsetDatasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLabelsetDatasResponse
		var err error
		defer close(result)
		response, err = client.ListLabelsetDatas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLabelsetDatasRequest is the request struct for api ListLabelsetDatas
type ListLabelsetDatasRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	Value       string           `position:"Body" name:"Value"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	IsAbandon   requests.Boolean `position:"Body" name:"IsAbandon"`
	LabelId     requests.Integer `position:"Body" name:"LabelId"`
	Name        string           `position:"Body" name:"Name"`
	Operation   string           `position:"Body" name:"Operation"`
}

// ListLabelsetDatasResponse is the response struct for api ListLabelsetDatas
type ListLabelsetDatasResponse struct {
	*responses.BaseResponse
	Message   string                  `json:"Message" xml:"Message"`
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Code      string                  `json:"Code" xml:"Code"`
	Data      DataInListLabelsetDatas `json:"Data" xml:"Data"`
}

// CreateListLabelsetDatasRequest creates a request to invoke ListLabelsetDatas API
func CreateListLabelsetDatasRequest() (request *ListLabelsetDatasRequest) {
	request = &ListLabelsetDatasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "ListLabelsetDatas", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLabelsetDatasResponse creates a response to parse from ListLabelsetDatas response
func CreateListLabelsetDatasResponse() (response *ListLabelsetDatasResponse) {
	response = &ListLabelsetDatasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
