package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePublicIpAddressPool invokes the vpc.DeletePublicIpAddressPool API synchronously
func (client *Client) DeletePublicIpAddressPool(request *DeletePublicIpAddressPoolRequest) (response *DeletePublicIpAddressPoolResponse, err error) {
	response = CreateDeletePublicIpAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePublicIpAddressPoolWithChan invokes the vpc.DeletePublicIpAddressPool API asynchronously
func (client *Client) DeletePublicIpAddressPoolWithChan(request *DeletePublicIpAddressPoolRequest) (<-chan *DeletePublicIpAddressPoolResponse, <-chan error) {
	responseChan := make(chan *DeletePublicIpAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePublicIpAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePublicIpAddressPoolWithCallback invokes the vpc.DeletePublicIpAddressPool API asynchronously
func (client *Client) DeletePublicIpAddressPoolWithCallback(request *DeletePublicIpAddressPoolRequest, callback func(response *DeletePublicIpAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePublicIpAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.DeletePublicIpAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePublicIpAddressPoolRequest is the request struct for api DeletePublicIpAddressPool
type DeletePublicIpAddressPoolRequest struct {
	*requests.RpcRequest
	PublicIpAddressPoolId string           `position:"Query" name:"PublicIpAddressPoolId"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	DryRun                requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
}

// DeletePublicIpAddressPoolResponse is the response struct for api DeletePublicIpAddressPool
type DeletePublicIpAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePublicIpAddressPoolRequest creates a request to invoke DeletePublicIpAddressPool API
func CreateDeletePublicIpAddressPoolRequest() (request *DeletePublicIpAddressPoolRequest) {
	request = &DeletePublicIpAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeletePublicIpAddressPool", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePublicIpAddressPoolResponse creates a response to parse from DeletePublicIpAddressPool response
func CreateDeletePublicIpAddressPoolResponse() (response *DeletePublicIpAddressPoolResponse) {
	response = &DeletePublicIpAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
