package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIpv4GatewayAttribute invokes the vpc.GetIpv4GatewayAttribute API synchronously
func (client *Client) GetIpv4GatewayAttribute(request *GetIpv4GatewayAttributeRequest) (response *GetIpv4GatewayAttributeResponse, err error) {
	response = CreateGetIpv4GatewayAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetIpv4GatewayAttributeWithChan invokes the vpc.GetIpv4GatewayAttribute API asynchronously
func (client *Client) GetIpv4GatewayAttributeWithChan(request *GetIpv4GatewayAttributeRequest) (<-chan *GetIpv4GatewayAttributeResponse, <-chan error) {
	responseChan := make(chan *GetIpv4GatewayAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIpv4GatewayAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIpv4GatewayAttributeWithCallback invokes the vpc.GetIpv4GatewayAttribute API asynchronously
func (client *Client) GetIpv4GatewayAttributeWithCallback(request *GetIpv4GatewayAttributeRequest, callback func(response *GetIpv4GatewayAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIpv4GatewayAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetIpv4GatewayAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIpv4GatewayAttributeRequest is the request struct for api GetIpv4GatewayAttribute
type GetIpv4GatewayAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Ipv4GatewayId        string           `position:"Query" name:"Ipv4GatewayId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetIpv4GatewayAttributeResponse is the response struct for api GetIpv4GatewayAttribute
type GetIpv4GatewayAttributeResponse struct {
	*responses.BaseResponse
	VpcId                   string `json:"VpcId" xml:"VpcId"`
	Status                  string `json:"Status" xml:"Status"`
	Ipv4GatewayId           string `json:"Ipv4GatewayId" xml:"Ipv4GatewayId"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
	Ipv4GatewayDescription  string `json:"Ipv4GatewayDescription" xml:"Ipv4GatewayDescription"`
	Enabled                 bool   `json:"Enabled" xml:"Enabled"`
	Ipv4GatewayRouteTableId string `json:"Ipv4GatewayRouteTableId" xml:"Ipv4GatewayRouteTableId"`
	Ipv4GatewayName         string `json:"Ipv4GatewayName" xml:"Ipv4GatewayName"`
	CreateTime              string `json:"CreateTime" xml:"CreateTime"`
	ResourceGroupId         string `json:"ResourceGroupId" xml:"ResourceGroupId"`
	Tags                    []Tag  `json:"Tags" xml:"Tags"`
}

// CreateGetIpv4GatewayAttributeRequest creates a request to invoke GetIpv4GatewayAttribute API
func CreateGetIpv4GatewayAttributeRequest() (request *GetIpv4GatewayAttributeRequest) {
	request = &GetIpv4GatewayAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetIpv4GatewayAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetIpv4GatewayAttributeResponse creates a response to parse from GetIpv4GatewayAttribute response
func CreateGetIpv4GatewayAttributeResponse() (response *GetIpv4GatewayAttributeResponse) {
	response = &GetIpv4GatewayAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
