package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReplaceVpcDhcpOptionsSet invokes the vpc.ReplaceVpcDhcpOptionsSet API synchronously
func (client *Client) ReplaceVpcDhcpOptionsSet(request *ReplaceVpcDhcpOptionsSetRequest) (response *ReplaceVpcDhcpOptionsSetResponse, err error) {
	response = CreateReplaceVpcDhcpOptionsSetResponse()
	err = client.DoAction(request, response)
	return
}

// ReplaceVpcDhcpOptionsSetWithChan invokes the vpc.ReplaceVpcDhcpOptionsSet API asynchronously
func (client *Client) ReplaceVpcDhcpOptionsSetWithChan(request *ReplaceVpcDhcpOptionsSetRequest) (<-chan *ReplaceVpcDhcpOptionsSetResponse, <-chan error) {
	responseChan := make(chan *ReplaceVpcDhcpOptionsSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReplaceVpcDhcpOptionsSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReplaceVpcDhcpOptionsSetWithCallback invokes the vpc.ReplaceVpcDhcpOptionsSet API asynchronously
func (client *Client) ReplaceVpcDhcpOptionsSetWithCallback(request *ReplaceVpcDhcpOptionsSetRequest, callback func(response *ReplaceVpcDhcpOptionsSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReplaceVpcDhcpOptionsSetResponse
		var err error
		defer close(result)
		response, err = client.ReplaceVpcDhcpOptionsSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReplaceVpcDhcpOptionsSetRequest is the request struct for api ReplaceVpcDhcpOptionsSet
type ReplaceVpcDhcpOptionsSetRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	DhcpOptionsSetId     string           `position:"Query" name:"DhcpOptionsSetId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VpcId                string           `position:"Query" name:"VpcId"`
}

// ReplaceVpcDhcpOptionsSetResponse is the response struct for api ReplaceVpcDhcpOptionsSet
type ReplaceVpcDhcpOptionsSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReplaceVpcDhcpOptionsSetRequest creates a request to invoke ReplaceVpcDhcpOptionsSet API
func CreateReplaceVpcDhcpOptionsSetRequest() (request *ReplaceVpcDhcpOptionsSetRequest) {
	request = &ReplaceVpcDhcpOptionsSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ReplaceVpcDhcpOptionsSet", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReplaceVpcDhcpOptionsSetResponse creates a response to parse from ReplaceVpcDhcpOptionsSet response
func CreateReplaceVpcDhcpOptionsSetResponse() (response *ReplaceVpcDhcpOptionsSetResponse) {
	response = &ReplaceVpcDhcpOptionsSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
