package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeRenderingDevicesImage invokes the vs.UpgradeRenderingDevicesImage API synchronously
func (client *Client) UpgradeRenderingDevicesImage(request *UpgradeRenderingDevicesImageRequest) (response *UpgradeRenderingDevicesImageResponse, err error) {
	response = CreateUpgradeRenderingDevicesImageResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeRenderingDevicesImageWithChan invokes the vs.UpgradeRenderingDevicesImage API asynchronously
func (client *Client) UpgradeRenderingDevicesImageWithChan(request *UpgradeRenderingDevicesImageRequest) (<-chan *UpgradeRenderingDevicesImageResponse, <-chan error) {
	responseChan := make(chan *UpgradeRenderingDevicesImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeRenderingDevicesImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeRenderingDevicesImageWithCallback invokes the vs.UpgradeRenderingDevicesImage API asynchronously
func (client *Client) UpgradeRenderingDevicesImageWithCallback(request *UpgradeRenderingDevicesImageRequest, callback func(response *UpgradeRenderingDevicesImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeRenderingDevicesImageResponse
		var err error
		defer close(result)
		response, err = client.UpgradeRenderingDevicesImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeRenderingDevicesImageRequest is the request struct for api UpgradeRenderingDevicesImage
type UpgradeRenderingDevicesImageRequest struct {
	*requests.RpcRequest
	ImageId     string           `position:"Query" name:"ImageId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	InstanceIds string           `position:"Query" name:"InstanceIds"`
}

// UpgradeRenderingDevicesImageResponse is the response struct for api UpgradeRenderingDevicesImage
type UpgradeRenderingDevicesImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpgradeRenderingDevicesImageRequest creates a request to invoke UpgradeRenderingDevicesImage API
func CreateUpgradeRenderingDevicesImageRequest() (request *UpgradeRenderingDevicesImageRequest) {
	request = &UpgradeRenderingDevicesImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UpgradeRenderingDevicesImage", "", "")
	request.Method = requests.POST
	return
}

// CreateUpgradeRenderingDevicesImageResponse creates a response to parse from UpgradeRenderingDevicesImage response
func CreateUpgradeRenderingDevicesImageResponse() (response *UpgradeRenderingDevicesImageResponse) {
	response = &UpgradeRenderingDevicesImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
