// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/video/stitcher/v1/companions.proto

package stitcherpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates how many of the companions should be displayed with the ad.
type CompanionAds_DisplayRequirement int32

const (
	// Required companions are not specified. The default is ALL.
	CompanionAds_DISPLAY_REQUIREMENT_UNSPECIFIED CompanionAds_DisplayRequirement = 0
	// All companions are required to be displayed.
	CompanionAds_ALL CompanionAds_DisplayRequirement = 1
	// At least one of companions needs to be displayed.
	CompanionAds_ANY CompanionAds_DisplayRequirement = 2
	// All companions are optional for display.
	CompanionAds_NONE CompanionAds_DisplayRequirement = 3
)

// Enum value maps for CompanionAds_DisplayRequirement.
var (
	CompanionAds_DisplayRequirement_name = map[int32]string{
		0: "DISPLAY_REQUIREMENT_UNSPECIFIED",
		1: "ALL",
		2: "ANY",
		3: "NONE",
	}
	CompanionAds_DisplayRequirement_value = map[string]int32{
		"DISPLAY_REQUIREMENT_UNSPECIFIED": 0,
		"ALL":                             1,
		"ANY":                             2,
		"NONE":                            3,
	}
)

func (x CompanionAds_DisplayRequirement) Enum() *CompanionAds_DisplayRequirement {
	p := new(CompanionAds_DisplayRequirement)
	*p = x
	return p
}

func (x CompanionAds_DisplayRequirement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompanionAds_DisplayRequirement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_stitcher_v1_companions_proto_enumTypes[0].Descriptor()
}

func (CompanionAds_DisplayRequirement) Type() protoreflect.EnumType {
	return &file_google_cloud_video_stitcher_v1_companions_proto_enumTypes[0]
}

func (x CompanionAds_DisplayRequirement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompanionAds_DisplayRequirement.Descriptor instead.
func (CompanionAds_DisplayRequirement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP(), []int{0, 0}
}

// Metadata for companion ads.
type CompanionAds struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates how many of the companions should be displayed with the ad.
	DisplayRequirement CompanionAds_DisplayRequirement `protobuf:"varint,1,opt,name=display_requirement,json=displayRequirement,proto3,enum=google.cloud.video.stitcher.v1.CompanionAds_DisplayRequirement" json:"display_requirement,omitempty"`
	// List of companion ads.
	Companions []*Companion `protobuf:"bytes,2,rep,name=companions,proto3" json:"companions,omitempty"`
}

func (x *CompanionAds) Reset() {
	*x = CompanionAds{}
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompanionAds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompanionAds) ProtoMessage() {}

func (x *CompanionAds) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompanionAds.ProtoReflect.Descriptor instead.
func (*CompanionAds) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP(), []int{0}
}

func (x *CompanionAds) GetDisplayRequirement() CompanionAds_DisplayRequirement {
	if x != nil {
		return x.DisplayRequirement
	}
	return CompanionAds_DISPLAY_REQUIREMENT_UNSPECIFIED
}

func (x *CompanionAds) GetCompanions() []*Companion {
	if x != nil {
		return x.Companions
	}
	return nil
}

// Metadata for a companion.
type Companion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ad resource associated with the companion ad.
	//
	// Types that are assignable to AdResource:
	//
	//	*Companion_IframeAdResource
	//	*Companion_StaticAdResource
	//	*Companion_HtmlAdResource
	AdResource isCompanion_AdResource `protobuf_oneof:"ad_resource"`
	// The API necessary to communicate with the creative if available.
	ApiFramework string `protobuf:"bytes,1,opt,name=api_framework,json=apiFramework,proto3" json:"api_framework,omitempty"`
	// The pixel height of the placement slot for the intended creative.
	HeightPx int32 `protobuf:"varint,2,opt,name=height_px,json=heightPx,proto3" json:"height_px,omitempty"`
	// The pixel width of the placement slot for the intended creative.
	WidthPx int32 `protobuf:"varint,3,opt,name=width_px,json=widthPx,proto3" json:"width_px,omitempty"`
	// The pixel height of the creative.
	AssetHeightPx int32 `protobuf:"varint,4,opt,name=asset_height_px,json=assetHeightPx,proto3" json:"asset_height_px,omitempty"`
	// The maximum pixel height of the creative in its expanded state.
	ExpandedHeightPx int32 `protobuf:"varint,5,opt,name=expanded_height_px,json=expandedHeightPx,proto3" json:"expanded_height_px,omitempty"`
	// The pixel width of the creative.
	AssetWidthPx int32 `protobuf:"varint,6,opt,name=asset_width_px,json=assetWidthPx,proto3" json:"asset_width_px,omitempty"`
	// The maximum pixel width of the creative in its expanded state.
	ExpandedWidthPx int32 `protobuf:"varint,7,opt,name=expanded_width_px,json=expandedWidthPx,proto3" json:"expanded_width_px,omitempty"`
	// The ID used to identify the desired placement on a publisher's page.
	// Values to be used should be discussed between publishers and
	// advertisers.
	AdSlotId string `protobuf:"bytes,8,opt,name=ad_slot_id,json=adSlotId,proto3" json:"ad_slot_id,omitempty"`
	// The list of tracking events for the companion.
	Events []*Event `protobuf:"bytes,9,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *Companion) Reset() {
	*x = Companion{}
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Companion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Companion) ProtoMessage() {}

func (x *Companion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Companion.ProtoReflect.Descriptor instead.
func (*Companion) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP(), []int{1}
}

func (m *Companion) GetAdResource() isCompanion_AdResource {
	if m != nil {
		return m.AdResource
	}
	return nil
}

func (x *Companion) GetIframeAdResource() *IframeAdResource {
	if x, ok := x.GetAdResource().(*Companion_IframeAdResource); ok {
		return x.IframeAdResource
	}
	return nil
}

func (x *Companion) GetStaticAdResource() *StaticAdResource {
	if x, ok := x.GetAdResource().(*Companion_StaticAdResource); ok {
		return x.StaticAdResource
	}
	return nil
}

func (x *Companion) GetHtmlAdResource() *HtmlAdResource {
	if x, ok := x.GetAdResource().(*Companion_HtmlAdResource); ok {
		return x.HtmlAdResource
	}
	return nil
}

func (x *Companion) GetApiFramework() string {
	if x != nil {
		return x.ApiFramework
	}
	return ""
}

func (x *Companion) GetHeightPx() int32 {
	if x != nil {
		return x.HeightPx
	}
	return 0
}

func (x *Companion) GetWidthPx() int32 {
	if x != nil {
		return x.WidthPx
	}
	return 0
}

func (x *Companion) GetAssetHeightPx() int32 {
	if x != nil {
		return x.AssetHeightPx
	}
	return 0
}

func (x *Companion) GetExpandedHeightPx() int32 {
	if x != nil {
		return x.ExpandedHeightPx
	}
	return 0
}

func (x *Companion) GetAssetWidthPx() int32 {
	if x != nil {
		return x.AssetWidthPx
	}
	return 0
}

func (x *Companion) GetExpandedWidthPx() int32 {
	if x != nil {
		return x.ExpandedWidthPx
	}
	return 0
}

func (x *Companion) GetAdSlotId() string {
	if x != nil {
		return x.AdSlotId
	}
	return ""
}

func (x *Companion) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

type isCompanion_AdResource interface {
	isCompanion_AdResource()
}

type Companion_IframeAdResource struct {
	// The IFrame ad resource associated with the companion ad.
	IframeAdResource *IframeAdResource `protobuf:"bytes,10,opt,name=iframe_ad_resource,json=iframeAdResource,proto3,oneof"`
}

type Companion_StaticAdResource struct {
	// The static ad resource associated with the companion ad.
	StaticAdResource *StaticAdResource `protobuf:"bytes,11,opt,name=static_ad_resource,json=staticAdResource,proto3,oneof"`
}

type Companion_HtmlAdResource struct {
	// The HTML ad resource associated with the companion ad.
	HtmlAdResource *HtmlAdResource `protobuf:"bytes,12,opt,name=html_ad_resource,json=htmlAdResource,proto3,oneof"`
}

func (*Companion_IframeAdResource) isCompanion_AdResource() {}

func (*Companion_StaticAdResource) isCompanion_AdResource() {}

func (*Companion_HtmlAdResource) isCompanion_AdResource() {}

// Metadata for an HTML ad resource.
type HtmlAdResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTML to display for the ad resource.
	HtmlSource string `protobuf:"bytes,1,opt,name=html_source,json=htmlSource,proto3" json:"html_source,omitempty"`
}

func (x *HtmlAdResource) Reset() {
	*x = HtmlAdResource{}
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HtmlAdResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HtmlAdResource) ProtoMessage() {}

func (x *HtmlAdResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HtmlAdResource.ProtoReflect.Descriptor instead.
func (*HtmlAdResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP(), []int{2}
}

func (x *HtmlAdResource) GetHtmlSource() string {
	if x != nil {
		return x.HtmlSource
	}
	return ""
}

// Metadata for an IFrame ad resource.
type IframeAdResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI source for an IFrame to display for the ad resource.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *IframeAdResource) Reset() {
	*x = IframeAdResource{}
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IframeAdResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IframeAdResource) ProtoMessage() {}

func (x *IframeAdResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IframeAdResource.ProtoReflect.Descriptor instead.
func (*IframeAdResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP(), []int{3}
}

func (x *IframeAdResource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Metadata for a static ad resource.
type StaticAdResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI to the static file for the ad resource.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Describes the MIME type of the ad resource.
	CreativeType string `protobuf:"bytes,2,opt,name=creative_type,json=creativeType,proto3" json:"creative_type,omitempty"`
}

func (x *StaticAdResource) Reset() {
	*x = StaticAdResource{}
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StaticAdResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticAdResource) ProtoMessage() {}

func (x *StaticAdResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticAdResource.ProtoReflect.Descriptor instead.
func (*StaticAdResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP(), []int{4}
}

func (x *StaticAdResource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *StaticAdResource) GetCreativeType() string {
	if x != nil {
		return x.CreativeType
	}
	return ""
}

var File_google_cloud_video_stitcher_v1_companions_proto protoreflect.FileDescriptor

var file_google_cloud_video_stitcher_v1_companions_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2,
	0x02, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x73, 0x12,
	0x70, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x49, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x55, 0x0a, 0x12,
	0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x49, 0x53, 0x50, 0x4c, 0x41, 0x59, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x49, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e,
	0x45, 0x10, 0x03, 0x22, 0x9c, 0x05, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f,
	0x6e, 0x12, 0x60, 0x0a, 0x12, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x61, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x10, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x60, 0x0a, 0x12, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x61, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x41, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x68, 0x74, 0x6d, 0x6c, 0x5f, 0x61, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x74, 0x6d, 0x6c, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x0e, 0x68, 0x74, 0x6d, 0x6c, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x70, 0x69, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x69, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x5f, 0x70, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x50, 0x78, 0x12, 0x19, 0x0a, 0x08, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x78, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x77, 0x69, 0x64, 0x74, 0x68, 0x50, 0x78, 0x12, 0x26,
	0x0a, 0x0f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70,
	0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x61, 0x73, 0x73, 0x65, 0x74, 0x48, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x50, 0x78, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x78, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x10, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x48, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x50, 0x78, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x5f, 0x70, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x57, 0x69, 0x64, 0x74, 0x68, 0x50, 0x78, 0x12, 0x2a, 0x0a, 0x11, 0x65, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x78, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x57,
	0x69, 0x64, 0x74, 0x68, 0x50, 0x78, 0x12, 0x1c, 0x0a, 0x0a, 0x61, 0x64, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x64, 0x53, 0x6c,
	0x6f, 0x74, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x31, 0x0a, 0x0e, 0x48, 0x74, 0x6d, 0x6c, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x74, 0x6d, 0x6c, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x68, 0x74, 0x6d, 0x6c, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x24, 0x0a, 0x10, 0x49, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x41,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x49, 0x0a, 0x10, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x41, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x77, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x43, 0x6f,
	0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x70, 0x62, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_stitcher_v1_companions_proto_rawDescOnce sync.Once
	file_google_cloud_video_stitcher_v1_companions_proto_rawDescData = file_google_cloud_video_stitcher_v1_companions_proto_rawDesc
)

func file_google_cloud_video_stitcher_v1_companions_proto_rawDescGZIP() []byte {
	file_google_cloud_video_stitcher_v1_companions_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_stitcher_v1_companions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_stitcher_v1_companions_proto_rawDescData)
	})
	return file_google_cloud_video_stitcher_v1_companions_proto_rawDescData
}

var file_google_cloud_video_stitcher_v1_companions_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_video_stitcher_v1_companions_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_video_stitcher_v1_companions_proto_goTypes = []any{
	(CompanionAds_DisplayRequirement)(0), // 0: google.cloud.video.stitcher.v1.CompanionAds.DisplayRequirement
	(*CompanionAds)(nil),                 // 1: google.cloud.video.stitcher.v1.CompanionAds
	(*Companion)(nil),                    // 2: google.cloud.video.stitcher.v1.Companion
	(*HtmlAdResource)(nil),               // 3: google.cloud.video.stitcher.v1.HtmlAdResource
	(*IframeAdResource)(nil),             // 4: google.cloud.video.stitcher.v1.IframeAdResource
	(*StaticAdResource)(nil),             // 5: google.cloud.video.stitcher.v1.StaticAdResource
	(*Event)(nil),                        // 6: google.cloud.video.stitcher.v1.Event
}
var file_google_cloud_video_stitcher_v1_companions_proto_depIdxs = []int32{
	0, // 0: google.cloud.video.stitcher.v1.CompanionAds.display_requirement:type_name -> google.cloud.video.stitcher.v1.CompanionAds.DisplayRequirement
	2, // 1: google.cloud.video.stitcher.v1.CompanionAds.companions:type_name -> google.cloud.video.stitcher.v1.Companion
	4, // 2: google.cloud.video.stitcher.v1.Companion.iframe_ad_resource:type_name -> google.cloud.video.stitcher.v1.IframeAdResource
	5, // 3: google.cloud.video.stitcher.v1.Companion.static_ad_resource:type_name -> google.cloud.video.stitcher.v1.StaticAdResource
	3, // 4: google.cloud.video.stitcher.v1.Companion.html_ad_resource:type_name -> google.cloud.video.stitcher.v1.HtmlAdResource
	6, // 5: google.cloud.video.stitcher.v1.Companion.events:type_name -> google.cloud.video.stitcher.v1.Event
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_video_stitcher_v1_companions_proto_init() }
func file_google_cloud_video_stitcher_v1_companions_proto_init() {
	if File_google_cloud_video_stitcher_v1_companions_proto != nil {
		return
	}
	file_google_cloud_video_stitcher_v1_events_proto_init()
	file_google_cloud_video_stitcher_v1_companions_proto_msgTypes[1].OneofWrappers = []any{
		(*Companion_IframeAdResource)(nil),
		(*Companion_StaticAdResource)(nil),
		(*Companion_HtmlAdResource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_stitcher_v1_companions_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_stitcher_v1_companions_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_stitcher_v1_companions_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_stitcher_v1_companions_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_stitcher_v1_companions_proto_msgTypes,
	}.Build()
	File_google_cloud_video_stitcher_v1_companions_proto = out.File
	file_google_cloud_video_stitcher_v1_companions_proto_rawDesc = nil
	file_google_cloud_video_stitcher_v1_companions_proto_goTypes = nil
	file_google_cloud_video_stitcher_v1_companions_proto_depIdxs = nil
}
