// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/dataflow/v1beta3/metrics.proto

package dataflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of some component of job execution.
type ExecutionState int32

const (
	// The component state is unknown or unspecified.
	ExecutionState_EXECUTION_STATE_UNKNOWN ExecutionState = 0
	// The component is not yet running.
	ExecutionState_EXECUTION_STATE_NOT_STARTED ExecutionState = 1
	// The component is currently running.
	ExecutionState_EXECUTION_STATE_RUNNING ExecutionState = 2
	// The component succeeded.
	ExecutionState_EXECUTION_STATE_SUCCEEDED ExecutionState = 3
	// The component failed.
	ExecutionState_EXECUTION_STATE_FAILED ExecutionState = 4
	// Execution of the component was cancelled.
	ExecutionState_EXECUTION_STATE_CANCELLED ExecutionState = 5
)

// Enum value maps for ExecutionState.
var (
	ExecutionState_name = map[int32]string{
		0: "EXECUTION_STATE_UNKNOWN",
		1: "EXECUTION_STATE_NOT_STARTED",
		2: "EXECUTION_STATE_RUNNING",
		3: "EXECUTION_STATE_SUCCEEDED",
		4: "EXECUTION_STATE_FAILED",
		5: "EXECUTION_STATE_CANCELLED",
	}
	ExecutionState_value = map[string]int32{
		"EXECUTION_STATE_UNKNOWN":     0,
		"EXECUTION_STATE_NOT_STARTED": 1,
		"EXECUTION_STATE_RUNNING":     2,
		"EXECUTION_STATE_SUCCEEDED":   3,
		"EXECUTION_STATE_FAILED":      4,
		"EXECUTION_STATE_CANCELLED":   5,
	}
)

func (x ExecutionState) Enum() *ExecutionState {
	p := new(ExecutionState)
	*p = x
	return p
}

func (x ExecutionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_dataflow_v1beta3_metrics_proto_enumTypes[0].Descriptor()
}

func (ExecutionState) Type() protoreflect.EnumType {
	return &file_google_dataflow_v1beta3_metrics_proto_enumTypes[0]
}

func (x ExecutionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionState.Descriptor instead.
func (ExecutionState) EnumDescriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{0}
}

// Identifies a metric, by describing the source which generated the
// metric.
type MetricStructuredName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Origin (namespace) of metric name. May be blank for user-define metrics;
	// will be "dataflow" for metrics defined by the Dataflow service or SDK.
	Origin string `protobuf:"bytes,1,opt,name=origin,proto3" json:"origin,omitempty"`
	// Worker-defined metric name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Zero or more labeled fields which identify the part of the job this
	// metric is associated with, such as the name of a step or collection.
	//
	// For example, built-in counters associated with steps will have
	// context['step'] = <step-name>. Counters associated with PCollections
	// in the SDK will have context['pcollection'] = <pcollection-name>.
	Context map[string]string `protobuf:"bytes,3,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *MetricStructuredName) Reset() {
	*x = MetricStructuredName{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricStructuredName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricStructuredName) ProtoMessage() {}

func (x *MetricStructuredName) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricStructuredName.ProtoReflect.Descriptor instead.
func (*MetricStructuredName) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *MetricStructuredName) GetOrigin() string {
	if x != nil {
		return x.Origin
	}
	return ""
}

func (x *MetricStructuredName) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricStructuredName) GetContext() map[string]string {
	if x != nil {
		return x.Context
	}
	return nil
}

// Describes the state of a metric.
type MetricUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the metric.
	Name *MetricStructuredName `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Metric aggregation kind.  The possible metric aggregation kinds are
	// "Sum", "Max", "Min", "Mean", "Set", "And", "Or", and "Distribution".
	// The specified aggregation kind is case-insensitive.
	//
	// If omitted, this is not an aggregated value but instead
	// a single metric sample value.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// True if this metric is reported as the total cumulative aggregate
	// value accumulated since the worker started working on this WorkItem.
	// By default this is false, indicating that this metric is reported
	// as a delta that is not associated with any WorkItem.
	Cumulative bool `protobuf:"varint,3,opt,name=cumulative,proto3" json:"cumulative,omitempty"`
	// Worker-computed aggregate value for aggregation kinds "Sum", "Max", "Min",
	// "And", and "Or".  The possible value types are Long, Double, and Boolean.
	Scalar *structpb.Value `protobuf:"bytes,4,opt,name=scalar,proto3" json:"scalar,omitempty"`
	// Worker-computed aggregate value for the "Mean" aggregation kind.
	// This holds the sum of the aggregated values and is used in combination
	// with mean_count below to obtain the actual mean aggregate value.
	// The only possible value types are Long and Double.
	MeanSum *structpb.Value `protobuf:"bytes,5,opt,name=mean_sum,json=meanSum,proto3" json:"mean_sum,omitempty"`
	// Worker-computed aggregate value for the "Mean" aggregation kind.
	// This holds the count of the aggregated values and is used in combination
	// with mean_sum above to obtain the actual mean aggregate value.
	// The only possible value type is Long.
	MeanCount *structpb.Value `protobuf:"bytes,6,opt,name=mean_count,json=meanCount,proto3" json:"mean_count,omitempty"`
	// Worker-computed aggregate value for the "Set" aggregation kind.  The only
	// possible value type is a list of Values whose type can be Long, Double,
	// or String, according to the metric's type.  All Values in the list must
	// be of the same type.
	Set *structpb.Value `protobuf:"bytes,7,opt,name=set,proto3" json:"set,omitempty"`
	// A struct value describing properties of a distribution of numeric values.
	Distribution *structpb.Value `protobuf:"bytes,11,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// A struct value describing properties of a Gauge.
	// Metrics of gauge type show the value of a metric across time, and is
	// aggregated based on the newest value.
	Gauge *structpb.Value `protobuf:"bytes,12,opt,name=gauge,proto3" json:"gauge,omitempty"`
	// Worker-computed aggregate value for internal use by the Dataflow
	// service.
	Internal *structpb.Value `protobuf:"bytes,8,opt,name=internal,proto3" json:"internal,omitempty"`
	// Timestamp associated with the metric value. Optional when workers are
	// reporting work progress; it will be filled in responses from the
	// metrics API.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *MetricUpdate) Reset() {
	*x = MetricUpdate{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricUpdate) ProtoMessage() {}

func (x *MetricUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricUpdate.ProtoReflect.Descriptor instead.
func (*MetricUpdate) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{1}
}

func (x *MetricUpdate) GetName() *MetricStructuredName {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *MetricUpdate) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *MetricUpdate) GetCumulative() bool {
	if x != nil {
		return x.Cumulative
	}
	return false
}

func (x *MetricUpdate) GetScalar() *structpb.Value {
	if x != nil {
		return x.Scalar
	}
	return nil
}

func (x *MetricUpdate) GetMeanSum() *structpb.Value {
	if x != nil {
		return x.MeanSum
	}
	return nil
}

func (x *MetricUpdate) GetMeanCount() *structpb.Value {
	if x != nil {
		return x.MeanCount
	}
	return nil
}

func (x *MetricUpdate) GetSet() *structpb.Value {
	if x != nil {
		return x.Set
	}
	return nil
}

func (x *MetricUpdate) GetDistribution() *structpb.Value {
	if x != nil {
		return x.Distribution
	}
	return nil
}

func (x *MetricUpdate) GetGauge() *structpb.Value {
	if x != nil {
		return x.Gauge
	}
	return nil
}

func (x *MetricUpdate) GetInternal() *structpb.Value {
	if x != nil {
		return x.Internal
	}
	return nil
}

func (x *MetricUpdate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request to get job metrics.
type GetJobMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project id.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job to get metrics for.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Return only metric data that has changed since this time.
	// Default is to return all information about all metrics for the job.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains the job specified by job_id.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *GetJobMetricsRequest) Reset() {
	*x = GetJobMetricsRequest{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetJobMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobMetricsRequest) ProtoMessage() {}

func (x *GetJobMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetJobMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{2}
}

func (x *GetJobMetricsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetJobMetricsRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *GetJobMetricsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *GetJobMetricsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// JobMetrics contains a collection of metrics describing the detailed progress
// of a Dataflow job. Metrics correspond to user-defined and system-defined
// metrics in the job.
//
// This resource captures only the most recent values of each metric;
// time-series data can be queried for them (under the same metric names)
// from Cloud Monitoring.
type JobMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp as of which metric values are current.
	MetricTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=metric_time,json=metricTime,proto3" json:"metric_time,omitempty"`
	// All metrics for this job.
	Metrics []*MetricUpdate `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *JobMetrics) Reset() {
	*x = JobMetrics{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JobMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobMetrics) ProtoMessage() {}

func (x *JobMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobMetrics.ProtoReflect.Descriptor instead.
func (*JobMetrics) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{3}
}

func (x *JobMetrics) GetMetricTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MetricTime
	}
	return nil
}

func (x *JobMetrics) GetMetrics() []*MetricUpdate {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Request to get job execution details.
type GetJobExecutionDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project id.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job to get execution details for.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains the job specified by job_id.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// If specified, determines the maximum number of stages to
	// return.  If unspecified, the service may choose an appropriate
	// default, or may return an arbitrarily large number of results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If supplied, this should be the value of next_page_token returned
	// by an earlier call. This will cause the next page of results to
	// be returned.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *GetJobExecutionDetailsRequest) Reset() {
	*x = GetJobExecutionDetailsRequest{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetJobExecutionDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJobExecutionDetailsRequest) ProtoMessage() {}

func (x *GetJobExecutionDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJobExecutionDetailsRequest.ProtoReflect.Descriptor instead.
func (*GetJobExecutionDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{4}
}

func (x *GetJobExecutionDetailsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetJobExecutionDetailsRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *GetJobExecutionDetailsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *GetJobExecutionDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *GetJobExecutionDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Information about the progress of some component of job execution.
type ProgressTimeseries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current progress of the component, in the range [0,1].
	CurrentProgress float64 `protobuf:"fixed64,1,opt,name=current_progress,json=currentProgress,proto3" json:"current_progress,omitempty"`
	// History of progress for the component.
	//
	// Points are sorted by time.
	DataPoints []*ProgressTimeseries_Point `protobuf:"bytes,2,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *ProgressTimeseries) Reset() {
	*x = ProgressTimeseries{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProgressTimeseries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProgressTimeseries) ProtoMessage() {}

func (x *ProgressTimeseries) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProgressTimeseries.ProtoReflect.Descriptor instead.
func (*ProgressTimeseries) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{5}
}

func (x *ProgressTimeseries) GetCurrentProgress() float64 {
	if x != nil {
		return x.CurrentProgress
	}
	return 0
}

func (x *ProgressTimeseries) GetDataPoints() []*ProgressTimeseries_Point {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// Information about a particular execution stage of a job.
type StageSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of this stage
	StageId string `protobuf:"bytes,1,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	// State of this stage.
	State ExecutionState `protobuf:"varint,2,opt,name=state,proto3,enum=google.dataflow.v1beta3.ExecutionState" json:"state,omitempty"`
	// Start time of this stage.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of this stage.
	//
	// If the work item is completed, this is the actual end time of the stage.
	// Otherwise, it is the predicted end time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Progress for this stage.
	// Only applicable to Batch jobs.
	Progress *ProgressTimeseries `protobuf:"bytes,5,opt,name=progress,proto3" json:"progress,omitempty"`
	// Metrics for this stage.
	Metrics []*MetricUpdate `protobuf:"bytes,6,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *StageSummary) Reset() {
	*x = StageSummary{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StageSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StageSummary) ProtoMessage() {}

func (x *StageSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StageSummary.ProtoReflect.Descriptor instead.
func (*StageSummary) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{6}
}

func (x *StageSummary) GetStageId() string {
	if x != nil {
		return x.StageId
	}
	return ""
}

func (x *StageSummary) GetState() ExecutionState {
	if x != nil {
		return x.State
	}
	return ExecutionState_EXECUTION_STATE_UNKNOWN
}

func (x *StageSummary) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *StageSummary) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *StageSummary) GetProgress() *ProgressTimeseries {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *StageSummary) GetMetrics() []*MetricUpdate {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Information about the execution of a job.
type JobExecutionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The stages of the job execution.
	Stages []*StageSummary `protobuf:"bytes,1,rep,name=stages,proto3" json:"stages,omitempty"`
	// If present, this response does not contain all requested tasks.  To obtain
	// the next page of results, repeat the request with page_token set to this
	// value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *JobExecutionDetails) Reset() {
	*x = JobExecutionDetails{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JobExecutionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobExecutionDetails) ProtoMessage() {}

func (x *JobExecutionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobExecutionDetails.ProtoReflect.Descriptor instead.
func (*JobExecutionDetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{7}
}

func (x *JobExecutionDetails) GetStages() []*StageSummary {
	if x != nil {
		return x.Stages
	}
	return nil
}

func (x *JobExecutionDetails) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to get information about a particular execution stage of a job.
// Currently only tracked for Batch jobs.
type GetStageExecutionDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A project id.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job to get execution details for.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// The [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
	// contains the job specified by job_id.
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// The stage for which to fetch information.
	StageId string `protobuf:"bytes,4,opt,name=stage_id,json=stageId,proto3" json:"stage_id,omitempty"`
	// If specified, determines the maximum number of work items to
	// return.  If unspecified, the service may choose an appropriate
	// default, or may return an arbitrarily large number of results.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If supplied, this should be the value of next_page_token returned
	// by an earlier call. This will cause the next page of results to
	// be returned.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Lower time bound of work items to include, by start time.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Upper time bound of work items to include, by start time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *GetStageExecutionDetailsRequest) Reset() {
	*x = GetStageExecutionDetailsRequest{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStageExecutionDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStageExecutionDetailsRequest) ProtoMessage() {}

func (x *GetStageExecutionDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStageExecutionDetailsRequest.ProtoReflect.Descriptor instead.
func (*GetStageExecutionDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{8}
}

func (x *GetStageExecutionDetailsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetStageExecutionDetailsRequest) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *GetStageExecutionDetailsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *GetStageExecutionDetailsRequest) GetStageId() string {
	if x != nil {
		return x.StageId
	}
	return ""
}

func (x *GetStageExecutionDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *GetStageExecutionDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *GetStageExecutionDetailsRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *GetStageExecutionDetailsRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Information about an individual work item execution.
type WorkItemDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this work item.
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Attempt ID of this work item
	AttemptId string `protobuf:"bytes,2,opt,name=attempt_id,json=attemptId,proto3" json:"attempt_id,omitempty"`
	// Start time of this work item attempt.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of this work item attempt.
	//
	// If the work item is completed, this is the actual end time of the work
	// item.  Otherwise, it is the predicted end time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// State of this work item.
	State ExecutionState `protobuf:"varint,5,opt,name=state,proto3,enum=google.dataflow.v1beta3.ExecutionState" json:"state,omitempty"`
	// Progress of this work item.
	Progress *ProgressTimeseries `protobuf:"bytes,6,opt,name=progress,proto3" json:"progress,omitempty"`
	// Metrics for this work item.
	Metrics []*MetricUpdate `protobuf:"bytes,7,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *WorkItemDetails) Reset() {
	*x = WorkItemDetails{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkItemDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkItemDetails) ProtoMessage() {}

func (x *WorkItemDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkItemDetails.ProtoReflect.Descriptor instead.
func (*WorkItemDetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{9}
}

func (x *WorkItemDetails) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *WorkItemDetails) GetAttemptId() string {
	if x != nil {
		return x.AttemptId
	}
	return ""
}

func (x *WorkItemDetails) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *WorkItemDetails) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *WorkItemDetails) GetState() ExecutionState {
	if x != nil {
		return x.State
	}
	return ExecutionState_EXECUTION_STATE_UNKNOWN
}

func (x *WorkItemDetails) GetProgress() *ProgressTimeseries {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *WorkItemDetails) GetMetrics() []*MetricUpdate {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Information about a worker
type WorkerDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this worker
	WorkerName string `protobuf:"bytes,1,opt,name=worker_name,json=workerName,proto3" json:"worker_name,omitempty"`
	// Work items processed by this worker, sorted by time.
	WorkItems []*WorkItemDetails `protobuf:"bytes,2,rep,name=work_items,json=workItems,proto3" json:"work_items,omitempty"`
}

func (x *WorkerDetails) Reset() {
	*x = WorkerDetails{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerDetails) ProtoMessage() {}

func (x *WorkerDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerDetails.ProtoReflect.Descriptor instead.
func (*WorkerDetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{10}
}

func (x *WorkerDetails) GetWorkerName() string {
	if x != nil {
		return x.WorkerName
	}
	return ""
}

func (x *WorkerDetails) GetWorkItems() []*WorkItemDetails {
	if x != nil {
		return x.WorkItems
	}
	return nil
}

// Information about the workers and work items within a stage.
type StageExecutionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Workers that have done work on the stage.
	Workers []*WorkerDetails `protobuf:"bytes,1,rep,name=workers,proto3" json:"workers,omitempty"`
	// If present, this response does not contain all requested tasks.  To obtain
	// the next page of results, repeat the request with page_token set to this
	// value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *StageExecutionDetails) Reset() {
	*x = StageExecutionDetails{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StageExecutionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StageExecutionDetails) ProtoMessage() {}

func (x *StageExecutionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StageExecutionDetails.ProtoReflect.Descriptor instead.
func (*StageExecutionDetails) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{11}
}

func (x *StageExecutionDetails) GetWorkers() []*WorkerDetails {
	if x != nil {
		return x.Workers
	}
	return nil
}

func (x *StageExecutionDetails) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A point in the timeseries.
type ProgressTimeseries_Point struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of the point.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// The value of the point.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *ProgressTimeseries_Point) Reset() {
	*x = ProgressTimeseries_Point{}
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProgressTimeseries_Point) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProgressTimeseries_Point) ProtoMessage() {}

func (x *ProgressTimeseries_Point) ProtoReflect() protoreflect.Message {
	mi := &file_google_dataflow_v1beta3_metrics_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProgressTimeseries_Point.ProtoReflect.Descriptor instead.
func (*ProgressTimeseries_Point) Descriptor() ([]byte, []int) {
	return file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ProgressTimeseries_Point) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *ProgressTimeseries_Point) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

var File_google_dataflow_v1beta3_metrics_proto protoreflect.FileDescriptor

var file_google_dataflow_v1beta3_metrics_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x01, 0x0a, 0x14, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x1a, 0x3a, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa4, 0x04,
	0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x75, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63, 0x75, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x12, 0x2e, 0x0a, 0x06, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x73,
	0x63, 0x61, 0x6c, 0x61, 0x72, 0x12, 0x31, 0x0a, 0x08, 0x6d, 0x65, 0x61, 0x6e, 0x5f, 0x73, 0x75,
	0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x07, 0x6d, 0x65, 0x61, 0x6e, 0x53, 0x75, 0x6d, 0x12, 0x35, 0x0a, 0x0a, 0x6d, 0x65, 0x61, 0x6e,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x6d, 0x65, 0x61, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x28, 0x0a, 0x03, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x73, 0x65, 0x74, 0x12, 0x3a, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x05, 0x67, 0x61, 0x75, 0x67, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x67, 0x61,
	0x75, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06,
	0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f,
	0x62, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x0a, 0x4a,
	0x6f, 0x62, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xad, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4a,
	0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe2, 0x01, 0x0a, 0x12, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x29,
	0x0a, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0x4d, 0x0a,
	0x05, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe4, 0x02, 0x0a,
	0x0c, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x19, 0x0a,
	0x08, 0x73, 0x74, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x73, 0x74, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x22, 0x7c, 0x0a, 0x13, 0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x52, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xbc, 0x02, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x53, 0x74, 0x61, 0x67, 0x65, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x67, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x74, 0x61, 0x67, 0x65,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x84, 0x03, 0x0a, 0x0f, 0x57, 0x6f, 0x72, 0x6b, 0x49, 0x74, 0x65, 0x6d, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x1d, 0x0a,
	0x0a, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x79, 0x0a, 0x0d, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x49, 0x74, 0x65, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x22, 0x81, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x07,
	0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0xc5, 0x01, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x58, 0x45,
	0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x54,
	0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x1d, 0x0a, 0x19, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x32, 0x9f,
	0x07, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0x33, 0x12, 0xe9, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x65,
	0x74, 0x4a, 0x6f, 0x62, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x83, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7d,
	0x5a, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f,
	0x62, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0xd7, 0x01,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x4a, 0x6f, 0x62, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x57,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xef, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x53,
	0x74, 0x61, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x61, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x69,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x12, 0x61, 0x2f, 0x76, 0x31, 0x62, 0x33, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x74, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0xd4, 0x01, 0xca, 0x41, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xb6, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c,
	0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x42, 0xcf, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x42, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c,
	0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xaa,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x33, 0xca,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44,
	0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0xea,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_dataflow_v1beta3_metrics_proto_rawDescOnce sync.Once
	file_google_dataflow_v1beta3_metrics_proto_rawDescData = file_google_dataflow_v1beta3_metrics_proto_rawDesc
)

func file_google_dataflow_v1beta3_metrics_proto_rawDescGZIP() []byte {
	file_google_dataflow_v1beta3_metrics_proto_rawDescOnce.Do(func() {
		file_google_dataflow_v1beta3_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_dataflow_v1beta3_metrics_proto_rawDescData)
	})
	return file_google_dataflow_v1beta3_metrics_proto_rawDescData
}

var file_google_dataflow_v1beta3_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_dataflow_v1beta3_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_dataflow_v1beta3_metrics_proto_goTypes = []any{
	(ExecutionState)(0),                     // 0: google.dataflow.v1beta3.ExecutionState
	(*MetricStructuredName)(nil),            // 1: google.dataflow.v1beta3.MetricStructuredName
	(*MetricUpdate)(nil),                    // 2: google.dataflow.v1beta3.MetricUpdate
	(*GetJobMetricsRequest)(nil),            // 3: google.dataflow.v1beta3.GetJobMetricsRequest
	(*JobMetrics)(nil),                      // 4: google.dataflow.v1beta3.JobMetrics
	(*GetJobExecutionDetailsRequest)(nil),   // 5: google.dataflow.v1beta3.GetJobExecutionDetailsRequest
	(*ProgressTimeseries)(nil),              // 6: google.dataflow.v1beta3.ProgressTimeseries
	(*StageSummary)(nil),                    // 7: google.dataflow.v1beta3.StageSummary
	(*JobExecutionDetails)(nil),             // 8: google.dataflow.v1beta3.JobExecutionDetails
	(*GetStageExecutionDetailsRequest)(nil), // 9: google.dataflow.v1beta3.GetStageExecutionDetailsRequest
	(*WorkItemDetails)(nil),                 // 10: google.dataflow.v1beta3.WorkItemDetails
	(*WorkerDetails)(nil),                   // 11: google.dataflow.v1beta3.WorkerDetails
	(*StageExecutionDetails)(nil),           // 12: google.dataflow.v1beta3.StageExecutionDetails
	nil,                                     // 13: google.dataflow.v1beta3.MetricStructuredName.ContextEntry
	(*ProgressTimeseries_Point)(nil),        // 14: google.dataflow.v1beta3.ProgressTimeseries.Point
	(*structpb.Value)(nil),                  // 15: google.protobuf.Value
	(*timestamppb.Timestamp)(nil),           // 16: google.protobuf.Timestamp
}
var file_google_dataflow_v1beta3_metrics_proto_depIdxs = []int32{
	13, // 0: google.dataflow.v1beta3.MetricStructuredName.context:type_name -> google.dataflow.v1beta3.MetricStructuredName.ContextEntry
	1,  // 1: google.dataflow.v1beta3.MetricUpdate.name:type_name -> google.dataflow.v1beta3.MetricStructuredName
	15, // 2: google.dataflow.v1beta3.MetricUpdate.scalar:type_name -> google.protobuf.Value
	15, // 3: google.dataflow.v1beta3.MetricUpdate.mean_sum:type_name -> google.protobuf.Value
	15, // 4: google.dataflow.v1beta3.MetricUpdate.mean_count:type_name -> google.protobuf.Value
	15, // 5: google.dataflow.v1beta3.MetricUpdate.set:type_name -> google.protobuf.Value
	15, // 6: google.dataflow.v1beta3.MetricUpdate.distribution:type_name -> google.protobuf.Value
	15, // 7: google.dataflow.v1beta3.MetricUpdate.gauge:type_name -> google.protobuf.Value
	15, // 8: google.dataflow.v1beta3.MetricUpdate.internal:type_name -> google.protobuf.Value
	16, // 9: google.dataflow.v1beta3.MetricUpdate.update_time:type_name -> google.protobuf.Timestamp
	16, // 10: google.dataflow.v1beta3.GetJobMetricsRequest.start_time:type_name -> google.protobuf.Timestamp
	16, // 11: google.dataflow.v1beta3.JobMetrics.metric_time:type_name -> google.protobuf.Timestamp
	2,  // 12: google.dataflow.v1beta3.JobMetrics.metrics:type_name -> google.dataflow.v1beta3.MetricUpdate
	14, // 13: google.dataflow.v1beta3.ProgressTimeseries.data_points:type_name -> google.dataflow.v1beta3.ProgressTimeseries.Point
	0,  // 14: google.dataflow.v1beta3.StageSummary.state:type_name -> google.dataflow.v1beta3.ExecutionState
	16, // 15: google.dataflow.v1beta3.StageSummary.start_time:type_name -> google.protobuf.Timestamp
	16, // 16: google.dataflow.v1beta3.StageSummary.end_time:type_name -> google.protobuf.Timestamp
	6,  // 17: google.dataflow.v1beta3.StageSummary.progress:type_name -> google.dataflow.v1beta3.ProgressTimeseries
	2,  // 18: google.dataflow.v1beta3.StageSummary.metrics:type_name -> google.dataflow.v1beta3.MetricUpdate
	7,  // 19: google.dataflow.v1beta3.JobExecutionDetails.stages:type_name -> google.dataflow.v1beta3.StageSummary
	16, // 20: google.dataflow.v1beta3.GetStageExecutionDetailsRequest.start_time:type_name -> google.protobuf.Timestamp
	16, // 21: google.dataflow.v1beta3.GetStageExecutionDetailsRequest.end_time:type_name -> google.protobuf.Timestamp
	16, // 22: google.dataflow.v1beta3.WorkItemDetails.start_time:type_name -> google.protobuf.Timestamp
	16, // 23: google.dataflow.v1beta3.WorkItemDetails.end_time:type_name -> google.protobuf.Timestamp
	0,  // 24: google.dataflow.v1beta3.WorkItemDetails.state:type_name -> google.dataflow.v1beta3.ExecutionState
	6,  // 25: google.dataflow.v1beta3.WorkItemDetails.progress:type_name -> google.dataflow.v1beta3.ProgressTimeseries
	2,  // 26: google.dataflow.v1beta3.WorkItemDetails.metrics:type_name -> google.dataflow.v1beta3.MetricUpdate
	10, // 27: google.dataflow.v1beta3.WorkerDetails.work_items:type_name -> google.dataflow.v1beta3.WorkItemDetails
	11, // 28: google.dataflow.v1beta3.StageExecutionDetails.workers:type_name -> google.dataflow.v1beta3.WorkerDetails
	16, // 29: google.dataflow.v1beta3.ProgressTimeseries.Point.time:type_name -> google.protobuf.Timestamp
	3,  // 30: google.dataflow.v1beta3.MetricsV1Beta3.GetJobMetrics:input_type -> google.dataflow.v1beta3.GetJobMetricsRequest
	5,  // 31: google.dataflow.v1beta3.MetricsV1Beta3.GetJobExecutionDetails:input_type -> google.dataflow.v1beta3.GetJobExecutionDetailsRequest
	9,  // 32: google.dataflow.v1beta3.MetricsV1Beta3.GetStageExecutionDetails:input_type -> google.dataflow.v1beta3.GetStageExecutionDetailsRequest
	4,  // 33: google.dataflow.v1beta3.MetricsV1Beta3.GetJobMetrics:output_type -> google.dataflow.v1beta3.JobMetrics
	8,  // 34: google.dataflow.v1beta3.MetricsV1Beta3.GetJobExecutionDetails:output_type -> google.dataflow.v1beta3.JobExecutionDetails
	12, // 35: google.dataflow.v1beta3.MetricsV1Beta3.GetStageExecutionDetails:output_type -> google.dataflow.v1beta3.StageExecutionDetails
	33, // [33:36] is the sub-list for method output_type
	30, // [30:33] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_dataflow_v1beta3_metrics_proto_init() }
func file_google_dataflow_v1beta3_metrics_proto_init() {
	if File_google_dataflow_v1beta3_metrics_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_dataflow_v1beta3_metrics_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_dataflow_v1beta3_metrics_proto_goTypes,
		DependencyIndexes: file_google_dataflow_v1beta3_metrics_proto_depIdxs,
		EnumInfos:         file_google_dataflow_v1beta3_metrics_proto_enumTypes,
		MessageInfos:      file_google_dataflow_v1beta3_metrics_proto_msgTypes,
	}.Build()
	File_google_dataflow_v1beta3_metrics_proto = out.File
	file_google_dataflow_v1beta3_metrics_proto_rawDesc = nil
	file_google_dataflow_v1beta3_metrics_proto_goTypes = nil
	file_google_dataflow_v1beta3_metrics_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MetricsV1Beta3Client is the client API for MetricsV1Beta3 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetricsV1Beta3Client interface {
	// Request the job status.
	//
	// To request the status of a job, we recommend using
	// `projects.locations.jobs.getMetrics` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.getMetrics` is not recommended, as you can only request the
	// status of jobs that are running in `us-central1`.
	GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*JobMetrics, error)
	// Request detailed information about the execution status of the job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetJobExecutionDetails(ctx context.Context, in *GetJobExecutionDetailsRequest, opts ...grpc.CallOption) (*JobExecutionDetails, error)
	// Request detailed information about the execution status of a stage of the
	// job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetStageExecutionDetails(ctx context.Context, in *GetStageExecutionDetailsRequest, opts ...grpc.CallOption) (*StageExecutionDetails, error)
}

type metricsV1Beta3Client struct {
	cc grpc.ClientConnInterface
}

func NewMetricsV1Beta3Client(cc grpc.ClientConnInterface) MetricsV1Beta3Client {
	return &metricsV1Beta3Client{cc}
}

func (c *metricsV1Beta3Client) GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*JobMetrics, error) {
	out := new(JobMetrics)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.MetricsV1Beta3/GetJobMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsV1Beta3Client) GetJobExecutionDetails(ctx context.Context, in *GetJobExecutionDetailsRequest, opts ...grpc.CallOption) (*JobExecutionDetails, error) {
	out := new(JobExecutionDetails)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.MetricsV1Beta3/GetJobExecutionDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsV1Beta3Client) GetStageExecutionDetails(ctx context.Context, in *GetStageExecutionDetailsRequest, opts ...grpc.CallOption) (*StageExecutionDetails, error) {
	out := new(StageExecutionDetails)
	err := c.cc.Invoke(ctx, "/google.dataflow.v1beta3.MetricsV1Beta3/GetStageExecutionDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetricsV1Beta3Server is the server API for MetricsV1Beta3 service.
type MetricsV1Beta3Server interface {
	// Request the job status.
	//
	// To request the status of a job, we recommend using
	// `projects.locations.jobs.getMetrics` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.getMetrics` is not recommended, as you can only request the
	// status of jobs that are running in `us-central1`.
	GetJobMetrics(context.Context, *GetJobMetricsRequest) (*JobMetrics, error)
	// Request detailed information about the execution status of the job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetJobExecutionDetails(context.Context, *GetJobExecutionDetailsRequest) (*JobExecutionDetails, error)
	// Request detailed information about the execution status of a stage of the
	// job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetStageExecutionDetails(context.Context, *GetStageExecutionDetailsRequest) (*StageExecutionDetails, error)
}

// UnimplementedMetricsV1Beta3Server can be embedded to have forward compatible implementations.
type UnimplementedMetricsV1Beta3Server struct {
}

func (*UnimplementedMetricsV1Beta3Server) GetJobMetrics(context.Context, *GetJobMetricsRequest) (*JobMetrics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobMetrics not implemented")
}
func (*UnimplementedMetricsV1Beta3Server) GetJobExecutionDetails(context.Context, *GetJobExecutionDetailsRequest) (*JobExecutionDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobExecutionDetails not implemented")
}
func (*UnimplementedMetricsV1Beta3Server) GetStageExecutionDetails(context.Context, *GetStageExecutionDetailsRequest) (*StageExecutionDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStageExecutionDetails not implemented")
}

func RegisterMetricsV1Beta3Server(s *grpc.Server, srv MetricsV1Beta3Server) {
	s.RegisterService(&_MetricsV1Beta3_serviceDesc, srv)
}

func _MetricsV1Beta3_GetJobMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsV1Beta3Server).GetJobMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.MetricsV1Beta3/GetJobMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsV1Beta3Server).GetJobMetrics(ctx, req.(*GetJobMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsV1Beta3_GetJobExecutionDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobExecutionDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsV1Beta3Server).GetJobExecutionDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.MetricsV1Beta3/GetJobExecutionDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsV1Beta3Server).GetJobExecutionDetails(ctx, req.(*GetJobExecutionDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsV1Beta3_GetStageExecutionDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStageExecutionDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsV1Beta3Server).GetStageExecutionDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.dataflow.v1beta3.MetricsV1Beta3/GetStageExecutionDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsV1Beta3Server).GetStageExecutionDetails(ctx, req.(*GetStageExecutionDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetricsV1Beta3_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.MetricsV1Beta3",
	HandlerType: (*MetricsV1Beta3Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetJobMetrics",
			Handler:    _MetricsV1Beta3_GetJobMetrics_Handler,
		},
		{
			MethodName: "GetJobExecutionDetails",
			Handler:    _MetricsV1Beta3_GetJobExecutionDetails_Handler,
		},
		{
			MethodName: "GetStageExecutionDetails",
			Handler:    _MetricsV1Beta3_GetStageExecutionDetails_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/metrics.proto",
}
