// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
)

// ServiceControlClient provides methods for managing ServiceControl resources of Yandex.Cloud IAM.
type ServiceControlClient interface {
	ServiceControlClientIterator
	Get(context.Context, *iam.GetServiceRequest, ...grpc.CallOption) (*iam.Service, error)
	List(context.Context, *iam.ListServicesRequest, ...grpc.CallOption) (*iam.ListServicesResponse, error)
	Enable(context.Context, *iam.EnableServiceRequest, ...grpc.CallOption) (*ServiceControlEnableOperation, error)
	Disable(context.Context, *iam.DisableServiceRequest, ...grpc.CallOption) (*ServiceControlDisableOperation, error)
	ResolveAgent(context.Context, *iam.ResolveServiceAgentRequest, ...grpc.CallOption) (*iam.ServiceAgent, error)
}

var _ ServiceControlClient = serviceControlClient{}

type serviceControlClient struct {
	connector transport.Connector
}

// NewServiceControlClient returns ServiceControlClient implementation.
func NewServiceControlClient(connector transport.Connector) ServiceControlClient {
	return serviceControlClient{connector}
}

// Get is an operation of Yandex.Cloud IAM ServiceControl service.
func (c serviceControlClient) Get(ctx context.Context, in *iam.GetServiceRequest, opts ...grpc.CallOption) (*iam.Service, error) {
	connection, err := c.connector.GetConnection(ctx, ServiceControlGet, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud IAM ServiceControl service.
func (c serviceControlClient) List(ctx context.Context, in *iam.ListServicesRequest, opts ...grpc.CallOption) (*iam.ListServicesResponse, error) {
	connection, err := c.connector.GetConnection(ctx, ServiceControlList, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(connection).List(ctx, in, opts...)
}

// ServiceControlEnableOperation is used to monitor the state of Enable operations.
type ServiceControlEnableOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *ServiceControlEnableOperation) Metadata() *iam.EnableServiceMetadata {
	return o.Operation.Metadata().(*iam.EnableServiceMetadata)
}

// Response retrieves the operation response.
func (o *ServiceControlEnableOperation) Response() *iam.Service {
	return o.Operation.Response().(*iam.Service)
}

// Wait polls the operation until it's done.
func (o *ServiceControlEnableOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.Service, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.Service)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *ServiceControlEnableOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.Service, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.Service)
	return response, err
}

// Enable is an operation of Yandex.Cloud IAM ServiceControl service.
// It returns an object which should be used to monitor the operation state.
func (c serviceControlClient) Enable(ctx context.Context, in *iam.EnableServiceRequest, opts ...grpc.CallOption) (*ServiceControlEnableOperation, error) {
	connection, err := c.connector.GetConnection(ctx, ServiceControlEnable, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewServiceControlServiceClient(connection).Enable(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.EnableServiceMetadata)(nil),
		ResponseType: (*iam.Service)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &ServiceControlEnableOperation{*op}, nil
}

// ServiceControlDisableOperation is used to monitor the state of Disable operations.
type ServiceControlDisableOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *ServiceControlDisableOperation) Metadata() *iam.DisableServiceMetadata {
	return o.Operation.Metadata().(*iam.DisableServiceMetadata)
}

// Response retrieves the operation response.
func (o *ServiceControlDisableOperation) Response() *iam.Service {
	return o.Operation.Response().(*iam.Service)
}

// Wait polls the operation until it's done.
func (o *ServiceControlDisableOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*iam.Service, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*iam.Service)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *ServiceControlDisableOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*iam.Service, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*iam.Service)
	return response, err
}

// Disable is an operation of Yandex.Cloud IAM ServiceControl service.
// It returns an object which should be used to monitor the operation state.
func (c serviceControlClient) Disable(ctx context.Context, in *iam.DisableServiceRequest, opts ...grpc.CallOption) (*ServiceControlDisableOperation, error) {
	connection, err := c.connector.GetConnection(ctx, ServiceControlDisable, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := iam.NewServiceControlServiceClient(connection).Disable(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*iam.DisableServiceMetadata)(nil),
		ResponseType: (*iam.Service)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &ServiceControlDisableOperation{*op}, nil
}

// ResolveAgent is an operation of Yandex.Cloud IAM ServiceControl service.
func (c serviceControlClient) ResolveAgent(ctx context.Context, in *iam.ResolveServiceAgentRequest, opts ...grpc.CallOption) (*iam.ServiceAgent, error) {
	connection, err := c.connector.GetConnection(ctx, ServiceControlResolveAgent, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(connection).ResolveAgent(ctx, in, opts...)
}

// pollOperation returns the current state of the polled operation.
func (c serviceControlClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, ServiceControlOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	ServiceControlGet             = protoreflect.FullName("yandex.cloud.iam.v1.ServiceControlService.Get")
	ServiceControlList            = protoreflect.FullName("yandex.cloud.iam.v1.ServiceControlService.List")
	ServiceControlEnable          = protoreflect.FullName("yandex.cloud.iam.v1.ServiceControlService.Enable")
	ServiceControlDisable         = protoreflect.FullName("yandex.cloud.iam.v1.ServiceControlService.Disable")
	ServiceControlResolveAgent    = protoreflect.FullName("yandex.cloud.iam.v1.ServiceControlService.ResolveAgent")
	ServiceControlOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
