// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/index_endpoint.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indexes are deployed into it. An IndexEndpoint can have multiple
// DeployedIndexes.
type IndexEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the IndexEndpoint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the IndexEndpoint.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the IndexEndpoint.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The indexes deployed in this endpoint.
	DeployedIndexes []*DeployedIndex `protobuf:"bytes,4,rep,name=deployed_indexes,json=deployedIndexes,proto3" json:"deployed_indexes,omitempty"`
	// Used to perform consistent read-modify-write updates. If not set, a blind
	// "overwrite" update happens.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
	// The labels with user-defined metadata to organize your IndexEndpoints.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Timestamp when this IndexEndpoint was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this IndexEndpoint was last updated.
	// This timestamp is not updated when the endpoint's DeployedIndexes are
	// updated, e.g. due to updates of the original Indexes they are the
	// deployments of.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
	// to which the IndexEndpoint should be peered.
	//
	// Private services access must already be configured for the network. If left
	// unspecified, the Endpoint is not peered with any network.
	//
	// [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
	// [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
	// are mutually exclusive.
	//
	// [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`.
	// Where {project} is a project number, as in '12345', and {network} is
	// network name.
	Network string `protobuf:"bytes,9,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. Deprecated: If true, expose the IndexEndpoint via private service
	// connect.
	//
	// Only one of the fields,
	// [network][google.cloud.aiplatform.v1.IndexEndpoint.network] or
	// [enable_private_service_connect][google.cloud.aiplatform.v1.IndexEndpoint.enable_private_service_connect],
	// can be set.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/index_endpoint.proto.
	EnablePrivateServiceConnect bool `protobuf:"varint,10,opt,name=enable_private_service_connect,json=enablePrivateServiceConnect,proto3" json:"enable_private_service_connect,omitempty"`
	// Optional. Configuration for private service connect.
	//
	// [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
	// [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
	// are mutually exclusive.
	PrivateServiceConnectConfig *PrivateServiceConnectConfig `protobuf:"bytes,12,opt,name=private_service_connect_config,json=privateServiceConnectConfig,proto3" json:"private_service_connect_config,omitempty"`
	// Optional. If true, the deployed index will be accessible through public
	// endpoint.
	PublicEndpointEnabled bool `protobuf:"varint,13,opt,name=public_endpoint_enabled,json=publicEndpointEnabled,proto3" json:"public_endpoint_enabled,omitempty"`
	// Output only. If
	// [public_endpoint_enabled][google.cloud.aiplatform.v1.IndexEndpoint.public_endpoint_enabled]
	// is true, this field will be populated with the domain name to use for this
	// index endpoint.
	PublicEndpointDomainName string `protobuf:"bytes,14,opt,name=public_endpoint_domain_name,json=publicEndpointDomainName,proto3" json:"public_endpoint_domain_name,omitempty"`
	// Immutable. Customer-managed encryption key spec for an IndexEndpoint. If
	// set, this IndexEndpoint and all sub-resources of this IndexEndpoint will be
	// secured by this key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,15,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,17,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,18,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *IndexEndpoint) Reset() {
	*x = IndexEndpoint{}
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IndexEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexEndpoint) ProtoMessage() {}

func (x *IndexEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexEndpoint.ProtoReflect.Descriptor instead.
func (*IndexEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescGZIP(), []int{0}
}

func (x *IndexEndpoint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IndexEndpoint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *IndexEndpoint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *IndexEndpoint) GetDeployedIndexes() []*DeployedIndex {
	if x != nil {
		return x.DeployedIndexes
	}
	return nil
}

func (x *IndexEndpoint) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *IndexEndpoint) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *IndexEndpoint) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IndexEndpoint) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *IndexEndpoint) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/index_endpoint.proto.
func (x *IndexEndpoint) GetEnablePrivateServiceConnect() bool {
	if x != nil {
		return x.EnablePrivateServiceConnect
	}
	return false
}

func (x *IndexEndpoint) GetPrivateServiceConnectConfig() *PrivateServiceConnectConfig {
	if x != nil {
		return x.PrivateServiceConnectConfig
	}
	return nil
}

func (x *IndexEndpoint) GetPublicEndpointEnabled() bool {
	if x != nil {
		return x.PublicEndpointEnabled
	}
	return false
}

func (x *IndexEndpoint) GetPublicEndpointDomainName() string {
	if x != nil {
		return x.PublicEndpointDomainName
	}
	return ""
}

func (x *IndexEndpoint) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *IndexEndpoint) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *IndexEndpoint) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

// A deployment of an Index. IndexEndpoints contain one or more DeployedIndexes.
type DeployedIndex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user specified ID of the DeployedIndex.
	// The ID can be up to 128 characters long and must start with a letter and
	// only contain letters, numbers, and underscores.
	// The ID must be unique within the project it is created in.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The name of the Index this is the deployment of.
	// We may refer to this Index as the DeployedIndex's "original" Index.
	Index string `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	// The display name of the DeployedIndex. If not provided upon creation,
	// the Index's display_name is used.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Timestamp when the DeployedIndex was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Provides paths for users to send requests directly to the
	// deployed index services running on Cloud via private services access. This
	// field is populated if
	// [network][google.cloud.aiplatform.v1.IndexEndpoint.network] is configured.
	PrivateEndpoints *IndexPrivateEndpoints `protobuf:"bytes,5,opt,name=private_endpoints,json=privateEndpoints,proto3" json:"private_endpoints,omitempty"`
	// Output only. The DeployedIndex may depend on various data on its original
	// Index. Additionally when certain changes to the original Index are being
	// done (e.g. when what the Index contains is being changed) the DeployedIndex
	// may be asynchronously updated in the background to reflect these changes.
	// If this timestamp's value is at least the
	// [Index.update_time][google.cloud.aiplatform.v1.Index.update_time] of the
	// original Index, it means that this DeployedIndex and the original Index are
	// in sync. If this timestamp is older, then to see which updates this
	// DeployedIndex already contains (and which it does not), one must
	// [list][google.longrunning.Operations.ListOperations] the operations that
	// are running on the original Index. Only the successfully completed
	// Operations with
	// [update_time][google.cloud.aiplatform.v1.GenericOperationMetadata.update_time]
	// equal or before this sync time are contained in this DeployedIndex.
	IndexSyncTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=index_sync_time,json=indexSyncTime,proto3" json:"index_sync_time,omitempty"`
	// Optional. A description of resources that the DeployedIndex uses, which to
	// large degree are decided by Vertex AI, and optionally allows only a modest
	// additional configuration.
	// If min_replica_count is not set, the default value is 2 (we don't provide
	// SLA when min_replica_count=1). If max_replica_count is not set, the
	// default value is min_replica_count. The max allowed replica count is
	// 1000.
	AutomaticResources *AutomaticResources `protobuf:"bytes,7,opt,name=automatic_resources,json=automaticResources,proto3" json:"automatic_resources,omitempty"`
	// Optional. A description of resources that are dedicated to the
	// DeployedIndex, and that need a higher degree of manual configuration. The
	// field min_replica_count must be set to a value strictly greater than 0, or
	// else validation will fail. We don't provide SLA when min_replica_count=1.
	// If max_replica_count is not set, the default value is min_replica_count.
	// The max allowed replica count is 1000.
	//
	// Available machine types for SMALL shard:
	// e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
	//
	// Available machine types for MEDIUM shard:
	// e2-standard-16 and all machine types available for LARGE shard.
	//
	// Available machine types for LARGE shard:
	// e2-highmem-16, n2d-standard-32.
	//
	// n1-standard-16 and n1-standard-32 are still available, but we recommend
	// e2-standard-16 and e2-highmem-16 for cost efficiency.
	DedicatedResources *DedicatedResources `protobuf:"bytes,16,opt,name=dedicated_resources,json=dedicatedResources,proto3" json:"dedicated_resources,omitempty"`
	// Optional. If true, private endpoint's access logs are sent to Cloud
	// Logging.
	//
	// These logs are like standard server access logs, containing
	// information like timestamp and latency for each MatchRequest.
	//
	// Note that logs may incur a cost, especially if the deployed
	// index receives a high queries per second rate (QPS).
	// Estimate your costs before enabling this option.
	EnableAccessLogging bool `protobuf:"varint,8,opt,name=enable_access_logging,json=enableAccessLogging,proto3" json:"enable_access_logging,omitempty"`
	// Optional. If set, the authentication is enabled for the private endpoint.
	DeployedIndexAuthConfig *DeployedIndexAuthConfig `protobuf:"bytes,9,opt,name=deployed_index_auth_config,json=deployedIndexAuthConfig,proto3" json:"deployed_index_auth_config,omitempty"`
	// Optional. A list of reserved ip ranges under the VPC network that can be
	// used for this DeployedIndex.
	//
	// If set, we will deploy the index within the provided ip ranges. Otherwise,
	// the index might be deployed to any ip ranges under the provided VPC
	// network.
	//
	// The value should be the name of the address
	// (https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
	// Example: ['vertex-ai-ip-range'].
	//
	// For more information about subnets and network IP ranges, please see
	// https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
	ReservedIpRanges []string `protobuf:"bytes,10,rep,name=reserved_ip_ranges,json=reservedIpRanges,proto3" json:"reserved_ip_ranges,omitempty"`
	// Optional. The deployment group can be no longer than 64 characters (eg:
	// 'test', 'prod'). If not set, we will use the 'default' deployment group.
	//
	// Creating `deployment_groups` with `reserved_ip_ranges` is a recommended
	// practice when the peered network has multiple peering ranges. This creates
	// your deployments from predictable IP spaces for easier traffic
	// administration. Also, one deployment_group (except 'default') can only be
	// used with the same reserved_ip_ranges which means if the deployment_group
	// has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
	// [d, e] is disallowed.
	//
	// Note: we only support up to 5 deployment groups(not including 'default').
	DeploymentGroup string `protobuf:"bytes,11,opt,name=deployment_group,json=deploymentGroup,proto3" json:"deployment_group,omitempty"`
	// Optional. If set for PSC deployed index, PSC connection will be
	// automatically created after deployment is done and the endpoint information
	// is populated in private_endpoints.psc_automated_endpoints.
	PscAutomationConfigs []*PSCAutomationConfig `protobuf:"bytes,19,rep,name=psc_automation_configs,json=pscAutomationConfigs,proto3" json:"psc_automation_configs,omitempty"`
}

func (x *DeployedIndex) Reset() {
	*x = DeployedIndex{}
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployedIndex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedIndex) ProtoMessage() {}

func (x *DeployedIndex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedIndex.ProtoReflect.Descriptor instead.
func (*DeployedIndex) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescGZIP(), []int{1}
}

func (x *DeployedIndex) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeployedIndex) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *DeployedIndex) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DeployedIndex) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DeployedIndex) GetPrivateEndpoints() *IndexPrivateEndpoints {
	if x != nil {
		return x.PrivateEndpoints
	}
	return nil
}

func (x *DeployedIndex) GetIndexSyncTime() *timestamppb.Timestamp {
	if x != nil {
		return x.IndexSyncTime
	}
	return nil
}

func (x *DeployedIndex) GetAutomaticResources() *AutomaticResources {
	if x != nil {
		return x.AutomaticResources
	}
	return nil
}

func (x *DeployedIndex) GetDedicatedResources() *DedicatedResources {
	if x != nil {
		return x.DedicatedResources
	}
	return nil
}

func (x *DeployedIndex) GetEnableAccessLogging() bool {
	if x != nil {
		return x.EnableAccessLogging
	}
	return false
}

func (x *DeployedIndex) GetDeployedIndexAuthConfig() *DeployedIndexAuthConfig {
	if x != nil {
		return x.DeployedIndexAuthConfig
	}
	return nil
}

func (x *DeployedIndex) GetReservedIpRanges() []string {
	if x != nil {
		return x.ReservedIpRanges
	}
	return nil
}

func (x *DeployedIndex) GetDeploymentGroup() string {
	if x != nil {
		return x.DeploymentGroup
	}
	return ""
}

func (x *DeployedIndex) GetPscAutomationConfigs() []*PSCAutomationConfig {
	if x != nil {
		return x.PscAutomationConfigs
	}
	return nil
}

// Used to set up the auth on the DeployedIndex's private endpoint.
type DeployedIndexAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the authentication provider that the DeployedIndex uses.
	AuthProvider *DeployedIndexAuthConfig_AuthProvider `protobuf:"bytes,1,opt,name=auth_provider,json=authProvider,proto3" json:"auth_provider,omitempty"`
}

func (x *DeployedIndexAuthConfig) Reset() {
	*x = DeployedIndexAuthConfig{}
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployedIndexAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedIndexAuthConfig) ProtoMessage() {}

func (x *DeployedIndexAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedIndexAuthConfig.ProtoReflect.Descriptor instead.
func (*DeployedIndexAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescGZIP(), []int{2}
}

func (x *DeployedIndexAuthConfig) GetAuthProvider() *DeployedIndexAuthConfig_AuthProvider {
	if x != nil {
		return x.AuthProvider
	}
	return nil
}

// IndexPrivateEndpoints proto is used to provide paths for users to send
// requests via private endpoints (e.g. private service access, private service
// connect).
// To send request via private service access, use match_grpc_address.
// To send request via private service connect, use service_attachment.
type IndexPrivateEndpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ip address used to send match gRPC requests.
	MatchGrpcAddress string `protobuf:"bytes,1,opt,name=match_grpc_address,json=matchGrpcAddress,proto3" json:"match_grpc_address,omitempty"`
	// Output only. The name of the service attachment resource. Populated if
	// private service connect is enabled.
	ServiceAttachment string `protobuf:"bytes,2,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
	// Output only. PscAutomatedEndpoints is populated if private service connect
	// is enabled if PscAutomatedConfig is set.
	PscAutomatedEndpoints []*PscAutomatedEndpoints `protobuf:"bytes,3,rep,name=psc_automated_endpoints,json=pscAutomatedEndpoints,proto3" json:"psc_automated_endpoints,omitempty"`
}

func (x *IndexPrivateEndpoints) Reset() {
	*x = IndexPrivateEndpoints{}
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IndexPrivateEndpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexPrivateEndpoints) ProtoMessage() {}

func (x *IndexPrivateEndpoints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexPrivateEndpoints.ProtoReflect.Descriptor instead.
func (*IndexPrivateEndpoints) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescGZIP(), []int{3}
}

func (x *IndexPrivateEndpoints) GetMatchGrpcAddress() string {
	if x != nil {
		return x.MatchGrpcAddress
	}
	return ""
}

func (x *IndexPrivateEndpoints) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

func (x *IndexPrivateEndpoints) GetPscAutomatedEndpoints() []*PscAutomatedEndpoints {
	if x != nil {
		return x.PscAutomatedEndpoints
	}
	return nil
}

// Configuration for an authentication provider, including support for
// [JSON Web Token
// (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type DeployedIndexAuthConfig_AuthProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of JWT
	// [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences will
	// be accepted.
	Audiences []string `protobuf:"bytes,1,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// A list of allowed JWT issuers. Each entry must be a valid Google
	// service account, in the following format:
	//
	// `service-account-name@project-id.iam.gserviceaccount.com`
	AllowedIssuers []string `protobuf:"bytes,2,rep,name=allowed_issuers,json=allowedIssuers,proto3" json:"allowed_issuers,omitempty"`
}

func (x *DeployedIndexAuthConfig_AuthProvider) Reset() {
	*x = DeployedIndexAuthConfig_AuthProvider{}
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployedIndexAuthConfig_AuthProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployedIndexAuthConfig_AuthProvider) ProtoMessage() {}

func (x *DeployedIndexAuthConfig_AuthProvider) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployedIndexAuthConfig_AuthProvider.ProtoReflect.Descriptor instead.
func (*DeployedIndexAuthConfig_AuthProvider) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescGZIP(), []int{2, 0}
}

func (x *DeployedIndexAuthConfig_AuthProvider) GetAudiences() []string {
	if x != nil {
		return x.Audiences
	}
	return nil
}

func (x *DeployedIndexAuthConfig_AuthProvider) GetAllowedIssuers() []string {
	if x != nil {
		return x.AllowedIssuers
	}
	return nil
}

var File_google_cloud_aiplatform_v1_index_endpoint_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x09, 0x0a, 0x0d, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x10, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x4a, 0x0a, 0x1e, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x1e, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x17, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x15, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x42, 0x0a, 0x1b, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x18, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66,
	0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73,
	0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a,
	0x69, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x7d, 0x22, 0xc1, 0x07, 0x0a,
	0x0d, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x13,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x3d, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x47, 0x0a, 0x0f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x53, 0x79, 0x6e,
	0x63, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x63, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x13, 0x64,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x64,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x37, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x75, 0x0a, 0x1a, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x70,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x6a, 0x0a, 0x16, 0x70, 0x73, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x13,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x53, 0x43, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x70, 0x73, 0x63, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x22, 0xd7, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x0d,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x1a, 0x55, 0x0a, 0x0c, 0x41, 0x75, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x73, 0x22, 0xee, 0x01, 0x0a, 0x15, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x67, 0x72,
	0x70, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x47, 0x72, 0x70, 0x63,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6e, 0x0a, 0x17, 0x70,
	0x73, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x70, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x65, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x42, 0xd0, 0x01, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x12,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescData = file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_aiplatform_v1_index_endpoint_proto_goTypes = []any{
	(*IndexEndpoint)(nil),           // 0: google.cloud.aiplatform.v1.IndexEndpoint
	(*DeployedIndex)(nil),           // 1: google.cloud.aiplatform.v1.DeployedIndex
	(*DeployedIndexAuthConfig)(nil), // 2: google.cloud.aiplatform.v1.DeployedIndexAuthConfig
	(*IndexPrivateEndpoints)(nil),   // 3: google.cloud.aiplatform.v1.IndexPrivateEndpoints
	nil,                             // 4: google.cloud.aiplatform.v1.IndexEndpoint.LabelsEntry
	(*DeployedIndexAuthConfig_AuthProvider)(nil), // 5: google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
	(*timestamppb.Timestamp)(nil),                // 6: google.protobuf.Timestamp
	(*PrivateServiceConnectConfig)(nil),          // 7: google.cloud.aiplatform.v1.PrivateServiceConnectConfig
	(*EncryptionSpec)(nil),                       // 8: google.cloud.aiplatform.v1.EncryptionSpec
	(*AutomaticResources)(nil),                   // 9: google.cloud.aiplatform.v1.AutomaticResources
	(*DedicatedResources)(nil),                   // 10: google.cloud.aiplatform.v1.DedicatedResources
	(*PSCAutomationConfig)(nil),                  // 11: google.cloud.aiplatform.v1.PSCAutomationConfig
	(*PscAutomatedEndpoints)(nil),                // 12: google.cloud.aiplatform.v1.PscAutomatedEndpoints
}
var file_google_cloud_aiplatform_v1_index_endpoint_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1.IndexEndpoint.deployed_indexes:type_name -> google.cloud.aiplatform.v1.DeployedIndex
	4,  // 1: google.cloud.aiplatform.v1.IndexEndpoint.labels:type_name -> google.cloud.aiplatform.v1.IndexEndpoint.LabelsEntry
	6,  // 2: google.cloud.aiplatform.v1.IndexEndpoint.create_time:type_name -> google.protobuf.Timestamp
	6,  // 3: google.cloud.aiplatform.v1.IndexEndpoint.update_time:type_name -> google.protobuf.Timestamp
	7,  // 4: google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config:type_name -> google.cloud.aiplatform.v1.PrivateServiceConnectConfig
	8,  // 5: google.cloud.aiplatform.v1.IndexEndpoint.encryption_spec:type_name -> google.cloud.aiplatform.v1.EncryptionSpec
	6,  // 6: google.cloud.aiplatform.v1.DeployedIndex.create_time:type_name -> google.protobuf.Timestamp
	3,  // 7: google.cloud.aiplatform.v1.DeployedIndex.private_endpoints:type_name -> google.cloud.aiplatform.v1.IndexPrivateEndpoints
	6,  // 8: google.cloud.aiplatform.v1.DeployedIndex.index_sync_time:type_name -> google.protobuf.Timestamp
	9,  // 9: google.cloud.aiplatform.v1.DeployedIndex.automatic_resources:type_name -> google.cloud.aiplatform.v1.AutomaticResources
	10, // 10: google.cloud.aiplatform.v1.DeployedIndex.dedicated_resources:type_name -> google.cloud.aiplatform.v1.DedicatedResources
	2,  // 11: google.cloud.aiplatform.v1.DeployedIndex.deployed_index_auth_config:type_name -> google.cloud.aiplatform.v1.DeployedIndexAuthConfig
	11, // 12: google.cloud.aiplatform.v1.DeployedIndex.psc_automation_configs:type_name -> google.cloud.aiplatform.v1.PSCAutomationConfig
	5,  // 13: google.cloud.aiplatform.v1.DeployedIndexAuthConfig.auth_provider:type_name -> google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
	12, // 14: google.cloud.aiplatform.v1.IndexPrivateEndpoints.psc_automated_endpoints:type_name -> google.cloud.aiplatform.v1.PscAutomatedEndpoints
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_index_endpoint_proto_init() }
func file_google_cloud_aiplatform_v1_index_endpoint_proto_init() {
	if File_google_cloud_aiplatform_v1_index_endpoint_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1_service_networking_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_index_endpoint_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_index_endpoint_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_index_endpoint_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_index_endpoint_proto = out.File
	file_google_cloud_aiplatform_v1_index_endpoint_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_index_endpoint_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_index_endpoint_proto_depIdxs = nil
}
