// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/v1/autokey_admin.proto

package kmspb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AutokeyAdmin_UpdateAutokeyConfig_FullMethodName        = "/google.cloud.kms.v1.AutokeyAdmin/UpdateAutokeyConfig"
	AutokeyAdmin_GetAutokeyConfig_FullMethodName           = "/google.cloud.kms.v1.AutokeyAdmin/GetAutokeyConfig"
	AutokeyAdmin_ShowEffectiveAutokeyConfig_FullMethodName = "/google.cloud.kms.v1.AutokeyAdmin/ShowEffectiveAutokeyConfig"
)

// AutokeyAdminClient is the client API for AutokeyAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutokeyAdminClient interface {
	// Updates the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] for a
	// folder. The caller must have both `cloudkms.autokeyConfigs.update`
	// permission on the parent folder and `cloudkms.cryptoKeys.setIamPolicy`
	// permission on the provided key project. A
	// [KeyHandle][google.cloud.kms.v1.KeyHandle] creation in the folder's
	// descendant projects will use this configuration to determine where to
	// create the resulting [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateAutokeyConfig(ctx context.Context, in *UpdateAutokeyConfigRequest, opts ...grpc.CallOption) (*AutokeyConfig, error)
	// Returns the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] for a
	// folder.
	GetAutokeyConfig(ctx context.Context, in *GetAutokeyConfigRequest, opts ...grpc.CallOption) (*AutokeyConfig, error)
	// Returns the effective Cloud KMS Autokey configuration for a given project.
	ShowEffectiveAutokeyConfig(ctx context.Context, in *ShowEffectiveAutokeyConfigRequest, opts ...grpc.CallOption) (*ShowEffectiveAutokeyConfigResponse, error)
}

type autokeyAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewAutokeyAdminClient(cc grpc.ClientConnInterface) AutokeyAdminClient {
	return &autokeyAdminClient{cc}
}

func (c *autokeyAdminClient) UpdateAutokeyConfig(ctx context.Context, in *UpdateAutokeyConfigRequest, opts ...grpc.CallOption) (*AutokeyConfig, error) {
	out := new(AutokeyConfig)
	err := c.cc.Invoke(ctx, AutokeyAdmin_UpdateAutokeyConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autokeyAdminClient) GetAutokeyConfig(ctx context.Context, in *GetAutokeyConfigRequest, opts ...grpc.CallOption) (*AutokeyConfig, error) {
	out := new(AutokeyConfig)
	err := c.cc.Invoke(ctx, AutokeyAdmin_GetAutokeyConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autokeyAdminClient) ShowEffectiveAutokeyConfig(ctx context.Context, in *ShowEffectiveAutokeyConfigRequest, opts ...grpc.CallOption) (*ShowEffectiveAutokeyConfigResponse, error) {
	out := new(ShowEffectiveAutokeyConfigResponse)
	err := c.cc.Invoke(ctx, AutokeyAdmin_ShowEffectiveAutokeyConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutokeyAdminServer is the server API for AutokeyAdmin service.
// All implementations should embed UnimplementedAutokeyAdminServer
// for forward compatibility
type AutokeyAdminServer interface {
	// Updates the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] for a
	// folder. The caller must have both `cloudkms.autokeyConfigs.update`
	// permission on the parent folder and `cloudkms.cryptoKeys.setIamPolicy`
	// permission on the provided key project. A
	// [KeyHandle][google.cloud.kms.v1.KeyHandle] creation in the folder's
	// descendant projects will use this configuration to determine where to
	// create the resulting [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateAutokeyConfig(context.Context, *UpdateAutokeyConfigRequest) (*AutokeyConfig, error)
	// Returns the [AutokeyConfig][google.cloud.kms.v1.AutokeyConfig] for a
	// folder.
	GetAutokeyConfig(context.Context, *GetAutokeyConfigRequest) (*AutokeyConfig, error)
	// Returns the effective Cloud KMS Autokey configuration for a given project.
	ShowEffectiveAutokeyConfig(context.Context, *ShowEffectiveAutokeyConfigRequest) (*ShowEffectiveAutokeyConfigResponse, error)
}

// UnimplementedAutokeyAdminServer should be embedded to have forward compatible implementations.
type UnimplementedAutokeyAdminServer struct {
}

func (UnimplementedAutokeyAdminServer) UpdateAutokeyConfig(context.Context, *UpdateAutokeyConfigRequest) (*AutokeyConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutokeyConfig not implemented")
}
func (UnimplementedAutokeyAdminServer) GetAutokeyConfig(context.Context, *GetAutokeyConfigRequest) (*AutokeyConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutokeyConfig not implemented")
}
func (UnimplementedAutokeyAdminServer) ShowEffectiveAutokeyConfig(context.Context, *ShowEffectiveAutokeyConfigRequest) (*ShowEffectiveAutokeyConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowEffectiveAutokeyConfig not implemented")
}

// UnsafeAutokeyAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutokeyAdminServer will
// result in compilation errors.
type UnsafeAutokeyAdminServer interface {
	mustEmbedUnimplementedAutokeyAdminServer()
}

func RegisterAutokeyAdminServer(s grpc.ServiceRegistrar, srv AutokeyAdminServer) {
	s.RegisterService(&AutokeyAdmin_ServiceDesc, srv)
}

func _AutokeyAdmin_UpdateAutokeyConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutokeyConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutokeyAdminServer).UpdateAutokeyConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutokeyAdmin_UpdateAutokeyConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutokeyAdminServer).UpdateAutokeyConfig(ctx, req.(*UpdateAutokeyConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutokeyAdmin_GetAutokeyConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutokeyConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutokeyAdminServer).GetAutokeyConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutokeyAdmin_GetAutokeyConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutokeyAdminServer).GetAutokeyConfig(ctx, req.(*GetAutokeyConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutokeyAdmin_ShowEffectiveAutokeyConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowEffectiveAutokeyConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutokeyAdminServer).ShowEffectiveAutokeyConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutokeyAdmin_ShowEffectiveAutokeyConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutokeyAdminServer).ShowEffectiveAutokeyConfig(ctx, req.(*ShowEffectiveAutokeyConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AutokeyAdmin_ServiceDesc is the grpc.ServiceDesc for AutokeyAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AutokeyAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.AutokeyAdmin",
	HandlerType: (*AutokeyAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateAutokeyConfig",
			Handler:    _AutokeyAdmin_UpdateAutokeyConfig_Handler,
		},
		{
			MethodName: "GetAutokeyConfig",
			Handler:    _AutokeyAdmin_GetAutokeyConfig_Handler,
		},
		{
			MethodName: "ShowEffectiveAutokeyConfig",
			Handler:    _AutokeyAdmin_ShowEffectiveAutokeyConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/autokey_admin.proto",
}
