// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/v1/hsm_management.proto

package kmspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HsmManagement_ListSingleTenantHsmInstances_FullMethodName           = "/google.cloud.kms.v1.HsmManagement/ListSingleTenantHsmInstances"
	HsmManagement_GetSingleTenantHsmInstance_FullMethodName             = "/google.cloud.kms.v1.HsmManagement/GetSingleTenantHsmInstance"
	HsmManagement_CreateSingleTenantHsmInstance_FullMethodName          = "/google.cloud.kms.v1.HsmManagement/CreateSingleTenantHsmInstance"
	HsmManagement_CreateSingleTenantHsmInstanceProposal_FullMethodName  = "/google.cloud.kms.v1.HsmManagement/CreateSingleTenantHsmInstanceProposal"
	HsmManagement_ApproveSingleTenantHsmInstanceProposal_FullMethodName = "/google.cloud.kms.v1.HsmManagement/ApproveSingleTenantHsmInstanceProposal"
	HsmManagement_ExecuteSingleTenantHsmInstanceProposal_FullMethodName = "/google.cloud.kms.v1.HsmManagement/ExecuteSingleTenantHsmInstanceProposal"
	HsmManagement_GetSingleTenantHsmInstanceProposal_FullMethodName     = "/google.cloud.kms.v1.HsmManagement/GetSingleTenantHsmInstanceProposal"
	HsmManagement_ListSingleTenantHsmInstanceProposals_FullMethodName   = "/google.cloud.kms.v1.HsmManagement/ListSingleTenantHsmInstanceProposals"
	HsmManagement_DeleteSingleTenantHsmInstanceProposal_FullMethodName  = "/google.cloud.kms.v1.HsmManagement/DeleteSingleTenantHsmInstanceProposal"
)

// HsmManagementClient is the client API for HsmManagement service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HsmManagementClient interface {
	// Lists
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance].
	ListSingleTenantHsmInstances(ctx context.Context, in *ListSingleTenantHsmInstancesRequest, opts ...grpc.CallOption) (*ListSingleTenantHsmInstancesResponse, error)
	// Returns metadata for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	GetSingleTenantHsmInstance(ctx context.Context, in *GetSingleTenantHsmInstanceRequest, opts ...grpc.CallOption) (*SingleTenantHsmInstance, error)
	// Creates a new
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] in a
	// given Project and Location. User must create a RegisterTwoFactorAuthKeys
	// proposal with this single-tenant HSM instance to finish setup of the
	// instance.
	CreateSingleTenantHsmInstance(ctx context.Context, in *CreateSingleTenantHsmInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	CreateSingleTenantHsmInstanceProposal(ctx context.Context, in *CreateSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Approves a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
	// proposal must be in the
	// [PENDING][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State.PENDING]
	// state.
	ApproveSingleTenantHsmInstanceProposal(ctx context.Context, in *ApproveSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*ApproveSingleTenantHsmInstanceProposalResponse, error)
	// Executes a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
	// proposal must be in the
	// [APPROVED][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State.APPROVED]
	// state.
	ExecuteSingleTenantHsmInstanceProposal(ctx context.Context, in *ExecuteSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns metadata for a given
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	GetSingleTenantHsmInstanceProposal(ctx context.Context, in *GetSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*SingleTenantHsmInstanceProposal, error)
	// Lists
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	ListSingleTenantHsmInstanceProposals(ctx context.Context, in *ListSingleTenantHsmInstanceProposalsRequest, opts ...grpc.CallOption) (*ListSingleTenantHsmInstanceProposalsResponse, error)
	// Deletes a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	DeleteSingleTenantHsmInstanceProposal(ctx context.Context, in *DeleteSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type hsmManagementClient struct {
	cc grpc.ClientConnInterface
}

func NewHsmManagementClient(cc grpc.ClientConnInterface) HsmManagementClient {
	return &hsmManagementClient{cc}
}

func (c *hsmManagementClient) ListSingleTenantHsmInstances(ctx context.Context, in *ListSingleTenantHsmInstancesRequest, opts ...grpc.CallOption) (*ListSingleTenantHsmInstancesResponse, error) {
	out := new(ListSingleTenantHsmInstancesResponse)
	err := c.cc.Invoke(ctx, HsmManagement_ListSingleTenantHsmInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) GetSingleTenantHsmInstance(ctx context.Context, in *GetSingleTenantHsmInstanceRequest, opts ...grpc.CallOption) (*SingleTenantHsmInstance, error) {
	out := new(SingleTenantHsmInstance)
	err := c.cc.Invoke(ctx, HsmManagement_GetSingleTenantHsmInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) CreateSingleTenantHsmInstance(ctx context.Context, in *CreateSingleTenantHsmInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HsmManagement_CreateSingleTenantHsmInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) CreateSingleTenantHsmInstanceProposal(ctx context.Context, in *CreateSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HsmManagement_CreateSingleTenantHsmInstanceProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) ApproveSingleTenantHsmInstanceProposal(ctx context.Context, in *ApproveSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*ApproveSingleTenantHsmInstanceProposalResponse, error) {
	out := new(ApproveSingleTenantHsmInstanceProposalResponse)
	err := c.cc.Invoke(ctx, HsmManagement_ApproveSingleTenantHsmInstanceProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) ExecuteSingleTenantHsmInstanceProposal(ctx context.Context, in *ExecuteSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HsmManagement_ExecuteSingleTenantHsmInstanceProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) GetSingleTenantHsmInstanceProposal(ctx context.Context, in *GetSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*SingleTenantHsmInstanceProposal, error) {
	out := new(SingleTenantHsmInstanceProposal)
	err := c.cc.Invoke(ctx, HsmManagement_GetSingleTenantHsmInstanceProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) ListSingleTenantHsmInstanceProposals(ctx context.Context, in *ListSingleTenantHsmInstanceProposalsRequest, opts ...grpc.CallOption) (*ListSingleTenantHsmInstanceProposalsResponse, error) {
	out := new(ListSingleTenantHsmInstanceProposalsResponse)
	err := c.cc.Invoke(ctx, HsmManagement_ListSingleTenantHsmInstanceProposals_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hsmManagementClient) DeleteSingleTenantHsmInstanceProposal(ctx context.Context, in *DeleteSingleTenantHsmInstanceProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, HsmManagement_DeleteSingleTenantHsmInstanceProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HsmManagementServer is the server API for HsmManagement service.
// All implementations should embed UnimplementedHsmManagementServer
// for forward compatibility
type HsmManagementServer interface {
	// Lists
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance].
	ListSingleTenantHsmInstances(context.Context, *ListSingleTenantHsmInstancesRequest) (*ListSingleTenantHsmInstancesResponse, error)
	// Returns metadata for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	GetSingleTenantHsmInstance(context.Context, *GetSingleTenantHsmInstanceRequest) (*SingleTenantHsmInstance, error)
	// Creates a new
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] in a
	// given Project and Location. User must create a RegisterTwoFactorAuthKeys
	// proposal with this single-tenant HSM instance to finish setup of the
	// instance.
	CreateSingleTenantHsmInstance(context.Context, *CreateSingleTenantHsmInstanceRequest) (*longrunningpb.Operation, error)
	// Creates a new
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	CreateSingleTenantHsmInstanceProposal(context.Context, *CreateSingleTenantHsmInstanceProposalRequest) (*longrunningpb.Operation, error)
	// Approves a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
	// proposal must be in the
	// [PENDING][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State.PENDING]
	// state.
	ApproveSingleTenantHsmInstanceProposal(context.Context, *ApproveSingleTenantHsmInstanceProposalRequest) (*ApproveSingleTenantHsmInstanceProposalResponse, error)
	// Executes a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// for a given
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
	// proposal must be in the
	// [APPROVED][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State.APPROVED]
	// state.
	ExecuteSingleTenantHsmInstanceProposal(context.Context, *ExecuteSingleTenantHsmInstanceProposalRequest) (*longrunningpb.Operation, error)
	// Returns metadata for a given
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	GetSingleTenantHsmInstanceProposal(context.Context, *GetSingleTenantHsmInstanceProposalRequest) (*SingleTenantHsmInstanceProposal, error)
	// Lists
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	ListSingleTenantHsmInstanceProposals(context.Context, *ListSingleTenantHsmInstanceProposalsRequest) (*ListSingleTenantHsmInstanceProposalsResponse, error)
	// Deletes a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	DeleteSingleTenantHsmInstanceProposal(context.Context, *DeleteSingleTenantHsmInstanceProposalRequest) (*emptypb.Empty, error)
}

// UnimplementedHsmManagementServer should be embedded to have forward compatible implementations.
type UnimplementedHsmManagementServer struct {
}

func (UnimplementedHsmManagementServer) ListSingleTenantHsmInstances(context.Context, *ListSingleTenantHsmInstancesRequest) (*ListSingleTenantHsmInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSingleTenantHsmInstances not implemented")
}
func (UnimplementedHsmManagementServer) GetSingleTenantHsmInstance(context.Context, *GetSingleTenantHsmInstanceRequest) (*SingleTenantHsmInstance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSingleTenantHsmInstance not implemented")
}
func (UnimplementedHsmManagementServer) CreateSingleTenantHsmInstance(context.Context, *CreateSingleTenantHsmInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSingleTenantHsmInstance not implemented")
}
func (UnimplementedHsmManagementServer) CreateSingleTenantHsmInstanceProposal(context.Context, *CreateSingleTenantHsmInstanceProposalRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSingleTenantHsmInstanceProposal not implemented")
}
func (UnimplementedHsmManagementServer) ApproveSingleTenantHsmInstanceProposal(context.Context, *ApproveSingleTenantHsmInstanceProposalRequest) (*ApproveSingleTenantHsmInstanceProposalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveSingleTenantHsmInstanceProposal not implemented")
}
func (UnimplementedHsmManagementServer) ExecuteSingleTenantHsmInstanceProposal(context.Context, *ExecuteSingleTenantHsmInstanceProposalRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteSingleTenantHsmInstanceProposal not implemented")
}
func (UnimplementedHsmManagementServer) GetSingleTenantHsmInstanceProposal(context.Context, *GetSingleTenantHsmInstanceProposalRequest) (*SingleTenantHsmInstanceProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSingleTenantHsmInstanceProposal not implemented")
}
func (UnimplementedHsmManagementServer) ListSingleTenantHsmInstanceProposals(context.Context, *ListSingleTenantHsmInstanceProposalsRequest) (*ListSingleTenantHsmInstanceProposalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSingleTenantHsmInstanceProposals not implemented")
}
func (UnimplementedHsmManagementServer) DeleteSingleTenantHsmInstanceProposal(context.Context, *DeleteSingleTenantHsmInstanceProposalRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSingleTenantHsmInstanceProposal not implemented")
}

// UnsafeHsmManagementServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HsmManagementServer will
// result in compilation errors.
type UnsafeHsmManagementServer interface {
	mustEmbedUnimplementedHsmManagementServer()
}

func RegisterHsmManagementServer(s grpc.ServiceRegistrar, srv HsmManagementServer) {
	s.RegisterService(&HsmManagement_ServiceDesc, srv)
}

func _HsmManagement_ListSingleTenantHsmInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSingleTenantHsmInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).ListSingleTenantHsmInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_ListSingleTenantHsmInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).ListSingleTenantHsmInstances(ctx, req.(*ListSingleTenantHsmInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_GetSingleTenantHsmInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSingleTenantHsmInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).GetSingleTenantHsmInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_GetSingleTenantHsmInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).GetSingleTenantHsmInstance(ctx, req.(*GetSingleTenantHsmInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_CreateSingleTenantHsmInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSingleTenantHsmInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).CreateSingleTenantHsmInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_CreateSingleTenantHsmInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).CreateSingleTenantHsmInstance(ctx, req.(*CreateSingleTenantHsmInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_CreateSingleTenantHsmInstanceProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSingleTenantHsmInstanceProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).CreateSingleTenantHsmInstanceProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_CreateSingleTenantHsmInstanceProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).CreateSingleTenantHsmInstanceProposal(ctx, req.(*CreateSingleTenantHsmInstanceProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_ApproveSingleTenantHsmInstanceProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveSingleTenantHsmInstanceProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).ApproveSingleTenantHsmInstanceProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_ApproveSingleTenantHsmInstanceProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).ApproveSingleTenantHsmInstanceProposal(ctx, req.(*ApproveSingleTenantHsmInstanceProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_ExecuteSingleTenantHsmInstanceProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteSingleTenantHsmInstanceProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).ExecuteSingleTenantHsmInstanceProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_ExecuteSingleTenantHsmInstanceProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).ExecuteSingleTenantHsmInstanceProposal(ctx, req.(*ExecuteSingleTenantHsmInstanceProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_GetSingleTenantHsmInstanceProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSingleTenantHsmInstanceProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).GetSingleTenantHsmInstanceProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_GetSingleTenantHsmInstanceProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).GetSingleTenantHsmInstanceProposal(ctx, req.(*GetSingleTenantHsmInstanceProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_ListSingleTenantHsmInstanceProposals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSingleTenantHsmInstanceProposalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).ListSingleTenantHsmInstanceProposals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_ListSingleTenantHsmInstanceProposals_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).ListSingleTenantHsmInstanceProposals(ctx, req.(*ListSingleTenantHsmInstanceProposalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HsmManagement_DeleteSingleTenantHsmInstanceProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSingleTenantHsmInstanceProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HsmManagementServer).DeleteSingleTenantHsmInstanceProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HsmManagement_DeleteSingleTenantHsmInstanceProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HsmManagementServer).DeleteSingleTenantHsmInstanceProposal(ctx, req.(*DeleteSingleTenantHsmInstanceProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HsmManagement_ServiceDesc is the grpc.ServiceDesc for HsmManagement service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HsmManagement_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.HsmManagement",
	HandlerType: (*HsmManagementServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSingleTenantHsmInstances",
			Handler:    _HsmManagement_ListSingleTenantHsmInstances_Handler,
		},
		{
			MethodName: "GetSingleTenantHsmInstance",
			Handler:    _HsmManagement_GetSingleTenantHsmInstance_Handler,
		},
		{
			MethodName: "CreateSingleTenantHsmInstance",
			Handler:    _HsmManagement_CreateSingleTenantHsmInstance_Handler,
		},
		{
			MethodName: "CreateSingleTenantHsmInstanceProposal",
			Handler:    _HsmManagement_CreateSingleTenantHsmInstanceProposal_Handler,
		},
		{
			MethodName: "ApproveSingleTenantHsmInstanceProposal",
			Handler:    _HsmManagement_ApproveSingleTenantHsmInstanceProposal_Handler,
		},
		{
			MethodName: "ExecuteSingleTenantHsmInstanceProposal",
			Handler:    _HsmManagement_ExecuteSingleTenantHsmInstanceProposal_Handler,
		},
		{
			MethodName: "GetSingleTenantHsmInstanceProposal",
			Handler:    _HsmManagement_GetSingleTenantHsmInstanceProposal_Handler,
		},
		{
			MethodName: "ListSingleTenantHsmInstanceProposals",
			Handler:    _HsmManagement_ListSingleTenantHsmInstanceProposals_Handler,
		},
		{
			MethodName: "DeleteSingleTenantHsmInstanceProposal",
			Handler:    _HsmManagement_DeleteSingleTenantHsmInstanceProposal_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/hsm_management.proto",
}
