// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/speech/v2/locations_metadata.proto

package speechpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes the different types of constraints that can be applied on a
// region.
type AccessMetadata_ConstraintType int32

const (
	// Unspecified constraint applied.
	AccessMetadata_CONSTRAINT_TYPE_UNSPECIFIED AccessMetadata_ConstraintType = 0
	// The project's org policy disallows the given region.
	AccessMetadata_RESOURCE_LOCATIONS_ORG_POLICY_CREATE_CONSTRAINT AccessMetadata_ConstraintType = 1
)

// Enum value maps for AccessMetadata_ConstraintType.
var (
	AccessMetadata_ConstraintType_name = map[int32]string{
		0: "CONSTRAINT_TYPE_UNSPECIFIED",
		1: "RESOURCE_LOCATIONS_ORG_POLICY_CREATE_CONSTRAINT",
	}
	AccessMetadata_ConstraintType_value = map[string]int32{
		"CONSTRAINT_TYPE_UNSPECIFIED":                     0,
		"RESOURCE_LOCATIONS_ORG_POLICY_CREATE_CONSTRAINT": 1,
	}
)

func (x AccessMetadata_ConstraintType) Enum() *AccessMetadata_ConstraintType {
	p := new(AccessMetadata_ConstraintType)
	*p = x
	return p
}

func (x AccessMetadata_ConstraintType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessMetadata_ConstraintType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_locations_metadata_proto_enumTypes[0].Descriptor()
}

func (AccessMetadata_ConstraintType) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_locations_metadata_proto_enumTypes[0]
}

func (x AccessMetadata_ConstraintType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessMetadata_ConstraintType.Descriptor instead.
func (AccessMetadata_ConstraintType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{4, 0}
}

// Represents a singular feature of a model. If the feature is `recognizer`,
// the release_state of the feature represents the release_state of the model
type ModelFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the feature (Note: the feature can be `recognizer`)
	Feature string `protobuf:"bytes,1,opt,name=feature,proto3" json:"feature,omitempty"`
	// The release state of the feature
	ReleaseState string `protobuf:"bytes,2,opt,name=release_state,json=releaseState,proto3" json:"release_state,omitempty"`
}

func (x *ModelFeature) Reset() {
	*x = ModelFeature{}
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelFeature) ProtoMessage() {}

func (x *ModelFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelFeature.ProtoReflect.Descriptor instead.
func (*ModelFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *ModelFeature) GetFeature() string {
	if x != nil {
		return x.Feature
	}
	return ""
}

func (x *ModelFeature) GetReleaseState() string {
	if x != nil {
		return x.ReleaseState
	}
	return ""
}

// Represents the collection of features belonging to a model
type ModelFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Repeated field that contains all features of the model
	ModelFeature []*ModelFeature `protobuf:"bytes,1,rep,name=model_feature,json=modelFeature,proto3" json:"model_feature,omitempty"`
}

func (x *ModelFeatures) Reset() {
	*x = ModelFeatures{}
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelFeatures) ProtoMessage() {}

func (x *ModelFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelFeatures.ProtoReflect.Descriptor instead.
func (*ModelFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *ModelFeatures) GetModelFeature() []*ModelFeature {
	if x != nil {
		return x.ModelFeature
	}
	return nil
}

// The metadata about the models in a given region for a specific locale.
// Currently this is just the features of the model
type ModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of the model name -> features of that model
	ModelFeatures map[string]*ModelFeatures `protobuf:"bytes,1,rep,name=model_features,json=modelFeatures,proto3" json:"model_features,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ModelMetadata) Reset() {
	*x = ModelMetadata{}
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMetadata) ProtoMessage() {}

func (x *ModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMetadata.ProtoReflect.Descriptor instead.
func (*ModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *ModelMetadata) GetModelFeatures() map[string]*ModelFeatures {
	if x != nil {
		return x.ModelFeatures
	}
	return nil
}

// The metadata about locales available in a given region. Currently this is
// just the models that are available for each locale
type LanguageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of locale (language code) -> models
	Models map[string]*ModelMetadata `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LanguageMetadata) Reset() {
	*x = LanguageMetadata{}
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LanguageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LanguageMetadata) ProtoMessage() {}

func (x *LanguageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LanguageMetadata.ProtoReflect.Descriptor instead.
func (*LanguageMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *LanguageMetadata) GetModels() map[string]*ModelMetadata {
	if x != nil {
		return x.Models
	}
	return nil
}

// The access metadata for a particular region. This can be applied if the org
// policy for the given project disallows a particular region.
type AccessMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the different types of constraints that are applied.
	ConstraintType AccessMetadata_ConstraintType `protobuf:"varint,1,opt,name=constraint_type,json=constraintType,proto3,enum=google.cloud.speech.v2.AccessMetadata_ConstraintType" json:"constraint_type,omitempty"`
}

func (x *AccessMetadata) Reset() {
	*x = AccessMetadata{}
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessMetadata) ProtoMessage() {}

func (x *AccessMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessMetadata.ProtoReflect.Descriptor instead.
func (*AccessMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *AccessMetadata) GetConstraintType() AccessMetadata_ConstraintType {
	if x != nil {
		return x.ConstraintType
	}
	return AccessMetadata_CONSTRAINT_TYPE_UNSPECIFIED
}

// Main metadata for the Locations API for STT V2. Currently this is just the
// metadata about locales, models, and features
type LocationsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about available locales, models, and features represented in
	// the hierarchical structure of locales -> models -> features
	Languages *LanguageMetadata `protobuf:"bytes,1,opt,name=languages,proto3" json:"languages,omitempty"`
	// Information about access metadata for the region and given project.
	AccessMetadata *AccessMetadata `protobuf:"bytes,2,opt,name=access_metadata,json=accessMetadata,proto3" json:"access_metadata,omitempty"`
}

func (x *LocationsMetadata) Reset() {
	*x = LocationsMetadata{}
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationsMetadata) ProtoMessage() {}

func (x *LocationsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_locations_metadata_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationsMetadata.ProtoReflect.Descriptor instead.
func (*LocationsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP(), []int{5}
}

func (x *LocationsMetadata) GetLanguages() *LanguageMetadata {
	if x != nil {
		return x.Languages
	}
	return nil
}

func (x *LocationsMetadata) GetAccessMetadata() *AccessMetadata {
	if x != nil {
		return x.AccessMetadata
	}
	return nil
}

var File_google_cloud_speech_v2_locations_metadata_proto protoreflect.FileDescriptor

var file_google_cloud_speech_v2_locations_metadata_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x22, 0x4d, 0x0a, 0x0c, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x5a, 0x0a, 0x0d, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x0d, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x0d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x1a, 0x67, 0x0a, 0x12, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x3b, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xc2, 0x01, 0x0a, 0x10, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x1a, 0x60, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd8, 0x01, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5e, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x66, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f,
	0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x33, 0x0a, 0x2f, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x53, 0x5f, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x10, 0x01,
	0x22, 0xac, 0x01, 0x0a, 0x11, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x09, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4f,
	0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42,
	0x6a, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x42, 0x16, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x70, 0x62, 0x3b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_speech_v2_locations_metadata_proto_rawDescOnce sync.Once
	file_google_cloud_speech_v2_locations_metadata_proto_rawDescData = file_google_cloud_speech_v2_locations_metadata_proto_rawDesc
)

func file_google_cloud_speech_v2_locations_metadata_proto_rawDescGZIP() []byte {
	file_google_cloud_speech_v2_locations_metadata_proto_rawDescOnce.Do(func() {
		file_google_cloud_speech_v2_locations_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_speech_v2_locations_metadata_proto_rawDescData)
	})
	return file_google_cloud_speech_v2_locations_metadata_proto_rawDescData
}

var file_google_cloud_speech_v2_locations_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_speech_v2_locations_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_speech_v2_locations_metadata_proto_goTypes = []any{
	(AccessMetadata_ConstraintType)(0), // 0: google.cloud.speech.v2.AccessMetadata.ConstraintType
	(*ModelFeature)(nil),               // 1: google.cloud.speech.v2.ModelFeature
	(*ModelFeatures)(nil),              // 2: google.cloud.speech.v2.ModelFeatures
	(*ModelMetadata)(nil),              // 3: google.cloud.speech.v2.ModelMetadata
	(*LanguageMetadata)(nil),           // 4: google.cloud.speech.v2.LanguageMetadata
	(*AccessMetadata)(nil),             // 5: google.cloud.speech.v2.AccessMetadata
	(*LocationsMetadata)(nil),          // 6: google.cloud.speech.v2.LocationsMetadata
	nil,                                // 7: google.cloud.speech.v2.ModelMetadata.ModelFeaturesEntry
	nil,                                // 8: google.cloud.speech.v2.LanguageMetadata.ModelsEntry
}
var file_google_cloud_speech_v2_locations_metadata_proto_depIdxs = []int32{
	1, // 0: google.cloud.speech.v2.ModelFeatures.model_feature:type_name -> google.cloud.speech.v2.ModelFeature
	7, // 1: google.cloud.speech.v2.ModelMetadata.model_features:type_name -> google.cloud.speech.v2.ModelMetadata.ModelFeaturesEntry
	8, // 2: google.cloud.speech.v2.LanguageMetadata.models:type_name -> google.cloud.speech.v2.LanguageMetadata.ModelsEntry
	0, // 3: google.cloud.speech.v2.AccessMetadata.constraint_type:type_name -> google.cloud.speech.v2.AccessMetadata.ConstraintType
	4, // 4: google.cloud.speech.v2.LocationsMetadata.languages:type_name -> google.cloud.speech.v2.LanguageMetadata
	5, // 5: google.cloud.speech.v2.LocationsMetadata.access_metadata:type_name -> google.cloud.speech.v2.AccessMetadata
	2, // 6: google.cloud.speech.v2.ModelMetadata.ModelFeaturesEntry.value:type_name -> google.cloud.speech.v2.ModelFeatures
	3, // 7: google.cloud.speech.v2.LanguageMetadata.ModelsEntry.value:type_name -> google.cloud.speech.v2.ModelMetadata
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_speech_v2_locations_metadata_proto_init() }
func file_google_cloud_speech_v2_locations_metadata_proto_init() {
	if File_google_cloud_speech_v2_locations_metadata_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_speech_v2_locations_metadata_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_speech_v2_locations_metadata_proto_goTypes,
		DependencyIndexes: file_google_cloud_speech_v2_locations_metadata_proto_depIdxs,
		EnumInfos:         file_google_cloud_speech_v2_locations_metadata_proto_enumTypes,
		MessageInfos:      file_google_cloud_speech_v2_locations_metadata_proto_msgTypes,
	}.Build()
	File_google_cloud_speech_v2_locations_metadata_proto = out.File
	file_google_cloud_speech_v2_locations_metadata_proto_rawDesc = nil
	file_google_cloud_speech_v2_locations_metadata_proto_goTypes = nil
	file_google_cloud_speech_v2_locations_metadata_proto_depIdxs = nil
}
