// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

package accesscontextmanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AccessContextManager_ListAccessPolicies_FullMethodName         = "/google.identity.accesscontextmanager.v1.AccessContextManager/ListAccessPolicies"
	AccessContextManager_GetAccessPolicy_FullMethodName            = "/google.identity.accesscontextmanager.v1.AccessContextManager/GetAccessPolicy"
	AccessContextManager_CreateAccessPolicy_FullMethodName         = "/google.identity.accesscontextmanager.v1.AccessContextManager/CreateAccessPolicy"
	AccessContextManager_UpdateAccessPolicy_FullMethodName         = "/google.identity.accesscontextmanager.v1.AccessContextManager/UpdateAccessPolicy"
	AccessContextManager_DeleteAccessPolicy_FullMethodName         = "/google.identity.accesscontextmanager.v1.AccessContextManager/DeleteAccessPolicy"
	AccessContextManager_ListAccessLevels_FullMethodName           = "/google.identity.accesscontextmanager.v1.AccessContextManager/ListAccessLevels"
	AccessContextManager_GetAccessLevel_FullMethodName             = "/google.identity.accesscontextmanager.v1.AccessContextManager/GetAccessLevel"
	AccessContextManager_CreateAccessLevel_FullMethodName          = "/google.identity.accesscontextmanager.v1.AccessContextManager/CreateAccessLevel"
	AccessContextManager_UpdateAccessLevel_FullMethodName          = "/google.identity.accesscontextmanager.v1.AccessContextManager/UpdateAccessLevel"
	AccessContextManager_DeleteAccessLevel_FullMethodName          = "/google.identity.accesscontextmanager.v1.AccessContextManager/DeleteAccessLevel"
	AccessContextManager_ReplaceAccessLevels_FullMethodName        = "/google.identity.accesscontextmanager.v1.AccessContextManager/ReplaceAccessLevels"
	AccessContextManager_ListServicePerimeters_FullMethodName      = "/google.identity.accesscontextmanager.v1.AccessContextManager/ListServicePerimeters"
	AccessContextManager_GetServicePerimeter_FullMethodName        = "/google.identity.accesscontextmanager.v1.AccessContextManager/GetServicePerimeter"
	AccessContextManager_CreateServicePerimeter_FullMethodName     = "/google.identity.accesscontextmanager.v1.AccessContextManager/CreateServicePerimeter"
	AccessContextManager_UpdateServicePerimeter_FullMethodName     = "/google.identity.accesscontextmanager.v1.AccessContextManager/UpdateServicePerimeter"
	AccessContextManager_DeleteServicePerimeter_FullMethodName     = "/google.identity.accesscontextmanager.v1.AccessContextManager/DeleteServicePerimeter"
	AccessContextManager_ReplaceServicePerimeters_FullMethodName   = "/google.identity.accesscontextmanager.v1.AccessContextManager/ReplaceServicePerimeters"
	AccessContextManager_CommitServicePerimeters_FullMethodName    = "/google.identity.accesscontextmanager.v1.AccessContextManager/CommitServicePerimeters"
	AccessContextManager_ListGcpUserAccessBindings_FullMethodName  = "/google.identity.accesscontextmanager.v1.AccessContextManager/ListGcpUserAccessBindings"
	AccessContextManager_GetGcpUserAccessBinding_FullMethodName    = "/google.identity.accesscontextmanager.v1.AccessContextManager/GetGcpUserAccessBinding"
	AccessContextManager_CreateGcpUserAccessBinding_FullMethodName = "/google.identity.accesscontextmanager.v1.AccessContextManager/CreateGcpUserAccessBinding"
	AccessContextManager_UpdateGcpUserAccessBinding_FullMethodName = "/google.identity.accesscontextmanager.v1.AccessContextManager/UpdateGcpUserAccessBinding"
	AccessContextManager_DeleteGcpUserAccessBinding_FullMethodName = "/google.identity.accesscontextmanager.v1.AccessContextManager/DeleteGcpUserAccessBinding"
	AccessContextManager_SetIamPolicy_FullMethodName               = "/google.identity.accesscontextmanager.v1.AccessContextManager/SetIamPolicy"
	AccessContextManager_GetIamPolicy_FullMethodName               = "/google.identity.accesscontextmanager.v1.AccessContextManager/GetIamPolicy"
	AccessContextManager_TestIamPermissions_FullMethodName         = "/google.identity.accesscontextmanager.v1.AccessContextManager/TestIamPermissions"
)

// AccessContextManagerClient is the client API for AccessContextManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AccessContextManagerClient interface {
	// Lists all [access policies]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] in an
	// organization.
	ListAccessPolicies(ctx context.Context, in *ListAccessPoliciesRequest, opts ...grpc.CallOption) (*ListAccessPoliciesResponse, error)
	// Returns an [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
	GetAccessPolicy(ctx context.Context, in *GetAccessPolicyRequest, opts ...grpc.CallOption) (*AccessPolicy, error)
	// Creates an access policy. This method fails if the organization already has
	// an access policy. The long-running operation has a successful status
	// after the access policy propagates to long-lasting storage.
	// Syntactic and basic semantic errors are returned in `metadata` as a
	// BadRequest proto.
	CreateAccessPolicy(ctx context.Context, in *AccessPolicy, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
	// long-running operation from this RPC has a successful status after the
	// changes to the [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
	// to long-lasting storage.
	UpdateAccessPolicy(ctx context.Context, in *UpdateAccessPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
	// resource name. The long-running operation has a successful status after the
	// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
	// is removed from long-lasting storage.
	DeleteAccessPolicy(ctx context.Context, in *DeleteAccessPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
	// policy.
	ListAccessLevels(ctx context.Context, in *ListAccessLevelsRequest, opts ...grpc.CallOption) (*ListAccessLevelsResponse, error)
	// Gets an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
	// name.
	GetAccessLevel(ctx context.Context, in *GetAccessLevelRequest, opts ...grpc.CallOption) (*AccessLevel, error)
	// Creates an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
	// operation from this RPC has a successful status after the [access
	// level] [google.identity.accesscontextmanager.v1.AccessLevel]
	// propagates to long-lasting storage. If [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] contain
	// errors, an error response is returned for the first error encountered.
	CreateAccessLevel(ctx context.Context, in *CreateAccessLevelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
	// operation from this RPC has a successful status after the changes to
	// the [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] propagate
	// to long-lasting storage. If [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] contain
	// errors, an error response is returned for the first error encountered.
	UpdateAccessLevel(ctx context.Context, in *UpdateAccessLevelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
	// name. The long-running operation from this RPC has a successful status
	// after the [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
	// from long-lasting storage.
	DeleteAccessLevel(ctx context.Context, in *DeleteAccessLevelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Replaces all existing [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
	// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
	// the [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
	// is done atomically. The long-running operation from this RPC has a
	// successful status after all replacements propagate to long-lasting
	// storage. If the replacement contains errors, an error response is returned
	// for the first error encountered.  Upon error, the replacement is cancelled,
	// and existing [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] are not
	// affected. The Operation.response field contains
	// ReplaceAccessLevelsResponse. Removing [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
	// [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
	// error.
	ReplaceAccessLevels(ctx context.Context, in *ReplaceAccessLevelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
	// access policy.
	ListServicePerimeters(ctx context.Context, in *ListServicePerimetersRequest, opts ...grpc.CallOption) (*ListServicePerimetersResponse, error)
	// Gets a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
	// resource name.
	GetServicePerimeter(ctx context.Context, in *GetServicePerimeterRequest, opts ...grpc.CallOption) (*ServicePerimeter, error)
	// Creates a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
	// long-running operation from this RPC has a successful status after the
	// [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]
	// propagates to long-lasting storage. If a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
	// errors, an error response is returned for the first error encountered.
	CreateServicePerimeter(ctx context.Context, in *CreateServicePerimeterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
	// long-running operation from this RPC has a successful status after the
	// [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]
	// propagates to long-lasting storage. If a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
	// errors, an error response is returned for the first error encountered.
	UpdateServicePerimeter(ctx context.Context, in *UpdateServicePerimeterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
	// resource name. The long-running operation from this RPC has a successful
	// status after the [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
	// long-lasting storage.
	DeleteServicePerimeter(ctx context.Context, in *DeleteServicePerimeterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Replace all existing [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
	// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
	// [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
	// is done atomically. The long-running operation from this RPC has a
	// successful status after all replacements propagate to long-lasting storage.
	// Replacements containing errors result in an error response for the first
	// error encountered. Upon an error, replacement are cancelled and existing
	// [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
	// affected. The Operation.response field contains
	// ReplaceServicePerimetersResponse.
	ReplaceServicePerimeters(ctx context.Context, in *ReplaceServicePerimetersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Commits the dry-run specification for all the [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
	// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	// A commit operation on a service perimeter involves copying its `spec` field
	// to the `status` field of the service perimeter. Only [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] with
	// `use_explicit_dry_run_spec` field set to true are affected by a commit
	// operation. The long-running operation from this RPC has a successful
	// status after the dry-run specifications for all the [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
	// committed. If a commit fails, it causes the long-running operation to
	// return an error response and the entire commit operation is cancelled.
	// When successful, the Operation.response field contains
	// CommitServicePerimetersResponse. The `dry_run` and the `spec` fields are
	// cleared after a successful commit operation.
	CommitServicePerimeters(ctx context.Context, in *CommitServicePerimetersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all [GcpUserAccessBindings]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
	// Google Cloud organization.
	ListGcpUserAccessBindings(ctx context.Context, in *ListGcpUserAccessBindingsRequest, opts ...grpc.CallOption) (*ListGcpUserAccessBindingsResponse, error)
	// Gets the [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
	// the given name.
	GetGcpUserAccessBinding(ctx context.Context, in *GetGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*GcpUserAccessBinding, error)
	// Creates a [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
	// client specifies a [name]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
	// the server ignores it. Fails if a resource already exists with the same
	// [group_key]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
	// Completion of this long-running operation does not necessarily signify that
	// the new binding is deployed onto all affected users, which may take more
	// time.
	CreateGcpUserAccessBinding(ctx context.Context, in *CreateGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
	// Completion of this long-running operation does not necessarily signify that
	// the changed binding is deployed onto all affected users, which may take
	// more time.
	UpdateGcpUserAccessBinding(ctx context.Context, in *UpdateGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
	// Completion of this long-running operation does not necessarily signify that
	// the binding deletion is deployed onto all affected users, which may take
	// more time.
	DeleteGcpUserAccessBinding(ctx context.Context, in *DeleteGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Sets the IAM policy for the specified Access Context Manager
	// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	// This method replaces the existing IAM policy on the access policy. The IAM
	// policy controls the set of users who can perform specific operations on the
	// Access Context Manager [access
	// policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the IAM policy for the specified Access Context Manager
	// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns the IAM permissions that the caller has on the specified Access
	// Context Manager resource. The resource can be an
	// [AccessPolicy][google.identity.accesscontextmanager.v1.AccessPolicy],
	// [AccessLevel][google.identity.accesscontextmanager.v1.AccessLevel], or
	// [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
	// ]. This method does not support other resources.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type accessContextManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewAccessContextManagerClient(cc grpc.ClientConnInterface) AccessContextManagerClient {
	return &accessContextManagerClient{cc}
}

func (c *accessContextManagerClient) ListAccessPolicies(ctx context.Context, in *ListAccessPoliciesRequest, opts ...grpc.CallOption) (*ListAccessPoliciesResponse, error) {
	out := new(ListAccessPoliciesResponse)
	err := c.cc.Invoke(ctx, AccessContextManager_ListAccessPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) GetAccessPolicy(ctx context.Context, in *GetAccessPolicyRequest, opts ...grpc.CallOption) (*AccessPolicy, error) {
	out := new(AccessPolicy)
	err := c.cc.Invoke(ctx, AccessContextManager_GetAccessPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) CreateAccessPolicy(ctx context.Context, in *AccessPolicy, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_CreateAccessPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) UpdateAccessPolicy(ctx context.Context, in *UpdateAccessPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_UpdateAccessPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) DeleteAccessPolicy(ctx context.Context, in *DeleteAccessPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_DeleteAccessPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) ListAccessLevels(ctx context.Context, in *ListAccessLevelsRequest, opts ...grpc.CallOption) (*ListAccessLevelsResponse, error) {
	out := new(ListAccessLevelsResponse)
	err := c.cc.Invoke(ctx, AccessContextManager_ListAccessLevels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) GetAccessLevel(ctx context.Context, in *GetAccessLevelRequest, opts ...grpc.CallOption) (*AccessLevel, error) {
	out := new(AccessLevel)
	err := c.cc.Invoke(ctx, AccessContextManager_GetAccessLevel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) CreateAccessLevel(ctx context.Context, in *CreateAccessLevelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_CreateAccessLevel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) UpdateAccessLevel(ctx context.Context, in *UpdateAccessLevelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_UpdateAccessLevel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) DeleteAccessLevel(ctx context.Context, in *DeleteAccessLevelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_DeleteAccessLevel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) ReplaceAccessLevels(ctx context.Context, in *ReplaceAccessLevelsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_ReplaceAccessLevels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) ListServicePerimeters(ctx context.Context, in *ListServicePerimetersRequest, opts ...grpc.CallOption) (*ListServicePerimetersResponse, error) {
	out := new(ListServicePerimetersResponse)
	err := c.cc.Invoke(ctx, AccessContextManager_ListServicePerimeters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) GetServicePerimeter(ctx context.Context, in *GetServicePerimeterRequest, opts ...grpc.CallOption) (*ServicePerimeter, error) {
	out := new(ServicePerimeter)
	err := c.cc.Invoke(ctx, AccessContextManager_GetServicePerimeter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) CreateServicePerimeter(ctx context.Context, in *CreateServicePerimeterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_CreateServicePerimeter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) UpdateServicePerimeter(ctx context.Context, in *UpdateServicePerimeterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_UpdateServicePerimeter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) DeleteServicePerimeter(ctx context.Context, in *DeleteServicePerimeterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_DeleteServicePerimeter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) ReplaceServicePerimeters(ctx context.Context, in *ReplaceServicePerimetersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_ReplaceServicePerimeters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) CommitServicePerimeters(ctx context.Context, in *CommitServicePerimetersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_CommitServicePerimeters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) ListGcpUserAccessBindings(ctx context.Context, in *ListGcpUserAccessBindingsRequest, opts ...grpc.CallOption) (*ListGcpUserAccessBindingsResponse, error) {
	out := new(ListGcpUserAccessBindingsResponse)
	err := c.cc.Invoke(ctx, AccessContextManager_ListGcpUserAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) GetGcpUserAccessBinding(ctx context.Context, in *GetGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*GcpUserAccessBinding, error) {
	out := new(GcpUserAccessBinding)
	err := c.cc.Invoke(ctx, AccessContextManager_GetGcpUserAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) CreateGcpUserAccessBinding(ctx context.Context, in *CreateGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_CreateGcpUserAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) UpdateGcpUserAccessBinding(ctx context.Context, in *UpdateGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_UpdateGcpUserAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) DeleteGcpUserAccessBinding(ctx context.Context, in *DeleteGcpUserAccessBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AccessContextManager_DeleteGcpUserAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, AccessContextManager_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, AccessContextManager_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessContextManagerClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, AccessContextManager_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccessContextManagerServer is the server API for AccessContextManager service.
// All implementations should embed UnimplementedAccessContextManagerServer
// for forward compatibility
type AccessContextManagerServer interface {
	// Lists all [access policies]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] in an
	// organization.
	ListAccessPolicies(context.Context, *ListAccessPoliciesRequest) (*ListAccessPoliciesResponse, error)
	// Returns an [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
	GetAccessPolicy(context.Context, *GetAccessPolicyRequest) (*AccessPolicy, error)
	// Creates an access policy. This method fails if the organization already has
	// an access policy. The long-running operation has a successful status
	// after the access policy propagates to long-lasting storage.
	// Syntactic and basic semantic errors are returned in `metadata` as a
	// BadRequest proto.
	CreateAccessPolicy(context.Context, *AccessPolicy) (*longrunningpb.Operation, error)
	// Updates an [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
	// long-running operation from this RPC has a successful status after the
	// changes to the [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
	// to long-lasting storage.
	UpdateAccessPolicy(context.Context, *UpdateAccessPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes an [access policy]
	// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
	// resource name. The long-running operation has a successful status after the
	// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
	// is removed from long-lasting storage.
	DeleteAccessPolicy(context.Context, *DeleteAccessPolicyRequest) (*longrunningpb.Operation, error)
	// Lists all [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
	// policy.
	ListAccessLevels(context.Context, *ListAccessLevelsRequest) (*ListAccessLevelsResponse, error)
	// Gets an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
	// name.
	GetAccessLevel(context.Context, *GetAccessLevelRequest) (*AccessLevel, error)
	// Creates an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
	// operation from this RPC has a successful status after the [access
	// level] [google.identity.accesscontextmanager.v1.AccessLevel]
	// propagates to long-lasting storage. If [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] contain
	// errors, an error response is returned for the first error encountered.
	CreateAccessLevel(context.Context, *CreateAccessLevelRequest) (*longrunningpb.Operation, error)
	// Updates an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
	// operation from this RPC has a successful status after the changes to
	// the [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] propagate
	// to long-lasting storage. If [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] contain
	// errors, an error response is returned for the first error encountered.
	UpdateAccessLevel(context.Context, *UpdateAccessLevelRequest) (*longrunningpb.Operation, error)
	// Deletes an [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
	// name. The long-running operation from this RPC has a successful status
	// after the [access level]
	// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
	// from long-lasting storage.
	DeleteAccessLevel(context.Context, *DeleteAccessLevelRequest) (*longrunningpb.Operation, error)
	// Replaces all existing [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
	// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
	// the [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
	// is done atomically. The long-running operation from this RPC has a
	// successful status after all replacements propagate to long-lasting
	// storage. If the replacement contains errors, an error response is returned
	// for the first error encountered.  Upon error, the replacement is cancelled,
	// and existing [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] are not
	// affected. The Operation.response field contains
	// ReplaceAccessLevelsResponse. Removing [access levels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
	// [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
	// error.
	ReplaceAccessLevels(context.Context, *ReplaceAccessLevelsRequest) (*longrunningpb.Operation, error)
	// Lists all [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
	// access policy.
	ListServicePerimeters(context.Context, *ListServicePerimetersRequest) (*ListServicePerimetersResponse, error)
	// Gets a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
	// resource name.
	GetServicePerimeter(context.Context, *GetServicePerimeterRequest) (*ServicePerimeter, error)
	// Creates a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
	// long-running operation from this RPC has a successful status after the
	// [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]
	// propagates to long-lasting storage. If a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
	// errors, an error response is returned for the first error encountered.
	CreateServicePerimeter(context.Context, *CreateServicePerimeterRequest) (*longrunningpb.Operation, error)
	// Updates a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
	// long-running operation from this RPC has a successful status after the
	// [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter]
	// propagates to long-lasting storage. If a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
	// errors, an error response is returned for the first error encountered.
	UpdateServicePerimeter(context.Context, *UpdateServicePerimeterRequest) (*longrunningpb.Operation, error)
	// Deletes a [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
	// resource name. The long-running operation from this RPC has a successful
	// status after the [service perimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
	// long-lasting storage.
	DeleteServicePerimeter(context.Context, *DeleteServicePerimeterRequest) (*longrunningpb.Operation, error)
	// Replace all existing [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
	// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
	// [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
	// is done atomically. The long-running operation from this RPC has a
	// successful status after all replacements propagate to long-lasting storage.
	// Replacements containing errors result in an error response for the first
	// error encountered. Upon an error, replacement are cancelled and existing
	// [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
	// affected. The Operation.response field contains
	// ReplaceServicePerimetersResponse.
	ReplaceServicePerimeters(context.Context, *ReplaceServicePerimetersRequest) (*longrunningpb.Operation, error)
	// Commits the dry-run specification for all the [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
	// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	// A commit operation on a service perimeter involves copying its `spec` field
	// to the `status` field of the service perimeter. Only [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] with
	// `use_explicit_dry_run_spec` field set to true are affected by a commit
	// operation. The long-running operation from this RPC has a successful
	// status after the dry-run specifications for all the [service perimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
	// committed. If a commit fails, it causes the long-running operation to
	// return an error response and the entire commit operation is cancelled.
	// When successful, the Operation.response field contains
	// CommitServicePerimetersResponse. The `dry_run` and the `spec` fields are
	// cleared after a successful commit operation.
	CommitServicePerimeters(context.Context, *CommitServicePerimetersRequest) (*longrunningpb.Operation, error)
	// Lists all [GcpUserAccessBindings]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
	// Google Cloud organization.
	ListGcpUserAccessBindings(context.Context, *ListGcpUserAccessBindingsRequest) (*ListGcpUserAccessBindingsResponse, error)
	// Gets the [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
	// the given name.
	GetGcpUserAccessBinding(context.Context, *GetGcpUserAccessBindingRequest) (*GcpUserAccessBinding, error)
	// Creates a [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
	// client specifies a [name]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
	// the server ignores it. Fails if a resource already exists with the same
	// [group_key]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
	// Completion of this long-running operation does not necessarily signify that
	// the new binding is deployed onto all affected users, which may take more
	// time.
	CreateGcpUserAccessBinding(context.Context, *CreateGcpUserAccessBindingRequest) (*longrunningpb.Operation, error)
	// Updates a [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
	// Completion of this long-running operation does not necessarily signify that
	// the changed binding is deployed onto all affected users, which may take
	// more time.
	UpdateGcpUserAccessBinding(context.Context, *UpdateGcpUserAccessBindingRequest) (*longrunningpb.Operation, error)
	// Deletes a [GcpUserAccessBinding]
	// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
	// Completion of this long-running operation does not necessarily signify that
	// the binding deletion is deployed onto all affected users, which may take
	// more time.
	DeleteGcpUserAccessBinding(context.Context, *DeleteGcpUserAccessBindingRequest) (*longrunningpb.Operation, error)
	// Sets the IAM policy for the specified Access Context Manager
	// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	// This method replaces the existing IAM policy on the access policy. The IAM
	// policy controls the set of users who can perform specific operations on the
	// Access Context Manager [access
	// policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the IAM policy for the specified Access Context Manager
	// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns the IAM permissions that the caller has on the specified Access
	// Context Manager resource. The resource can be an
	// [AccessPolicy][google.identity.accesscontextmanager.v1.AccessPolicy],
	// [AccessLevel][google.identity.accesscontextmanager.v1.AccessLevel], or
	// [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
	// ]. This method does not support other resources.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedAccessContextManagerServer should be embedded to have forward compatible implementations.
type UnimplementedAccessContextManagerServer struct {
}

func (UnimplementedAccessContextManagerServer) ListAccessPolicies(context.Context, *ListAccessPoliciesRequest) (*ListAccessPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessPolicies not implemented")
}
func (UnimplementedAccessContextManagerServer) GetAccessPolicy(context.Context, *GetAccessPolicyRequest) (*AccessPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessPolicy not implemented")
}
func (UnimplementedAccessContextManagerServer) CreateAccessPolicy(context.Context, *AccessPolicy) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAccessPolicy not implemented")
}
func (UnimplementedAccessContextManagerServer) UpdateAccessPolicy(context.Context, *UpdateAccessPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessPolicy not implemented")
}
func (UnimplementedAccessContextManagerServer) DeleteAccessPolicy(context.Context, *DeleteAccessPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessPolicy not implemented")
}
func (UnimplementedAccessContextManagerServer) ListAccessLevels(context.Context, *ListAccessLevelsRequest) (*ListAccessLevelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessLevels not implemented")
}
func (UnimplementedAccessContextManagerServer) GetAccessLevel(context.Context, *GetAccessLevelRequest) (*AccessLevel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessLevel not implemented")
}
func (UnimplementedAccessContextManagerServer) CreateAccessLevel(context.Context, *CreateAccessLevelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAccessLevel not implemented")
}
func (UnimplementedAccessContextManagerServer) UpdateAccessLevel(context.Context, *UpdateAccessLevelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessLevel not implemented")
}
func (UnimplementedAccessContextManagerServer) DeleteAccessLevel(context.Context, *DeleteAccessLevelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessLevel not implemented")
}
func (UnimplementedAccessContextManagerServer) ReplaceAccessLevels(context.Context, *ReplaceAccessLevelsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceAccessLevels not implemented")
}
func (UnimplementedAccessContextManagerServer) ListServicePerimeters(context.Context, *ListServicePerimetersRequest) (*ListServicePerimetersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServicePerimeters not implemented")
}
func (UnimplementedAccessContextManagerServer) GetServicePerimeter(context.Context, *GetServicePerimeterRequest) (*ServicePerimeter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServicePerimeter not implemented")
}
func (UnimplementedAccessContextManagerServer) CreateServicePerimeter(context.Context, *CreateServicePerimeterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServicePerimeter not implemented")
}
func (UnimplementedAccessContextManagerServer) UpdateServicePerimeter(context.Context, *UpdateServicePerimeterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServicePerimeter not implemented")
}
func (UnimplementedAccessContextManagerServer) DeleteServicePerimeter(context.Context, *DeleteServicePerimeterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServicePerimeter not implemented")
}
func (UnimplementedAccessContextManagerServer) ReplaceServicePerimeters(context.Context, *ReplaceServicePerimetersRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplaceServicePerimeters not implemented")
}
func (UnimplementedAccessContextManagerServer) CommitServicePerimeters(context.Context, *CommitServicePerimetersRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitServicePerimeters not implemented")
}
func (UnimplementedAccessContextManagerServer) ListGcpUserAccessBindings(context.Context, *ListGcpUserAccessBindingsRequest) (*ListGcpUserAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGcpUserAccessBindings not implemented")
}
func (UnimplementedAccessContextManagerServer) GetGcpUserAccessBinding(context.Context, *GetGcpUserAccessBindingRequest) (*GcpUserAccessBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGcpUserAccessBinding not implemented")
}
func (UnimplementedAccessContextManagerServer) CreateGcpUserAccessBinding(context.Context, *CreateGcpUserAccessBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGcpUserAccessBinding not implemented")
}
func (UnimplementedAccessContextManagerServer) UpdateGcpUserAccessBinding(context.Context, *UpdateGcpUserAccessBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGcpUserAccessBinding not implemented")
}
func (UnimplementedAccessContextManagerServer) DeleteGcpUserAccessBinding(context.Context, *DeleteGcpUserAccessBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGcpUserAccessBinding not implemented")
}
func (UnimplementedAccessContextManagerServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedAccessContextManagerServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedAccessContextManagerServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeAccessContextManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AccessContextManagerServer will
// result in compilation errors.
type UnsafeAccessContextManagerServer interface {
	mustEmbedUnimplementedAccessContextManagerServer()
}

func RegisterAccessContextManagerServer(s grpc.ServiceRegistrar, srv AccessContextManagerServer) {
	s.RegisterService(&AccessContextManager_ServiceDesc, srv)
}

func _AccessContextManager_ListAccessPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccessPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).ListAccessPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_ListAccessPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).ListAccessPolicies(ctx, req.(*ListAccessPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_GetAccessPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).GetAccessPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_GetAccessPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).GetAccessPolicy(ctx, req.(*GetAccessPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_CreateAccessPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AccessPolicy)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).CreateAccessPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_CreateAccessPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).CreateAccessPolicy(ctx, req.(*AccessPolicy))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_UpdateAccessPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).UpdateAccessPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_UpdateAccessPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).UpdateAccessPolicy(ctx, req.(*UpdateAccessPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_DeleteAccessPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).DeleteAccessPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_DeleteAccessPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).DeleteAccessPolicy(ctx, req.(*DeleteAccessPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_ListAccessLevels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccessLevelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).ListAccessLevels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_ListAccessLevels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).ListAccessLevels(ctx, req.(*ListAccessLevelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_GetAccessLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).GetAccessLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_GetAccessLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).GetAccessLevel(ctx, req.(*GetAccessLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_CreateAccessLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAccessLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).CreateAccessLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_CreateAccessLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).CreateAccessLevel(ctx, req.(*CreateAccessLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_UpdateAccessLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).UpdateAccessLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_UpdateAccessLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).UpdateAccessLevel(ctx, req.(*UpdateAccessLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_DeleteAccessLevel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessLevelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).DeleteAccessLevel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_DeleteAccessLevel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).DeleteAccessLevel(ctx, req.(*DeleteAccessLevelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_ReplaceAccessLevels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceAccessLevelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).ReplaceAccessLevels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_ReplaceAccessLevels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).ReplaceAccessLevels(ctx, req.(*ReplaceAccessLevelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_ListServicePerimeters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicePerimetersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).ListServicePerimeters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_ListServicePerimeters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).ListServicePerimeters(ctx, req.(*ListServicePerimetersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_GetServicePerimeter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServicePerimeterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).GetServicePerimeter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_GetServicePerimeter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).GetServicePerimeter(ctx, req.(*GetServicePerimeterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_CreateServicePerimeter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServicePerimeterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).CreateServicePerimeter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_CreateServicePerimeter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).CreateServicePerimeter(ctx, req.(*CreateServicePerimeterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_UpdateServicePerimeter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServicePerimeterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).UpdateServicePerimeter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_UpdateServicePerimeter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).UpdateServicePerimeter(ctx, req.(*UpdateServicePerimeterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_DeleteServicePerimeter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServicePerimeterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).DeleteServicePerimeter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_DeleteServicePerimeter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).DeleteServicePerimeter(ctx, req.(*DeleteServicePerimeterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_ReplaceServicePerimeters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReplaceServicePerimetersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).ReplaceServicePerimeters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_ReplaceServicePerimeters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).ReplaceServicePerimeters(ctx, req.(*ReplaceServicePerimetersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_CommitServicePerimeters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitServicePerimetersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).CommitServicePerimeters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_CommitServicePerimeters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).CommitServicePerimeters(ctx, req.(*CommitServicePerimetersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_ListGcpUserAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGcpUserAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).ListGcpUserAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_ListGcpUserAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).ListGcpUserAccessBindings(ctx, req.(*ListGcpUserAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_GetGcpUserAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGcpUserAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).GetGcpUserAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_GetGcpUserAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).GetGcpUserAccessBinding(ctx, req.(*GetGcpUserAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_CreateGcpUserAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGcpUserAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).CreateGcpUserAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_CreateGcpUserAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).CreateGcpUserAccessBinding(ctx, req.(*CreateGcpUserAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_UpdateGcpUserAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGcpUserAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).UpdateGcpUserAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_UpdateGcpUserAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).UpdateGcpUserAccessBinding(ctx, req.(*UpdateGcpUserAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_DeleteGcpUserAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGcpUserAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).DeleteGcpUserAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_DeleteGcpUserAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).DeleteGcpUserAccessBinding(ctx, req.(*DeleteGcpUserAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessContextManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessContextManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AccessContextManager_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessContextManagerServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AccessContextManager_ServiceDesc is the grpc.ServiceDesc for AccessContextManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AccessContextManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.identity.accesscontextmanager.v1.AccessContextManager",
	HandlerType: (*AccessContextManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAccessPolicies",
			Handler:    _AccessContextManager_ListAccessPolicies_Handler,
		},
		{
			MethodName: "GetAccessPolicy",
			Handler:    _AccessContextManager_GetAccessPolicy_Handler,
		},
		{
			MethodName: "CreateAccessPolicy",
			Handler:    _AccessContextManager_CreateAccessPolicy_Handler,
		},
		{
			MethodName: "UpdateAccessPolicy",
			Handler:    _AccessContextManager_UpdateAccessPolicy_Handler,
		},
		{
			MethodName: "DeleteAccessPolicy",
			Handler:    _AccessContextManager_DeleteAccessPolicy_Handler,
		},
		{
			MethodName: "ListAccessLevels",
			Handler:    _AccessContextManager_ListAccessLevels_Handler,
		},
		{
			MethodName: "GetAccessLevel",
			Handler:    _AccessContextManager_GetAccessLevel_Handler,
		},
		{
			MethodName: "CreateAccessLevel",
			Handler:    _AccessContextManager_CreateAccessLevel_Handler,
		},
		{
			MethodName: "UpdateAccessLevel",
			Handler:    _AccessContextManager_UpdateAccessLevel_Handler,
		},
		{
			MethodName: "DeleteAccessLevel",
			Handler:    _AccessContextManager_DeleteAccessLevel_Handler,
		},
		{
			MethodName: "ReplaceAccessLevels",
			Handler:    _AccessContextManager_ReplaceAccessLevels_Handler,
		},
		{
			MethodName: "ListServicePerimeters",
			Handler:    _AccessContextManager_ListServicePerimeters_Handler,
		},
		{
			MethodName: "GetServicePerimeter",
			Handler:    _AccessContextManager_GetServicePerimeter_Handler,
		},
		{
			MethodName: "CreateServicePerimeter",
			Handler:    _AccessContextManager_CreateServicePerimeter_Handler,
		},
		{
			MethodName: "UpdateServicePerimeter",
			Handler:    _AccessContextManager_UpdateServicePerimeter_Handler,
		},
		{
			MethodName: "DeleteServicePerimeter",
			Handler:    _AccessContextManager_DeleteServicePerimeter_Handler,
		},
		{
			MethodName: "ReplaceServicePerimeters",
			Handler:    _AccessContextManager_ReplaceServicePerimeters_Handler,
		},
		{
			MethodName: "CommitServicePerimeters",
			Handler:    _AccessContextManager_CommitServicePerimeters_Handler,
		},
		{
			MethodName: "ListGcpUserAccessBindings",
			Handler:    _AccessContextManager_ListGcpUserAccessBindings_Handler,
		},
		{
			MethodName: "GetGcpUserAccessBinding",
			Handler:    _AccessContextManager_GetGcpUserAccessBinding_Handler,
		},
		{
			MethodName: "CreateGcpUserAccessBinding",
			Handler:    _AccessContextManager_CreateGcpUserAccessBinding_Handler,
		},
		{
			MethodName: "UpdateGcpUserAccessBinding",
			Handler:    _AccessContextManager_UpdateGcpUserAccessBinding_Handler,
		},
		{
			MethodName: "DeleteGcpUserAccessBinding",
			Handler:    _AccessContextManager_DeleteGcpUserAccessBinding_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _AccessContextManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _AccessContextManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _AccessContextManager_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/identity/accesscontextmanager/v1/access_context_manager.proto",
}
