/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;

public class Quantile
implements DoubleConsumer {
    private long _samples = 0L;
    private final double _quantile;
    private final double[] _q = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] _n = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] _nn = new double[]{0.0, 0.0, 0.0};
    private final double[] _dn = new double[]{0.0, 0.0, 0.0};
    private boolean _initialized;

    public Quantile(double quantile) {
        this._quantile = quantile;
        this.init(quantile);
    }

    private void init(double quantile) {
        Quantile.check(quantile);
        Arrays.fill(this._q, 0.0);
        Arrays.fill(this._n, 0.0);
        Arrays.fill(this._nn, 0.0);
        Arrays.fill(this._dn, 0.0);
        this._n[0] = -1.0;
        this._q[2] = 0.0;
        this._initialized = Double.compare(quantile, 0.0) == 0 || Double.compare(quantile, 1.0) == 0;
        this._samples = 0L;
    }

    private static void check(double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException(String.format("Quantile (%s) not in the valid range of [0, 1]", quantile));
        }
    }

    public void reset() {
        this.init(this._quantile);
    }

    public double getQuantile() {
        return this._quantile;
    }

    public double getValue() {
        return this._q[2];
    }

    public long getSamples() {
        return this._samples;
    }

    @Override
    public void accept(double value) {
        if (!this._initialized) {
            this.initialize(value);
        } else {
            this.update(value);
        }
        ++this._samples;
    }

    public Quantile combine(Quantile other) {
        if (Double.compare(this._quantile, other._quantile) != 0) {
            throw new IllegalArgumentException(String.format("Can't perform combine, the quantile are not equal: %s != %s", this._quantile, other._quantile));
        }
        this._samples += other._samples;
        if (this._quantile == 0.0) {
            this._q[2] = Math.min(this._q[2], other._q[2]);
        } else if (this._quantile == 1.0) {
            this._q[2] = Math.max(this._q[2], other._q[2]);
        } else {
            this._n[1] = this._n[1] + other._n[1];
            this._n[2] = this._n[2] + other._n[2];
            this._n[3] = this._n[3] + other._n[3];
            this._n[4] = this._n[4] + other._n[4];
            this._q[0] = Math.min(this._q[0], other._q[0]);
            this._q[1] = (this._q[1] + other._q[1]) * 0.5;
            this._q[2] = (this._q[2] + other._q[2]) * 0.5;
            this._q[3] = (this._q[3] + other._q[3]) * 0.5;
            this._q[4] = Math.max(this._q[4], other._q[4]);
            this._nn[0] = this._nn[0] + other._nn[0];
            this._nn[1] = this._nn[1] + other._nn[1];
            this._nn[2] = this._nn[2] + other._nn[2];
            this.adjustMarkerHeights();
        }
        return this;
    }

    private void initialize(double value) {
        if (this._n[0] < 0.0) {
            this._n[0] = 0.0;
            this._q[0] = value;
        } else if (this._n[1] == 0.0) {
            this._n[1] = 1.0;
            this._q[1] = value;
        } else if (this._n[2] == 0.0) {
            this._n[2] = 2.0;
            this._q[2] = value;
        } else if (this._n[3] == 0.0) {
            this._n[3] = 3.0;
            this._q[3] = value;
        } else if (this._n[4] == 0.0) {
            this._n[4] = 4.0;
            this._q[4] = value;
        }
        if (this._n[4] != 0.0) {
            Arrays.sort(this._q);
            this._nn[0] = 2.0 * this._quantile;
            this._nn[1] = 4.0 * this._quantile;
            this._nn[2] = 2.0 * this._quantile + 2.0;
            this._dn[0] = this._quantile / 2.0;
            this._dn[1] = this._quantile;
            this._dn[2] = (1.0 + this._quantile) / 2.0;
            this._initialized = true;
        }
    }

    private void update(double value) {
        assert (this._initialized);
        if (this._quantile == 0.0) {
            if (value < this._q[2]) {
                this._q[2] = value;
            }
        } else if (this._quantile == 1.0) {
            if (value > this._q[2]) {
                this._q[2] = value;
            }
        } else {
            if (value < this._q[0]) {
                this._n[1] = this._n[1] + 1.0;
                this._n[2] = this._n[2] + 1.0;
                this._n[3] = this._n[3] + 1.0;
                this._n[4] = this._n[4] + 1.0;
                this._q[0] = value;
            } else if (value < this._q[1]) {
                this._n[1] = this._n[1] + 1.0;
                this._n[2] = this._n[2] + 1.0;
                this._n[3] = this._n[3] + 1.0;
                this._n[4] = this._n[4] + 1.0;
            } else if (value < this._q[2]) {
                this._n[2] = this._n[2] + 1.0;
                this._n[3] = this._n[3] + 1.0;
                this._n[4] = this._n[4] + 1.0;
            } else if (value < this._q[3]) {
                this._n[3] = this._n[3] + 1.0;
                this._n[4] = this._n[4] + 1.0;
            } else if (value < this._q[4]) {
                this._n[4] = this._n[4] + 1.0;
            } else {
                this._n[4] = this._n[4] + 1.0;
                this._q[4] = value;
            }
            this._nn[0] = this._nn[0] + this._dn[0];
            this._nn[1] = this._nn[1] + this._dn[1];
            this._nn[2] = this._nn[2] + this._dn[2];
            this.adjustMarkerHeights();
        }
    }

    private void adjustMarkerHeights() {
        double mm = this._n[1] - 1.0;
        double mp = this._n[1] + 1.0;
        if (this._nn[0] >= mp && this._n[2] > mp) {
            this._q[1] = Quantile.qPlus(mp, this._n[0], this._n[1], this._n[2], this._q[0], this._q[1], this._q[2]);
            this._n[1] = mp;
        } else if (this._nn[0] <= mm && this._n[0] < mm) {
            this._q[1] = Quantile.qMinus(mm, this._n[0], this._n[1], this._n[2], this._q[0], this._q[1], this._q[2]);
            this._n[1] = mm;
        }
        mm = this._n[2] - 1.0;
        mp = this._n[2] + 1.0;
        if (this._nn[1] >= mp && this._n[3] > mp) {
            this._q[2] = Quantile.qPlus(mp, this._n[1], this._n[2], this._n[3], this._q[1], this._q[2], this._q[3]);
            this._n[2] = mp;
        } else if (this._nn[1] <= mm && this._n[1] < mm) {
            this._q[2] = Quantile.qMinus(mm, this._n[1], this._n[2], this._n[3], this._q[1], this._q[2], this._q[3]);
            this._n[2] = mm;
        }
        mm = this._n[3] - 1.0;
        mp = this._n[3] + 1.0;
        if (this._nn[2] >= mp && this._n[4] > mp) {
            this._q[3] = Quantile.qPlus(mp, this._n[2], this._n[3], this._n[4], this._q[2], this._q[3], this._q[4]);
            this._n[3] = mp;
        } else if (this._nn[2] <= mm && this._n[2] < mm) {
            this._q[3] = Quantile.qMinus(mm, this._n[2], this._n[3], this._n[4], this._q[2], this._q[3], this._q[4]);
            this._n[3] = mm;
        }
    }

    private static double qPlus(double mp, double m0, double m1, double m2, double q0, double q1, double q2) {
        double result = q1 + ((mp - m0) * (q2 - q1) / (m2 - m1) + (m2 - mp) * (q1 - q0) / (m1 - m0)) / (m2 - m0);
        if (result > q2) {
            result = q1 + (q2 - q1) / (m2 - m1);
        }
        return result;
    }

    private static double qMinus(double mm, double m0, double m1, double m2, double q0, double q1, double q2) {
        double result = q1 - ((mm - m0) * (q2 - q1) / (m2 - m1) + (m2 - mm) * (q1 - q0) / (m1 - m0)) / (m2 - m0);
        if (q0 > result) {
            result = q1 + (q0 - q1) / (m0 - m1);
        }
        return result;
    }

    public boolean sameState(Quantile other) {
        return Objects.equals(this._quantile, other._quantile) && Arrays.equals(this._dn, other._dn) && Arrays.equals(this._n, other._n) && Arrays.equals(this._nn, other._nn) && Arrays.equals(this._q, other._q);
    }

    public String toString() {
        return String.format("%s[samples=%d, quantile=%f]", this.getClass().getSimpleName(), this.getSamples(), this.getValue());
    }

    static Quantile median() {
        return new Quantile(0.5);
    }

    public static <T> Collector<T, ?, Quantile> toQuantile(double quantile, ToDoubleFunction<? super T> mapper) {
        Quantile.check(quantile);
        Objects.requireNonNull(mapper);
        return Collector.of(() -> new Quantile(quantile), (r, t) -> r.accept(mapper.applyAsDouble(t)), Quantile::combine, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Quantile> toMedian(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(Quantile::median, (r, t) -> r.accept(mapper.applyAsDouble(t)), Quantile::combine, new Collector.Characteristics[0]);
    }
}

