//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AlertIncidentsServer is a fake server for instances of the armauthorization.AlertIncidentsClient type.
type AlertIncidentsServer struct {
	// Get is the fake for method AlertIncidentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, alertID string, alertIncidentID string, options *armauthorization.AlertIncidentsClientGetOptions) (resp azfake.Responder[armauthorization.AlertIncidentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListForScopePager is the fake for method AlertIncidentsClient.NewListForScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForScopePager func(scope string, alertID string, options *armauthorization.AlertIncidentsClientListForScopeOptions) (resp azfake.PagerResponder[armauthorization.AlertIncidentsClientListForScopeResponse])

	// Remediate is the fake for method AlertIncidentsClient.Remediate
	// HTTP status codes to indicate success: http.StatusNoContent
	Remediate func(ctx context.Context, scope string, alertID string, alertIncidentID string, options *armauthorization.AlertIncidentsClientRemediateOptions) (resp azfake.Responder[armauthorization.AlertIncidentsClientRemediateResponse], errResp azfake.ErrorResponder)
}

// NewAlertIncidentsServerTransport creates a new instance of AlertIncidentsServerTransport with the provided implementation.
// The returned AlertIncidentsServerTransport instance is connected to an instance of armauthorization.AlertIncidentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertIncidentsServerTransport(srv *AlertIncidentsServer) *AlertIncidentsServerTransport {
	return &AlertIncidentsServerTransport{
		srv:                  srv,
		newListForScopePager: newTracker[azfake.PagerResponder[armauthorization.AlertIncidentsClientListForScopeResponse]](),
	}
}

// AlertIncidentsServerTransport connects instances of armauthorization.AlertIncidentsClient to instances of AlertIncidentsServer.
// Don't use this type directly, use NewAlertIncidentsServerTransport instead.
type AlertIncidentsServerTransport struct {
	srv                  *AlertIncidentsServer
	newListForScopePager *tracker[azfake.PagerResponder[armauthorization.AlertIncidentsClientListForScopeResponse]]
}

// Do implements the policy.Transporter interface for AlertIncidentsServerTransport.
func (a *AlertIncidentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertIncidentsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AlertIncidentsClient.NewListForScopePager":
		resp, err = a.dispatchNewListForScopePager(req)
	case "AlertIncidentsClient.Remediate":
		resp, err = a.dispatchRemediate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertIncidentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alertIncidents/(?P<alertIncidentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	alertIncidentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertIncidentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), scopeParam, alertIDParam, alertIncidentIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AlertIncident, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertIncidentsServerTransport) dispatchNewListForScopePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForScopePager not implemented")}
	}
	newListForScopePager := a.newListForScopePager.get(req)
	if newListForScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alertIncidents`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListForScopePager(scopeParam, alertIDParam, nil)
		newListForScopePager = &resp
		a.newListForScopePager.add(req, newListForScopePager)
		server.PagerResponderInjectNextLinks(newListForScopePager, req, func(page *armauthorization.AlertIncidentsClientListForScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForScopePager) {
		a.newListForScopePager.remove(req)
	}
	return resp, nil
}

func (a *AlertIncidentsServerTransport) dispatchRemediate(req *http.Request) (*http.Response, error) {
	if a.srv.Remediate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Remediate not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementAlerts/(?P<alertId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alertIncidents/(?P<alertIncidentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/remediate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	alertIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertId")])
	if err != nil {
		return nil, err
	}
	alertIncidentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertIncidentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Remediate(req.Context(), scopeParam, alertIDParam, alertIncidentIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
