// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.proto

package appconnectorspb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AppConnectorsService_ListAppConnectors_FullMethodName  = "/google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService/ListAppConnectors"
	AppConnectorsService_GetAppConnector_FullMethodName    = "/google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService/GetAppConnector"
	AppConnectorsService_CreateAppConnector_FullMethodName = "/google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService/CreateAppConnector"
	AppConnectorsService_UpdateAppConnector_FullMethodName = "/google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService/UpdateAppConnector"
	AppConnectorsService_DeleteAppConnector_FullMethodName = "/google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService/DeleteAppConnector"
	AppConnectorsService_ReportStatus_FullMethodName       = "/google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService/ReportStatus"
)

// AppConnectorsServiceClient is the client API for AppConnectorsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AppConnectorsServiceClient interface {
	// Lists AppConnectors in a given project and location.
	ListAppConnectors(ctx context.Context, in *ListAppConnectorsRequest, opts ...grpc.CallOption) (*ListAppConnectorsResponse, error)
	// Gets details of a single AppConnector.
	GetAppConnector(ctx context.Context, in *GetAppConnectorRequest, opts ...grpc.CallOption) (*AppConnector, error)
	// Creates a new AppConnector in a given project and location.
	CreateAppConnector(ctx context.Context, in *CreateAppConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AppConnector.
	UpdateAppConnector(ctx context.Context, in *UpdateAppConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single AppConnector.
	DeleteAppConnector(ctx context.Context, in *DeleteAppConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Report status for a given connector.
	ReportStatus(ctx context.Context, in *ReportStatusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type appConnectorsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAppConnectorsServiceClient(cc grpc.ClientConnInterface) AppConnectorsServiceClient {
	return &appConnectorsServiceClient{cc}
}

func (c *appConnectorsServiceClient) ListAppConnectors(ctx context.Context, in *ListAppConnectorsRequest, opts ...grpc.CallOption) (*ListAppConnectorsResponse, error) {
	out := new(ListAppConnectorsResponse)
	err := c.cc.Invoke(ctx, AppConnectorsService_ListAppConnectors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectorsServiceClient) GetAppConnector(ctx context.Context, in *GetAppConnectorRequest, opts ...grpc.CallOption) (*AppConnector, error) {
	out := new(AppConnector)
	err := c.cc.Invoke(ctx, AppConnectorsService_GetAppConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectorsServiceClient) CreateAppConnector(ctx context.Context, in *CreateAppConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectorsService_CreateAppConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectorsServiceClient) UpdateAppConnector(ctx context.Context, in *UpdateAppConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectorsService_UpdateAppConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectorsServiceClient) DeleteAppConnector(ctx context.Context, in *DeleteAppConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectorsService_DeleteAppConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectorsServiceClient) ReportStatus(ctx context.Context, in *ReportStatusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AppConnectorsService_ReportStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppConnectorsServiceServer is the server API for AppConnectorsService service.
// All implementations should embed UnimplementedAppConnectorsServiceServer
// for forward compatibility
type AppConnectorsServiceServer interface {
	// Lists AppConnectors in a given project and location.
	ListAppConnectors(context.Context, *ListAppConnectorsRequest) (*ListAppConnectorsResponse, error)
	// Gets details of a single AppConnector.
	GetAppConnector(context.Context, *GetAppConnectorRequest) (*AppConnector, error)
	// Creates a new AppConnector in a given project and location.
	CreateAppConnector(context.Context, *CreateAppConnectorRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AppConnector.
	UpdateAppConnector(context.Context, *UpdateAppConnectorRequest) (*longrunningpb.Operation, error)
	// Deletes a single AppConnector.
	DeleteAppConnector(context.Context, *DeleteAppConnectorRequest) (*longrunningpb.Operation, error)
	// Report status for a given connector.
	ReportStatus(context.Context, *ReportStatusRequest) (*longrunningpb.Operation, error)
}

// UnimplementedAppConnectorsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAppConnectorsServiceServer struct {
}

func (UnimplementedAppConnectorsServiceServer) ListAppConnectors(context.Context, *ListAppConnectorsRequest) (*ListAppConnectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppConnectors not implemented")
}
func (UnimplementedAppConnectorsServiceServer) GetAppConnector(context.Context, *GetAppConnectorRequest) (*AppConnector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppConnector not implemented")
}
func (UnimplementedAppConnectorsServiceServer) CreateAppConnector(context.Context, *CreateAppConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppConnector not implemented")
}
func (UnimplementedAppConnectorsServiceServer) UpdateAppConnector(context.Context, *UpdateAppConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAppConnector not implemented")
}
func (UnimplementedAppConnectorsServiceServer) DeleteAppConnector(context.Context, *DeleteAppConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppConnector not implemented")
}
func (UnimplementedAppConnectorsServiceServer) ReportStatus(context.Context, *ReportStatusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportStatus not implemented")
}

// UnsafeAppConnectorsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AppConnectorsServiceServer will
// result in compilation errors.
type UnsafeAppConnectorsServiceServer interface {
	mustEmbedUnimplementedAppConnectorsServiceServer()
}

func RegisterAppConnectorsServiceServer(s grpc.ServiceRegistrar, srv AppConnectorsServiceServer) {
	s.RegisterService(&AppConnectorsService_ServiceDesc, srv)
}

func _AppConnectorsService_ListAppConnectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppConnectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectorsServiceServer).ListAppConnectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectorsService_ListAppConnectors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectorsServiceServer).ListAppConnectors(ctx, req.(*ListAppConnectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectorsService_GetAppConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectorsServiceServer).GetAppConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectorsService_GetAppConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectorsServiceServer).GetAppConnector(ctx, req.(*GetAppConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectorsService_CreateAppConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectorsServiceServer).CreateAppConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectorsService_CreateAppConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectorsServiceServer).CreateAppConnector(ctx, req.(*CreateAppConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectorsService_UpdateAppConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAppConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectorsServiceServer).UpdateAppConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectorsService_UpdateAppConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectorsServiceServer).UpdateAppConnector(ctx, req.(*UpdateAppConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectorsService_DeleteAppConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectorsServiceServer).DeleteAppConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectorsService_DeleteAppConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectorsServiceServer).DeleteAppConnector(ctx, req.(*DeleteAppConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectorsService_ReportStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectorsServiceServer).ReportStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AppConnectorsService_ReportStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectorsServiceServer).ReportStatus(ctx, req.(*ReportStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AppConnectorsService_ServiceDesc is the grpc.ServiceDesc for AppConnectorsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AppConnectorsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.appconnectors.v1.AppConnectorsService",
	HandlerType: (*AppConnectorsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAppConnectors",
			Handler:    _AppConnectorsService_ListAppConnectors_Handler,
		},
		{
			MethodName: "GetAppConnector",
			Handler:    _AppConnectorsService_GetAppConnector_Handler,
		},
		{
			MethodName: "CreateAppConnector",
			Handler:    _AppConnectorsService_CreateAppConnector_Handler,
		},
		{
			MethodName: "UpdateAppConnector",
			Handler:    _AppConnectorsService_UpdateAppConnector_Handler,
		},
		{
			MethodName: "DeleteAppConnector",
			Handler:    _AppConnectorsService_DeleteAppConnector_Handler,
		},
		{
			MethodName: "ReportStatus",
			Handler:    _AppConnectorsService_ReportStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/appconnectors/v1/app_connectors_service.proto",
}
