// Code generated by scripts/generate_go_funcs; DO NOT EDIT.
package safety

import "sync"

// Bool is a thread-safe bool implementation.
type Bool struct {
	sync.RWMutex
	value bool
}

// NewBool will return a pointer to a new Bool instance.
func NewBool() *Bool {
	return &Bool{}
}

// Get will return the current value.
func (p *Bool) Get() bool {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Bool) Set(val bool) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Bool) UnsafeSet(val bool) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Bool) EqualSet(expected bool, val bool) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Bool) NotEqualSet(expected bool, val bool) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// Float32 is a thread-safe float32 implementation.
type Float32 struct {
	sync.RWMutex
	value float32
}

// NewFloat32 will return a pointer to a new Float32 instance.
func NewFloat32() *Float32 {
	return &Float32{}
}

// Get will return the current value.
func (p *Float32) Get() float32 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Float32) Set(val float32) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Float32) UnsafeSet(val float32) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) EqualSet(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) NotEqualSet(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterEqualSet(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessEqualSet(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterAdd(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterEqualAdd(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessAdd(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessEqualAdd(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterDec(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterEqualDec(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessDec(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessEqualDec(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterInc(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterEqualInc(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessInc(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessEqualInc(expected float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterSub(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) GreaterEqualSub(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessSub(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float32) LessEqualSub(expected float32, val float32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Float32) Add(value float32) float32 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Float32) Dec() float32 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Float32) Inc() float32 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Float32) Sub(value float32) float32 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Float32) UnsafeAdd(value float32) float32 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Float32) UnsafeDec() float32 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Float32) UnsafeInc() float32 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Float32) UnsafeSub(value float32) float32 {
	p.value -= value
	return p.value
}

// Float64 is a thread-safe float64 implementation.
type Float64 struct {
	sync.RWMutex
	value float64
}

// NewFloat64 will return a pointer to a new Float64 instance.
func NewFloat64() *Float64 {
	return &Float64{}
}

// Get will return the current value.
func (p *Float64) Get() float64 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Float64) Set(val float64) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Float64) UnsafeSet(val float64) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) EqualSet(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) NotEqualSet(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterEqualSet(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessEqualSet(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterAdd(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterEqualAdd(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessAdd(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessEqualAdd(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterDec(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterEqualDec(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessDec(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessEqualDec(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterInc(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterEqualInc(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessInc(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessEqualInc(expected float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterSub(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) GreaterEqualSub(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessSub(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Float64) LessEqualSub(expected float64, val float64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Float64) Add(value float64) float64 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Float64) Dec() float64 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Float64) Inc() float64 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Float64) Sub(value float64) float64 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Float64) UnsafeAdd(value float64) float64 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Float64) UnsafeDec() float64 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Float64) UnsafeInc() float64 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Float64) UnsafeSub(value float64) float64 {
	p.value -= value
	return p.value
}

// Int is a thread-safe int implementation.
type Int struct {
	sync.RWMutex
	value int
}

// NewInt will return a pointer to a new Int instance.
func NewInt() *Int {
	return &Int{}
}

// Get will return the current value.
func (p *Int) Get() int {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Int) Set(val int) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Int) UnsafeSet(val int) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) EqualSet(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) NotEqualSet(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterEqualSet(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessEqualSet(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterAdd(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterEqualAdd(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessAdd(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessEqualAdd(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterDec(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterEqualDec(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessDec(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessEqualDec(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterInc(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterEqualInc(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessInc(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessEqualInc(expected int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterSub(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) GreaterEqualSub(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessSub(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int) LessEqualSub(expected int, val int) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Int) Add(value int) int {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Int) Dec() int {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Int) Inc() int {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Int) Sub(value int) int {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Int) UnsafeAdd(value int) int {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Int) UnsafeDec() int {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Int) UnsafeInc() int {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Int) UnsafeSub(value int) int {
	p.value -= value
	return p.value
}

// Int8 is a thread-safe int8 implementation.
type Int8 struct {
	sync.RWMutex
	value int8
}

// NewInt8 will return a pointer to a new Int8 instance.
func NewInt8() *Int8 {
	return &Int8{}
}

// Get will return the current value.
func (p *Int8) Get() int8 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Int8) Set(val int8) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Int8) UnsafeSet(val int8) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) EqualSet(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) NotEqualSet(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterEqualSet(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessEqualSet(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterAdd(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterEqualAdd(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessAdd(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessEqualAdd(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterDec(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterEqualDec(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessDec(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessEqualDec(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterInc(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterEqualInc(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessInc(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessEqualInc(expected int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterSub(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) GreaterEqualSub(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessSub(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int8) LessEqualSub(expected int8, val int8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Int8) Add(value int8) int8 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Int8) Dec() int8 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Int8) Inc() int8 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Int8) Sub(value int8) int8 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Int8) UnsafeAdd(value int8) int8 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Int8) UnsafeDec() int8 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Int8) UnsafeInc() int8 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Int8) UnsafeSub(value int8) int8 {
	p.value -= value
	return p.value
}

// Int16 is a thread-safe int16 implementation.
type Int16 struct {
	sync.RWMutex
	value int16
}

// NewInt16 will return a pointer to a new Int16 instance.
func NewInt16() *Int16 {
	return &Int16{}
}

// Get will return the current value.
func (p *Int16) Get() int16 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Int16) Set(val int16) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Int16) UnsafeSet(val int16) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) EqualSet(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) NotEqualSet(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterEqualSet(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessEqualSet(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterAdd(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterEqualAdd(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessAdd(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessEqualAdd(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterDec(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterEqualDec(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessDec(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessEqualDec(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterInc(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterEqualInc(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessInc(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessEqualInc(expected int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterSub(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) GreaterEqualSub(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessSub(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int16) LessEqualSub(expected int16, val int16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Int16) Add(value int16) int16 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Int16) Dec() int16 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Int16) Inc() int16 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Int16) Sub(value int16) int16 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Int16) UnsafeAdd(value int16) int16 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Int16) UnsafeDec() int16 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Int16) UnsafeInc() int16 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Int16) UnsafeSub(value int16) int16 {
	p.value -= value
	return p.value
}

// Int32 is a thread-safe int32 implementation.
type Int32 struct {
	sync.RWMutex
	value int32
}

// NewInt32 will return a pointer to a new Int32 instance.
func NewInt32() *Int32 {
	return &Int32{}
}

// Get will return the current value.
func (p *Int32) Get() int32 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Int32) Set(val int32) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Int32) UnsafeSet(val int32) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) EqualSet(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) NotEqualSet(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterEqualSet(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessEqualSet(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterAdd(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterEqualAdd(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessAdd(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessEqualAdd(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterDec(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterEqualDec(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessDec(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessEqualDec(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterInc(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterEqualInc(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessInc(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessEqualInc(expected int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterSub(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) GreaterEqualSub(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessSub(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int32) LessEqualSub(expected int32, val int32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Int32) Add(value int32) int32 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Int32) Dec() int32 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Int32) Inc() int32 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Int32) Sub(value int32) int32 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Int32) UnsafeAdd(value int32) int32 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Int32) UnsafeDec() int32 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Int32) UnsafeInc() int32 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Int32) UnsafeSub(value int32) int32 {
	p.value -= value
	return p.value
}

// Int64 is a thread-safe int64 implementation.
type Int64 struct {
	sync.RWMutex
	value int64
}

// NewInt64 will return a pointer to a new Int64 instance.
func NewInt64() *Int64 {
	return &Int64{}
}

// Get will return the current value.
func (p *Int64) Get() int64 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Int64) Set(val int64) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Int64) UnsafeSet(val int64) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) EqualSet(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) NotEqualSet(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterEqualSet(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessEqualSet(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterAdd(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterEqualAdd(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessAdd(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessEqualAdd(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterDec(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterEqualDec(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessDec(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessEqualDec(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterInc(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterEqualInc(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessInc(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessEqualInc(expected int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterSub(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) GreaterEqualSub(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessSub(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Int64) LessEqualSub(expected int64, val int64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Int64) Add(value int64) int64 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Int64) Dec() int64 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Int64) Inc() int64 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Int64) Sub(value int64) int64 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Int64) UnsafeAdd(value int64) int64 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Int64) UnsafeDec() int64 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Int64) UnsafeInc() int64 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Int64) UnsafeSub(value int64) int64 {
	p.value -= value
	return p.value
}

// String is a thread-safe string implementation.
type String struct {
	sync.RWMutex
	value string
}

// NewString will return a pointer to a new String instance.
func NewString() *String {
	return &String{}
}

// Get will return the current value.
func (p *String) Get() string {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *String) Set(val string) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *String) UnsafeSet(val string) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *String) EqualSet(expected string, val string) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *String) NotEqualSet(expected string, val string) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *String) GreaterEqualSet(expected string, val string) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *String) LessEqualSet(expected string, val string) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// Uint is a thread-safe uint implementation.
type Uint struct {
	sync.RWMutex
	value uint
}

// NewUint will return a pointer to a new Uint instance.
func NewUint() *Uint {
	return &Uint{}
}

// Get will return the current value.
func (p *Uint) Get() uint {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Uint) Set(val uint) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Uint) UnsafeSet(val uint) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) EqualSet(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) NotEqualSet(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterEqualSet(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessEqualSet(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterAdd(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterEqualAdd(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessAdd(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessEqualAdd(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterDec(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterEqualDec(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessDec(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessEqualDec(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterInc(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterEqualInc(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessInc(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessEqualInc(expected uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterSub(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) GreaterEqualSub(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessSub(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint) LessEqualSub(expected uint, val uint) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Uint) Add(value uint) uint {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Uint) Dec() uint {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Uint) Inc() uint {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Uint) Sub(value uint) uint {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Uint) UnsafeAdd(value uint) uint {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Uint) UnsafeDec() uint {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Uint) UnsafeInc() uint {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Uint) UnsafeSub(value uint) uint {
	p.value -= value
	return p.value
}

// Uint8 is a thread-safe uint8 implementation.
type Uint8 struct {
	sync.RWMutex
	value uint8
}

// NewUint8 will return a pointer to a new Uint8 instance.
func NewUint8() *Uint8 {
	return &Uint8{}
}

// Get will return the current value.
func (p *Uint8) Get() uint8 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Uint8) Set(val uint8) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Uint8) UnsafeSet(val uint8) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) EqualSet(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) NotEqualSet(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterEqualSet(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessEqualSet(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterAdd(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterEqualAdd(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessAdd(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessEqualAdd(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterDec(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterEqualDec(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessDec(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessEqualDec(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterInc(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterEqualInc(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessInc(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessEqualInc(expected uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterSub(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) GreaterEqualSub(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessSub(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint8) LessEqualSub(expected uint8, val uint8) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Uint8) Add(value uint8) uint8 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Uint8) Dec() uint8 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Uint8) Inc() uint8 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Uint8) Sub(value uint8) uint8 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Uint8) UnsafeAdd(value uint8) uint8 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Uint8) UnsafeDec() uint8 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Uint8) UnsafeInc() uint8 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Uint8) UnsafeSub(value uint8) uint8 {
	p.value -= value
	return p.value
}

// Uint16 is a thread-safe uint16 implementation.
type Uint16 struct {
	sync.RWMutex
	value uint16
}

// NewUint16 will return a pointer to a new Uint16 instance.
func NewUint16() *Uint16 {
	return &Uint16{}
}

// Get will return the current value.
func (p *Uint16) Get() uint16 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Uint16) Set(val uint16) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Uint16) UnsafeSet(val uint16) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) EqualSet(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) NotEqualSet(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterEqualSet(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessEqualSet(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterAdd(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterEqualAdd(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessAdd(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessEqualAdd(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterDec(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterEqualDec(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessDec(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessEqualDec(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterInc(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterEqualInc(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessInc(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessEqualInc(expected uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterSub(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) GreaterEqualSub(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessSub(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint16) LessEqualSub(expected uint16, val uint16) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Uint16) Add(value uint16) uint16 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Uint16) Dec() uint16 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Uint16) Inc() uint16 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Uint16) Sub(value uint16) uint16 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Uint16) UnsafeAdd(value uint16) uint16 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Uint16) UnsafeDec() uint16 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Uint16) UnsafeInc() uint16 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Uint16) UnsafeSub(value uint16) uint16 {
	p.value -= value
	return p.value
}

// Uint32 is a thread-safe uint32 implementation.
type Uint32 struct {
	sync.RWMutex
	value uint32
}

// NewUint32 will return a pointer to a new Uint32 instance.
func NewUint32() *Uint32 {
	return &Uint32{}
}

// Get will return the current value.
func (p *Uint32) Get() uint32 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Uint32) Set(val uint32) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Uint32) UnsafeSet(val uint32) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) EqualSet(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) NotEqualSet(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterEqualSet(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessEqualSet(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterAdd(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterEqualAdd(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessAdd(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessEqualAdd(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterDec(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterEqualDec(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessDec(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessEqualDec(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterInc(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterEqualInc(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessInc(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessEqualInc(expected uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterSub(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) GreaterEqualSub(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessSub(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint32) LessEqualSub(expected uint32, val uint32) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Uint32) Add(value uint32) uint32 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Uint32) Dec() uint32 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Uint32) Inc() uint32 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Uint32) Sub(value uint32) uint32 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Uint32) UnsafeAdd(value uint32) uint32 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Uint32) UnsafeDec() uint32 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Uint32) UnsafeInc() uint32 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Uint32) UnsafeSub(value uint32) uint32 {
	p.value -= value
	return p.value
}

// Uint64 is a thread-safe uint64 implementation.
type Uint64 struct {
	sync.RWMutex
	value uint64
}

// NewUint64 will return a pointer to a new Uint64 instance.
func NewUint64() *Uint64 {
	return &Uint64{}
}

// Get will return the current value.
func (p *Uint64) Get() uint64 {
	p.RLock()
	defer p.RUnlock()

	return p.value
}

// Set will set the current value.
func (p *Uint64) Set(val uint64) {
	p.Lock()
	defer p.Unlock()

	p.value = val
}

// UnsafeSet will set the current value, with no Lock.
func (p *Uint64) UnsafeSet(val uint64) {
	p.value = val
}

// EqualSet will check if the value is == the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) EqualSet(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value == expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// NotEqualSet will check if the value is != the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) NotEqualSet(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value != expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterEqualSet will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterEqualSet(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// LessEqualSet will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessEqualSet(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSet(val)
		return true
	}

	return false
}

// GreaterAdd will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterAdd(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterEqualAdd will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterEqualAdd(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessAdd will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessAdd(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// LessEqualAdd will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessEqualAdd(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeAdd(val)
		return true
	}

	return false
}

// GreaterDec will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterDec(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterEqualDec will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterEqualDec(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessDec will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessDec(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// LessEqualDec will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessEqualDec(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeDec()
		return true
	}

	return false
}

// GreaterInc will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterInc(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterEqualInc will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterEqualInc(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessInc will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessInc(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// LessEqualInc will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessEqualInc(expected uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeInc()
		return true
	}

	return false
}

// GreaterSub will check if the value is > the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterSub(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value > expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// GreaterEqualSub will check if the value is >= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) GreaterEqualSub(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value >= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessSub will check if the value is < the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessSub(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value < expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// LessEqualSub will check if the value is <= the expected value. If
// it is, it will call the appropriate function and return true,
// otherwise it will simply return false.
func (p *Uint64) LessEqualSub(expected uint64, val uint64) bool {
	p.Lock()
	defer p.Unlock()

	if p.value <= expected {
		p.UnsafeSub(val)
		return true
	}

	return false
}

// Add will add the value and return the new value.
func (p *Uint64) Add(value uint64) uint64 {
	p.Lock()
	defer p.Unlock()

	p.value += value

	return p.value
}

// Dec will decrement the current value by 1 and return the new value.
func (p *Uint64) Dec() uint64 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeSub(1)
}

// Inc will increment the current value by 1 and return the new value.
func (p *Uint64) Inc() uint64 {
	p.Lock()
	defer p.Unlock()

	return p.UnsafeAdd(1)
}

// Sub will subtract the value and return the new value.
func (p *Uint64) Sub(value uint64) uint64 {
	p.Lock()
	defer p.Unlock()

	p.value -= value

	return p.value
}

// UnsafeAdd will add the value and return the new value, with no
// Lock.
func (p *Uint64) UnsafeAdd(value uint64) uint64 {
	p.value += value
	return p.value
}

// UnsafeDec will decrement the current value by 1 and return the new
// value, with no Lock.
func (p *Uint64) UnsafeDec() uint64 {
	return p.UnsafeSub(1)
}

// UnsafeInc will increment the current value by 1 and return the new
// value, with no Lock.
func (p *Uint64) UnsafeInc() uint64 {
	return p.UnsafeAdd(1)
}

// UnsafeSub will subtract the value and return the new value, with no
// Lock.
func (p *Uint64) UnsafeSub(value uint64) uint64 {
	p.value -= value
	return p.value
}
