// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Identity Domains API
//
// Use the Identity Domains API to manage resources within an identity domain, for example, users, dynamic resource groups, groups, and identity providers. For information about managing resources within identity domains, see Identity and Access Management (with identity domains) (https://docs.oracle.com/iaas/Content/Identity/home.htm).
// Use this pattern to construct endpoints for identity domains: `https://<domainURL>/admin/v1/`. See Finding an Identity Domain URL (https://docs.oracle.com/en-us/iaas/Content/Identity/api-getstarted/locate-identity-domain-url.htm) to locate the domain URL you need.
// Use the table of contents and search tool to explore the Identity Domains API.
//

package identitydomains

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// AuthenticationFactorSettingsBypassCodeSettings Settings related to the bypass code, such as bypass code length, bypass code expiry, max active bypass codes, and so on
// **SCIM++ Properties:**
//   - idcsSearchable: false
//   - multiValued: false
//   - mutability: readWrite
//   - required: true
//   - returned: default
//   - type: complex
//   - uniqueness: none
type AuthenticationFactorSettingsBypassCodeSettings struct {

	// If true, indicates that self-service bypass code generation is enabled
	// **SCIM++ Properties:**
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: boolean
	//  - uniqueness: none
	SelfServiceGenerationEnabled *bool `mandatory:"true" json:"selfServiceGenerationEnabled"`

	// If true, indicates that help desk bypass code generation is enabled
	// **SCIM++ Properties:**
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: boolean
	//  - uniqueness: none
	HelpDeskGenerationEnabled *bool `mandatory:"true" json:"helpDeskGenerationEnabled"`

	// Exact length of the bypass code to be generated
	// **SCIM++ Properties:**
	//  - idcsMaxValue: 20
	//  - idcsMinValue: 8
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: integer
	//  - uniqueness: none
	Length *int `mandatory:"true" json:"length"`

	// The maximum number of bypass codes that can be issued to any user
	// **SCIM++ Properties:**
	//  - idcsMaxValue: 6
	//  - idcsMinValue: 1
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: integer
	//  - uniqueness: none
	MaxActive *int `mandatory:"true" json:"maxActive"`

	// Expiry (in minutes) of any bypass code that is generated by the help desk
	// **SCIM++ Properties:**
	//  - idcsMaxValue: 9999999
	//  - idcsMinValue: 1
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: integer
	//  - uniqueness: none
	HelpDeskCodeExpiryInMins *int `mandatory:"true" json:"helpDeskCodeExpiryInMins"`

	// The maximum number of times that any bypass code that is generated by the help desk can be used
	// **SCIM++ Properties:**
	//  - idcsMaxValue: 999
	//  - idcsMinValue: 1
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: integer
	//  - uniqueness: none
	HelpDeskMaxUsage *int `mandatory:"true" json:"helpDeskMaxUsage"`
}

func (m AuthenticationFactorSettingsBypassCodeSettings) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m AuthenticationFactorSettingsBypassCodeSettings) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
