// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Stack Monitoring API
//
// Stack Monitoring API.
//

package stackmonitoring

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// AgentExtensionHandlerConfiguration Specific resource mapping configurations for Agent Extension Handlers.
type AgentExtensionHandlerConfiguration struct {

	// List of collector/plugin names.
	CollectorTypes []string `mandatory:"true" json:"collectorTypes"`

	// Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
	// configured interval expires will be dropped.
	MetricUploadIntervalInSeconds *int `mandatory:"false" json:"metricUploadIntervalInSeconds"`

	// Resource group string; if not specified, the resource group string will be generated by the handler.
	TelemetryResourceGroup *string `mandatory:"false" json:"telemetryResourceGroup"`

	TelegrafResourceNameConfig *TelegrafResourceNameConfigurationDetails `mandatory:"false" json:"telegrafResourceNameConfig"`

	CollectdResourceNameConfig *CollectdResourceNameConfigurationDetails `mandatory:"false" json:"collectdResourceNameConfig"`

	MetricNameConfig *MetricNameConfigurationDetails `mandatory:"false" json:"metricNameConfig"`

	// List of AgentExtensionHandlerMetricMappingDetails.
	MetricMappings []AgentExtensionHandlerMetricMappingDetails `mandatory:"false" json:"metricMappings"`

	// List of handler configuration properties
	HandlerProperties []AgentExtensionHandlerConfigurationProperty `mandatory:"false" json:"handlerProperties"`
}

func (m AgentExtensionHandlerConfiguration) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m AgentExtensionHandlerConfiguration) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
