// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListContainerScanTargetsRequest wrapper for the ListContainerScanTargets operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListContainerScanTargets.go.html to see an example of how to use ListContainerScanTargetsRequest.
type ListContainerScanTargetsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources whose lifecycleState matches the given lifecycleState.
	LifecycleState ListContainerScanTargetsLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListContainerScanTargetsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending. If no value is specified timeCreated is default.
	SortBy ListContainerScanTargetsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListContainerScanTargetsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListContainerScanTargetsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListContainerScanTargetsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListContainerScanTargetsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListContainerScanTargetsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListContainerScanTargetsLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListContainerScanTargetsLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListContainerScanTargetsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListContainerScanTargetsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListContainerScanTargetsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListContainerScanTargetsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListContainerScanTargetsResponse wrapper for the ListContainerScanTargets operation
type ListContainerScanTargetsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of ContainerScanTargetSummaryCollection instances
	ContainerScanTargetSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListContainerScanTargetsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListContainerScanTargetsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListContainerScanTargetsLifecycleStateEnum Enum with underlying type: string
type ListContainerScanTargetsLifecycleStateEnum string

// Set of constants representing the allowable values for ListContainerScanTargetsLifecycleStateEnum
const (
	ListContainerScanTargetsLifecycleStateCreating ListContainerScanTargetsLifecycleStateEnum = "CREATING"
	ListContainerScanTargetsLifecycleStateUpdating ListContainerScanTargetsLifecycleStateEnum = "UPDATING"
	ListContainerScanTargetsLifecycleStateActive   ListContainerScanTargetsLifecycleStateEnum = "ACTIVE"
	ListContainerScanTargetsLifecycleStateDeleting ListContainerScanTargetsLifecycleStateEnum = "DELETING"
	ListContainerScanTargetsLifecycleStateDeleted  ListContainerScanTargetsLifecycleStateEnum = "DELETED"
	ListContainerScanTargetsLifecycleStateFailed   ListContainerScanTargetsLifecycleStateEnum = "FAILED"
)

var mappingListContainerScanTargetsLifecycleStateEnum = map[string]ListContainerScanTargetsLifecycleStateEnum{
	"CREATING": ListContainerScanTargetsLifecycleStateCreating,
	"UPDATING": ListContainerScanTargetsLifecycleStateUpdating,
	"ACTIVE":   ListContainerScanTargetsLifecycleStateActive,
	"DELETING": ListContainerScanTargetsLifecycleStateDeleting,
	"DELETED":  ListContainerScanTargetsLifecycleStateDeleted,
	"FAILED":   ListContainerScanTargetsLifecycleStateFailed,
}

var mappingListContainerScanTargetsLifecycleStateEnumLowerCase = map[string]ListContainerScanTargetsLifecycleStateEnum{
	"creating": ListContainerScanTargetsLifecycleStateCreating,
	"updating": ListContainerScanTargetsLifecycleStateUpdating,
	"active":   ListContainerScanTargetsLifecycleStateActive,
	"deleting": ListContainerScanTargetsLifecycleStateDeleting,
	"deleted":  ListContainerScanTargetsLifecycleStateDeleted,
	"failed":   ListContainerScanTargetsLifecycleStateFailed,
}

// GetListContainerScanTargetsLifecycleStateEnumValues Enumerates the set of values for ListContainerScanTargetsLifecycleStateEnum
func GetListContainerScanTargetsLifecycleStateEnumValues() []ListContainerScanTargetsLifecycleStateEnum {
	values := make([]ListContainerScanTargetsLifecycleStateEnum, 0)
	for _, v := range mappingListContainerScanTargetsLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanTargetsLifecycleStateEnumStringValues Enumerates the set of values in String for ListContainerScanTargetsLifecycleStateEnum
func GetListContainerScanTargetsLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"UPDATING",
		"ACTIVE",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListContainerScanTargetsLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanTargetsLifecycleStateEnum(val string) (ListContainerScanTargetsLifecycleStateEnum, bool) {
	enum, ok := mappingListContainerScanTargetsLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListContainerScanTargetsSortOrderEnum Enum with underlying type: string
type ListContainerScanTargetsSortOrderEnum string

// Set of constants representing the allowable values for ListContainerScanTargetsSortOrderEnum
const (
	ListContainerScanTargetsSortOrderAsc  ListContainerScanTargetsSortOrderEnum = "ASC"
	ListContainerScanTargetsSortOrderDesc ListContainerScanTargetsSortOrderEnum = "DESC"
)

var mappingListContainerScanTargetsSortOrderEnum = map[string]ListContainerScanTargetsSortOrderEnum{
	"ASC":  ListContainerScanTargetsSortOrderAsc,
	"DESC": ListContainerScanTargetsSortOrderDesc,
}

var mappingListContainerScanTargetsSortOrderEnumLowerCase = map[string]ListContainerScanTargetsSortOrderEnum{
	"asc":  ListContainerScanTargetsSortOrderAsc,
	"desc": ListContainerScanTargetsSortOrderDesc,
}

// GetListContainerScanTargetsSortOrderEnumValues Enumerates the set of values for ListContainerScanTargetsSortOrderEnum
func GetListContainerScanTargetsSortOrderEnumValues() []ListContainerScanTargetsSortOrderEnum {
	values := make([]ListContainerScanTargetsSortOrderEnum, 0)
	for _, v := range mappingListContainerScanTargetsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanTargetsSortOrderEnumStringValues Enumerates the set of values in String for ListContainerScanTargetsSortOrderEnum
func GetListContainerScanTargetsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListContainerScanTargetsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanTargetsSortOrderEnum(val string) (ListContainerScanTargetsSortOrderEnum, bool) {
	enum, ok := mappingListContainerScanTargetsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListContainerScanTargetsSortByEnum Enum with underlying type: string
type ListContainerScanTargetsSortByEnum string

// Set of constants representing the allowable values for ListContainerScanTargetsSortByEnum
const (
	ListContainerScanTargetsSortByTimecreated ListContainerScanTargetsSortByEnum = "timeCreated"
	ListContainerScanTargetsSortByDisplayname ListContainerScanTargetsSortByEnum = "displayName"
)

var mappingListContainerScanTargetsSortByEnum = map[string]ListContainerScanTargetsSortByEnum{
	"timeCreated": ListContainerScanTargetsSortByTimecreated,
	"displayName": ListContainerScanTargetsSortByDisplayname,
}

var mappingListContainerScanTargetsSortByEnumLowerCase = map[string]ListContainerScanTargetsSortByEnum{
	"timecreated": ListContainerScanTargetsSortByTimecreated,
	"displayname": ListContainerScanTargetsSortByDisplayname,
}

// GetListContainerScanTargetsSortByEnumValues Enumerates the set of values for ListContainerScanTargetsSortByEnum
func GetListContainerScanTargetsSortByEnumValues() []ListContainerScanTargetsSortByEnum {
	values := make([]ListContainerScanTargetsSortByEnum, 0)
	for _, v := range mappingListContainerScanTargetsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListContainerScanTargetsSortByEnumStringValues Enumerates the set of values in String for ListContainerScanTargetsSortByEnum
func GetListContainerScanTargetsSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListContainerScanTargetsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListContainerScanTargetsSortByEnum(val string) (ListContainerScanTargetsSortByEnum, bool) {
	enum, ok := mappingListContainerScanTargetsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
