// Code generated by go-swagger; DO NOT EDIT.

package product_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new product service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for product service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ProductServiceEstimateCost(params *ProductServiceEstimateCostParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProductServiceEstimateCostOK, error)

	ProductServiceListAvailablePackages(params *ProductServiceListAvailablePackagesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProductServiceListAvailablePackagesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ProductServiceEstimateCost estimates cost returns hourly and monthly pricing information for a given package for the given resource type
*/
func (a *Client) ProductServiceEstimateCost(params *ProductServiceEstimateCostParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProductServiceEstimateCostOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProductServiceEstimateCostParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProductService_EstimateCost",
		Method:             "PUT",
		PathPattern:        "/billing/2020-11-05/organizations/{organization_id}/estimateCost",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProductServiceEstimateCostReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProductServiceEstimateCostOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProductServiceEstimateCostDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProductServiceListAvailablePackages product service list available packages API
*/
func (a *Client) ProductServiceListAvailablePackages(params *ProductServiceListAvailablePackagesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProductServiceListAvailablePackagesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProductServiceListAvailablePackagesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProductService_ListAvailablePackages",
		Method:             "GET",
		PathPattern:        "/billing/2020-11-05/packages",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProductServiceListAvailablePackagesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProductServiceListAvailablePackagesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProductServiceListAvailablePackagesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
