// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetSyncInstallationParams creates a new GetSyncInstallationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetSyncInstallationParams() *GetSyncInstallationParams {
	return &GetSyncInstallationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetSyncInstallationParamsWithTimeout creates a new GetSyncInstallationParams object
// with the ability to set a timeout on a request.
func NewGetSyncInstallationParamsWithTimeout(timeout time.Duration) *GetSyncInstallationParams {
	return &GetSyncInstallationParams{
		timeout: timeout,
	}
}

// NewGetSyncInstallationParamsWithContext creates a new GetSyncInstallationParams object
// with the ability to set a context for a request.
func NewGetSyncInstallationParamsWithContext(ctx context.Context) *GetSyncInstallationParams {
	return &GetSyncInstallationParams{
		Context: ctx,
	}
}

// NewGetSyncInstallationParamsWithHTTPClient creates a new GetSyncInstallationParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetSyncInstallationParamsWithHTTPClient(client *http.Client) *GetSyncInstallationParams {
	return &GetSyncInstallationParams{
		HTTPClient: client,
	}
}

/*
GetSyncInstallationParams contains all the parameters to send to the API endpoint

	for the get sync installation operation.

	Typically these are written to a http.Request.
*/
type GetSyncInstallationParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// Name.
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get sync installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSyncInstallationParams) WithDefaults() *GetSyncInstallationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get sync installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSyncInstallationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get sync installation params
func (o *GetSyncInstallationParams) WithTimeout(timeout time.Duration) *GetSyncInstallationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get sync installation params
func (o *GetSyncInstallationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get sync installation params
func (o *GetSyncInstallationParams) WithContext(ctx context.Context) *GetSyncInstallationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get sync installation params
func (o *GetSyncInstallationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get sync installation params
func (o *GetSyncInstallationParams) WithHTTPClient(client *http.Client) *GetSyncInstallationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get sync installation params
func (o *GetSyncInstallationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the get sync installation params
func (o *GetSyncInstallationParams) WithLocationOrganizationID(locationOrganizationID string) *GetSyncInstallationParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get sync installation params
func (o *GetSyncInstallationParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get sync installation params
func (o *GetSyncInstallationParams) WithLocationProjectID(locationProjectID string) *GetSyncInstallationParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get sync installation params
func (o *GetSyncInstallationParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get sync installation params
func (o *GetSyncInstallationParams) WithLocationRegionProvider(locationRegionProvider *string) *GetSyncInstallationParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get sync installation params
func (o *GetSyncInstallationParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get sync installation params
func (o *GetSyncInstallationParams) WithLocationRegionRegion(locationRegionRegion *string) *GetSyncInstallationParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get sync installation params
func (o *GetSyncInstallationParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithName adds the name to the get sync installation params
func (o *GetSyncInstallationParams) WithName(name string) *GetSyncInstallationParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the get sync installation params
func (o *GetSyncInstallationParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *GetSyncInstallationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
